/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.constant.DongguanBankConfig;
import cn.com.duiba.credits.sdk.CreditConsumeParams;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.dongguanbank.MD5Util;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DongguanBankApi {
    public static final Logger LOG = LoggerFactory.getLogger(DongguanBankApi.class);
    @Autowired
    private DongguanBankConfig dongguanBankConfig;

    public boolean isDongguanBank(Long appId) {
        return this.dongguanBankConfig.isDongguanBank(appId);
    }

    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        CreditConsumeParams creditConsumeParams = message.getSubCreditsMsg().getCreditConsumeParams();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("thirdCode", this.dongguanBankConfig.getThirdCode());
        String refrenceNo = this.compressOrderNum(creditConsumeParams.getOrderNum());
        params.put("refrenceNo", refrenceNo);
        params.put("score", creditConsumeParams.getCredits());
        params.put("clientId", creditConsumeParams.getUid());
        params.put("timestamp", creditConsumeParams.getTimestamp().getTime());
        params.put("sign", this.sign(this.dongguanBankConfig.getThirdCode(), refrenceNo, creditConsumeParams.getCredits(), creditConsumeParams.getUid(), creditConsumeParams.getTimestamp().getTime()));
        String newUrl = message.getHttpUrl().substring(0, message.getHttpUrl().indexOf(63));
        HttpPost request = new HttpPost(newUrl);
        request.setEntity((HttpEntity)new StringEntity(JSON.toJSONString(params), ContentType.APPLICATION_JSON));
        message.setHttpUrl(newUrl);
        LOG.info("[dongguanbank]\u4e1c\u839e\u94f6\u884c\u6263\u79ef\u5206\u8bf7\u6c42 orderNum={}, url={}, params={}", new Object[]{creditConsumeParams.getOrderNum(), message.getHttpUrl(), JSON.toJSONString(params)});
        return request;
    }

    private String compressOrderNum(String orderNum) {
        String orderId;
        int split = orderNum.indexOf(45);
        String string = orderId = split < 0 ? orderNum : orderNum.substring(split + 1);
        if (StringUtils.contains((CharSequence)orderId, (int)67)) {
            orderId = StringUtils.replace((String)orderId, (String)"C", (String)"");
        }
        if (!StringUtils.isNumeric((CharSequence)orderId)) {
            return this.generateDefaultOrderNum();
        }
        StringBuilder sb = new StringBuilder(20);
        if (split > 0) {
            sb.append(orderNum, 0, split).append('-');
        }
        sb.append(new BigInteger(orderId).toString(36));
        return sb.length() > 20 ? this.generateDefaultOrderNum() : sb.toString();
    }

    private String generateDefaultOrderNum() {
        return "sys-" + BigInteger.valueOf(System.currentTimeMillis()).toString(36);
    }

    private String sign(Object ... params) {
        try {
            return MD5Util.md5(StringUtils.join((Object[])params), this.dongguanBankConfig.getSaltKey());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public String parseCreditsResponse(String body) {
        LOG.info("[dongguanbank]\u4e1c\u839e\u94f6\u884c\u6263\u79ef\u5206\u8bf7\u6c42\u7ed3\u679c {}", (Object)body);
        JSONObject json = JSON.parseObject((String)body);
        JSONObject result = new JSONObject();
        if (Objects.equals("S0000", json.getString("returnCode"))) {
            result.put("status", (Object)"ok");
            result.put("bizId", (Object)(System.currentTimeMillis() + RandomStringUtils.randomNumeric((int)6)));
        } else {
            result.put("status", (Object)"fail");
            result.put("errorMessage", (Object)json.getString("returnMsg"));
        }
        return result.toJSONString();
    }

    public HttpRequestBase getSubCreditsHttpRequest(CreditsMessage message) {
        String url = message.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf(63));
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> authParams = AssembleTool.getUrlParams(paramsStr);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("thirdCode", this.dongguanBankConfig.getThirdCode());
        String refrenceNo = this.compressOrderNum(authParams.get("orderNum"));
        params.put("refrenceNo", refrenceNo);
        params.put("score", authParams.get("credits"));
        params.put("clientId", authParams.get("uid"));
        params.put("timestamp", authParams.get("timestamp"));
        params.put("sign", this.sign(this.dongguanBankConfig.getThirdCode(), refrenceNo, authParams.get("credits"), authParams.get("uid"), authParams.get("timestamp")));
        HttpPost request = new HttpPost(newUrl);
        request.setEntity((HttpEntity)new StringEntity(JSON.toJSONString(params), ContentType.APPLICATION_JSON));
        message.setHttpUrl(newUrl);
        LOG.info("[dongguanbank]\u4e1c\u839e\u94f6\u884c\u6263\u79ef\u5206\u8bf7\u6c42 orderNum={}, url={}, params={}", new Object[]{authParams.get("orderNum"), message.getHttpUrl(), JSON.toJSONString(params)});
        return request;
    }
}

