/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.constant.ErweihuoConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.ErweihuoRopUtils;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ErweihuoApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErweihuoApi.class);
    private static final String LANGUAGE = "zh_CN";
    private static final String DELIMITER = "?";
    @Autowired
    private ErweihuoConfig erweihuoConfig;

    public boolean isErweihuo(Long appId) {
        return appId != null && this.erweihuoConfig.getAppIds() != null && this.erweihuoConfig.getAppIds().contains(appId);
    }

    public SubCreditsMsgWrapper getSubCredits(SubCreditsMsgWrapper request) {
        try {
            String url = request.getHttpUrl();
            String host = this.getGateway(url);
            Map<String, String> paramsMap = this.bulidParms(request.getSubCreditsMsg().getAuthParams(), this.erweihuoConfig.getSubCreditsMethod());
            request.getSubCreditsMsg().setAuthParams(paramsMap);
            request.getSubCreditsMsg().setHttpType(2);
            request.setHttpUrl(AssembleTool.assembleUrl(host, paramsMap));
        }
        catch (Exception e) {
            LOGGER.warn("[ErweihuoApi- \u6784\u5efa\u6263\u79ef\u5206\u53c2\u6570\u5f02\u5e38]error:{}", (Throwable)e);
        }
        return request;
    }

    public CreditsMessage getSubCredits(CreditsMessage request) {
        try {
            String url = request.getHttpUrl();
            String host = this.getGateway(url);
            Map<String, String> paramsMap = this.bulidParms(request.getAuthParams(), this.erweihuoConfig.getSubCreditsMethod());
            request.setAuthParams(paramsMap);
            request.setHttpType("post");
            request.setHttpUrl(AssembleTool.assembleUrl(host, paramsMap));
        }
        catch (Exception e) {
            LOGGER.warn("[ErweihuoApi- \u6784\u5efa\u6263\u79ef\u5206\u53c2\u6570\u5f02\u5e38]error:{}", (Throwable)e);
        }
        return request;
    }

    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) {
        try {
            String url = request.getHttpUrl();
            String host = this.getGateway(url);
            request.setHttpType("post");
            Map<String, String> paramsMap = this.bulidParms(request.getAuthParams(), this.erweihuoConfig.getAddCreditsMethod());
            request.setAuthParams(paramsMap);
            request.setHttpUrl(AssembleTool.assembleUrl(host, paramsMap));
        }
        catch (Exception e) {
            LOGGER.warn("[ErweihuoApi- \u6784\u5efa\u52a0\u79ef\u5206\u53c2\u6570\u5f02\u5e38]error:{}", (Throwable)e);
        }
        return request;
    }

    public CreditsMessageDto getQueryCreditsMessage(CreditsMessageDto request) {
        try {
            String url = request.getHttpUrl();
            String host = this.getGateway(url);
            request.setHttpType("post");
            Map<String, String> paramsMap = this.bulidQueryParms(request.getAuthParams(), this.erweihuoConfig.getQueryCreditsMethod());
            request.setAuthParams(paramsMap);
            request.setHttpUrl(AssembleTool.assembleUrl(host, paramsMap));
        }
        catch (Exception e) {
            LOGGER.warn("[ErweihuoApi- \u6784\u5efa\u67e5\u8be2\u79ef\u5206\u53c2\u6570\u5f02\u5e38]error:{}", (Throwable)e);
        }
        return request;
    }

    public String parseCrditsRsp(String body) {
        try {
            String bodyTemp = URLDecoder.decode(body, "utf-8");
            JSONObject jsonObject = JSONObject.parseObject((String)bodyTemp);
            HashMap map = Maps.newHashMap();
            if ("1".equals(jsonObject.getString("code"))) {
                map.put("status", "ok");
                map.put("bizId", String.valueOf(new Date().getTime()));
            } else {
                map.put("errorCode", jsonObject.getString("errorCode"));
                map.put("status", "no");
                map.put("errorMessage", jsonObject.getString("message"));
            }
            return JsonTool.objectToJson(map);
        }
        catch (Exception e) {
            LOGGER.info("erweihuo parseCrditsRsp error,boby is {}", (Object)body, (Object)e);
            return body;
        }
    }

    public Object parseQueryCrditsRsp(String body) {
        try {
            String bodyTemp = URLDecoder.decode(body, "utf-8");
            JSONObject jsonObject = JSONObject.parseObject((String)bodyTemp);
            if ("1".equals(jsonObject.getString("code"))) {
                JSONObject dataJsonObject;
                Object creditsData;
                Object data = jsonObject.get((Object)"data");
                if (data != null && (creditsData = (dataJsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)data))).get((Object)"data")) != null) {
                    JSONObject creditsJsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)creditsData));
                    return creditsJsonObject.get((Object)"degree");
                }
                return null;
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.info("erweihuo parseQueryCrditsRsp error,boby is {}", (Object)body, (Object)e);
            return null;
        }
    }

    private Map<String, String> bulidParms(Map<String, String> originalParams, String method) throws IOException {
        HashMap form = Maps.newHashMap();
        form.put("method", method);
        form.put("appKey", this.erweihuoConfig.getAppKey());
        form.put("v", this.erweihuoConfig.getVersion());
        form.put("lang", LANGUAGE);
        form.put("timestamp", String.valueOf(System.currentTimeMillis()));
        form.put("env", this.erweihuoConfig.getEnv());
        form.put("num", originalParams.get("credits"));
        form.put("customerRegisterId", originalParams.get("uid"));
        form.put("mobile", "");
        form.put("countryCode", "");
        form.put("shopEntityId", this.erweihuoConfig.getShopEntityId());
        form.put("entityId", this.erweihuoConfig.getEntityId());
        form.put("thirdFlowId", originalParams.get("orderNum"));
        form.put("memo", originalParams.get("description") != null ? originalParams.get("description") : "");
        String sign = ErweihuoRopUtils.sign(form, this.erweihuoConfig.getAppSecret());
        form.put("sign", sign);
        return form;
    }

    private Map<String, String> bulidQueryParms(Map<String, String> originalParams, String method) throws IOException {
        HashMap form = Maps.newHashMap();
        form.put("method", method);
        form.put("appKey", this.erweihuoConfig.getAppKey());
        form.put("v", this.erweihuoConfig.getVersion());
        form.put("lang", LANGUAGE);
        form.put("timestamp", String.valueOf(System.currentTimeMillis()));
        form.put("env", this.erweihuoConfig.getEnv());
        form.put("customerRegisterId", originalParams.get("customerRegisterId"));
        form.put("mobile", "");
        form.put("countryCode", "");
        form.put("entityId", this.erweihuoConfig.getEntityId());
        String sign = ErweihuoRopUtils.sign(form, this.erweihuoConfig.getAppSecret());
        form.put("sign", sign);
        return form;
    }

    private String getGateway(String url) {
        int index;
        if (StringUtils.isNotBlank((String)url) && (index = url.indexOf(DELIMITER)) != -1) {
            return url.substring(0, index);
        }
        return url;
    }
}

