/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.config.JiuYangConfig;
import cn.com.duiba.credits.sdk.CreditNotifyParams;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpUtils;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.nascent.ecrp.opensdk.core.executeClient.ApiClientImpl;
import com.nascent.ecrp.opensdk.core.request.BaseRequest;
import com.nascent.ecrp.opensdk.core.request.IBaseRequest;
import com.nascent.ecrp.opensdk.core.util.SignUtils;
import com.nascent.ecrp.opensdk.domain.basis.AccessTokenDetail;
import com.nascent.ecrp.opensdk.request.basis.AccessTokenRegisterRequest;
import com.nascent.ecrp.opensdk.response.basis.AccessTokenRegisterResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class JiuYangApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiuYangApi.class);
    private static final String OPERATIONGROUPCODE = "JYSY";
    private static final String BRANDCODE = "Joyoung";
    private static final String CHANNELCODE = "JYQDJFSC";
    private static final String SPILT = "_";
    private static final String REIDS_TOKENKEY = "jiuyangToken_key";
    private static final String REIDS_VISUAL_TOKENKEY = "jiuyangToken_virual_key";
    @Autowired
    private JiuYangConfig jiuYangConfig;
    @Resource(name="httpClient")
    private CloseableHttpClient httpClient;
    @Resource(name="stringRedisTemplate")
    private StringRedisTemplate stringRedisTemplate;

    public Boolean isJiuYangAppid(Long appId) {
        return this.jiuYangConfig.isJiuYangAppid(appId);
    }

    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        try {
            SubCreditsMsgDto subCreditsMsgDto = subCreditsMsgWrapper.getSubCreditsMsg();
            subCreditsMsgDto.setHttpType(2);
            String url = subCreditsMsgWrapper.getHttpUrl();
            String host = url.substring(0, url.indexOf(63));
            subCreditsMsgWrapper.setHttpUrl(host);
            Map originAuthParams = subCreditsMsgDto.getAuthParams();
            HashMap authParams = Maps.newHashMap();
            authParams.put("operationGroupCode", OPERATIONGROUPCODE);
            authParams.put("brandCode", BRANDCODE);
            authParams.put("phone", originAuthParams.get("uid"));
            authParams.put("pointEventCode", "duihuan");
            authParams.put("productDescription", originAuthParams.get("description"));
            authParams.put("point", originAuthParams.get("credits"));
            authParams.put("channelCode", CHANNELCODE);
            authParams.put("bizOrder", originAuthParams.get("orderNum"));
            authParams.put("changeDate", DateUtils.getSecondStr((Date)new Date()));
            authParams.put("isJiuYangRequest", "ok");
            SubCreditsMsgDto msg2 = subCreditsMsgWrapper.getSubCreditsMsg();
            msg2.setAuthParams((Map)authParams);
            return subCreditsMsgWrapper;
        }
        catch (Exception e) {
            LOGGER.info("AbchinaApi call getSubCreditsMessage error , subCreditsMsgWrapper = {}", (Object)JSONObject.toJSONString((Object)subCreditsMsgWrapper), (Object)e);
            return subCreditsMsgWrapper;
        }
    }

    public void setJiuYangHttpHead(HttpRequestBase http, String appId) {
        String token = this.getToken(appId);
        http.setHeader("Authorization", token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sendGet(HttpClient httpClient, String url, Charset encoding) {
        HttpGet httpget = new HttpGet(url);
        String resp = "";
        CloseableHttpResponse response = null;
        try {
            response = (CloseableHttpResponse)httpClient.execute((HttpUriRequest)httpget);
            resp = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)encoding);
        }
        catch (IOException e) {
            LOGGER.warn("\u4e5d\u9633 \u83b7\u53d6token\u53d1\u9001get\u8bf7\u6c42\u5931\u8d25\uff0curl={}", (Object)url, (Object)e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    LOGGER.warn("\u4e5d\u9633  \u83b7\u53d6token\u5173\u95edresponse\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return resp;
    }

    public String parseCreditsRsp(String body) {
        JSONObject jsonBody;
        try {
            jsonBody = JSON.parseObject((String)body);
        }
        catch (Exception e) {
            LOGGER.error("jiuyangapi JSON.parseObject:body={},error={}", (Object)body, (Object)e.getMessage());
            return body;
        }
        JSONObject json = JsonTool.getAllJson(jsonBody);
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        Boolean wasSuccess = json.getBoolean("success");
        if (wasSuccess != null && wasSuccess.booleanValue()) {
            duibaDoc.put("status", "ok");
        } else {
            duibaDoc.put("status", "fail");
        }
        duibaDoc.put("errorMessage", json.getString("message"));
        duibaDoc.put("bizId", String.valueOf(System.currentTimeMillis()));
        duibaDoc.put("credits", json.getString("leftPoint"));
        return JsonTool.objectToJson(duibaDoc);
    }

    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) {
        String url = request.getHttpUrl();
        String host = url.substring(0, url.indexOf(63));
        request.setHttpUrl(host);
        Map originalParams = request.getAuthParams();
        HashMap authParams = Maps.newHashMap();
        authParams.put("operationGroupCode", OPERATIONGROUPCODE);
        authParams.put("brandCode", BRANDCODE);
        authParams.put("phone", originalParams.get("uid"));
        authParams.put("pointEventCode", "dbqiandao");
        authParams.put("point", originalParams.get("credits"));
        authParams.put("channelCode", CHANNELCODE);
        authParams.put("description", originalParams.get("description"));
        authParams.put("bizOrder", originalParams.get("orderNum"));
        authParams.put("changeDate", DateUtils.getSecondStr((Date)new Date()));
        authParams.put("isJiuYangRequest", "ok");
        request.setAuthParams((Map)authParams);
        request.setHttpType("post");
        return request;
    }

    public String getResponseNotify(String body) {
        try {
            JSONObject object = JSON.parseObject((String)body);
            if (object.getBoolean("success").booleanValue()) {
                return "ok";
            }
        }
        catch (Exception e) {
            LOGGER.warn(" jiuyangapi  getResponseNotify  body = {}", (Object)body, (Object)e);
        }
        return body;
    }

    public HttpRequestBase getRequestNotify(String notifyUrl, CreditNotifyParams params, Long appId) {
        HttpPost request = new HttpPost(notifyUrl);
        HashMap data = Maps.newHashMap();
        data.put("bizOrder", params.getOrderNum());
        data.put("type", "20");
        Map paramsMap = params.toRequestMap("");
        if (paramsMap.containsKey("uid")) {
            data.put("phone", paramsMap.get("uid"));
        }
        request.setHeader("Authorization", this.getToken(String.valueOf(appId)));
        request.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)data), ContentType.APPLICATION_JSON));
        request.addHeader("Accept", "application/json");
        request.addHeader("ContentType", "application/json;charset=UTF-8");
        return request;
    }

    public SupplierRequest getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String host = url.substring(0, url.indexOf(63));
        String urlParams = url.substring(url.indexOf(63) + 1, url.length());
        Map<String, String> crediMap = AssembleTool.getUrlParams(urlParams);
        HashMap data = Maps.newHashMap();
        data.put("appKey", this.jiuYangConfig.getVirualAppkey());
        data.put("nonce", System.currentTimeMillis());
        data.put("accessToken", this.getVirualToken(request.getAppId()));
        String[] customNums = crediMap.get("params").split("\\|");
        data.put("shopId", customNums != null && customNums.length == 2 ? customNums[1] : this.jiuYangConfig.getVirualShopId());
        data.put("couponCode", customNums[0]);
        data.put("groupId", this.jiuYangConfig.getVirualGroupId());
        ArrayList customerNickInfoBeans = Lists.newArrayList();
        VirualRequest.CustomerNickInfoBean customerNickInfoBean = new VirualRequest.CustomerNickInfoBean();
        customerNickInfoBean.setNick(crediMap.get("uid"));
        customerNickInfoBean.setPlatform(0);
        customerNickInfoBean.setSysCustomerId(0L);
        customerNickInfoBean.setOutCouponId("");
        customerNickInfoBeans.add(customerNickInfoBean);
        data.put("customerNickInfo", customerNickInfoBeans);
        data.put("sendChannelType", 2);
        data.put("sendChannelId", 0);
        data.put("sign", SignUtils.getSign((Map)data, (String)this.jiuYangConfig.getVirualAppSerect()));
        data.put("isJiuYangRequest", "ok");
        request.setHttpUrl(host);
        request.setAuthDatas(data);
        HashMap authData = Maps.newHashMap();
        authData.put("isJiuYangRequest", "ok");
        authData.put("getAuthDatas", "ok");
        request.setAuthParams(authData);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToken(String appId) {
        String contentEncoding = "UTF-8";
        String contentType = "application/json";
        String token = (String)this.stringRedisTemplate.opsForValue().get((Object)(REIDS_TOKENKEY + appId));
        if (StringUtils.isBlank((String)token)) {
            HttpPost httpPost = new HttpPost(this.jiuYangConfig.getGetTokenUrl());
            ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(2);
            pairs.add(new BasicNameValuePair("appid", this.jiuYangConfig.getJiuYangAppid()));
            pairs.add(new BasicNameValuePair("secret", this.jiuYangConfig.getJiuYangSercret()));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, Charset.forName("UTF-8")));
            CloseableHttpResponse httpResponse = null;
            String respon = "";
            try {
                HttpUtils.resetTimeOut((HttpRequestBase)httpPost);
                httpResponse = this.httpClient.execute((HttpUriRequest)httpPost);
                if (httpResponse != null) {
                    respon = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
                }
            }
            catch (IOException e) {
                LOGGER.warn("\u4e5d\u9633 \u83b7\u53d6token\u53d1\u9001get\u8bf7\u6c42\u5931\u8d25\uff0curl = {}", (Object)this.jiuYangConfig.getGetTokenUrl(), (Object)e);
            }
            finally {
                if (httpResponse != null) {
                    try {
                        httpResponse.close();
                    }
                    catch (IOException e) {
                        LOGGER.warn("\u4e5d\u9633  \u83b7\u53d6token\u5173\u95edresponse\u5931\u8d25", (Throwable)e);
                    }
                }
            }
            if (StringUtils.isNotBlank((String)respon)) {
                JSONObject dataStr = JSON.parseObject((String)respon);
                if ("success".equals(dataStr.getString("code"))) {
                    TokenResponData data = (TokenResponData)JSON.parseObject((String)dataStr.getString("data"), TokenResponData.class);
                    String accessToken = data.getAccessToken();
                    Integer expiresIn = data.getExpiresIn();
                    this.stringRedisTemplate.opsForValue().set((Object)(REIDS_TOKENKEY + appId), (Object)accessToken, (long)(expiresIn > 10 ? expiresIn - 10 : expiresIn), TimeUnit.SECONDS);
                    return accessToken;
                }
                LOGGER.warn("setJiuYangHttpHead \u8bf7\u6c42token \u5931\u8d25  = {}", (Object)respon);
                return null;
            }
            return null;
        }
        return token;
    }

    private String getVirualToken(String appId) {
        String token = (String)this.stringRedisTemplate.opsForValue().get((Object)(REIDS_VISUAL_TOKENKEY + appId));
        if (StringUtils.isBlank((String)token)) {
            AccessTokenRegisterRequest request = new AccessTokenRegisterRequest();
            request.setServerUrl(this.jiuYangConfig.getGetVirualTokenUrl());
            request.setAppKey(this.jiuYangConfig.getVirualAppkey());
            request.setGroupId(Long.valueOf(this.jiuYangConfig.getVirualGroupId().intValue()));
            request.setAppSecret(this.jiuYangConfig.getVirualAppSerect());
            ApiClientImpl apiClient = new ApiClientImpl((BaseRequest)request);
            try {
                AccessTokenRegisterResponse response = (AccessTokenRegisterResponse)apiClient.execute((IBaseRequest)request);
                if (response != null && response.success.booleanValue()) {
                    AccessTokenDetail tokenData = (AccessTokenDetail)response.getResult();
                    Long time = tokenData.getExpiredTime().getTime() - System.currentTimeMillis();
                    if (time.compareTo(0L) < 0) {
                        LOGGER.warn("getVirualToken tokenData fail ={}", (Object)JSON.toJSONString((Object)tokenData));
                        return null;
                    }
                    this.stringRedisTemplate.opsForValue().set((Object)(REIDS_VISUAL_TOKENKEY + appId), (Object)tokenData.getAccessToken(), time / 1000L - 10L, TimeUnit.SECONDS);
                    return tokenData.getAccessToken();
                }
            }
            catch (Exception e) {
                LOGGER.warn("getVirualToken fail", (Throwable)e);
                return null;
            }
            return null;
        }
        return token;
    }

    public String getVirtualResponse(String body) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((String)body)) {
            throw new ThirdpatyException("jiuyang,\u865a\u62df\u5546\u54c1\u5b9a\u5236\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        try {
            VirualRespData data = (VirualRespData)JSON.parseObject((String)body, VirualRespData.class);
            Boolean isOk = data.isSuccess() && data.getResult() != null && ObjectUtils.equals((Object)data.getResult().getSuccessCount(), (Object)1);
            map.put("status", isOk != false ? "success" : "fail");
            if (!isOk.booleanValue()) {
                if (data.getResult() == null) {
                    map.put("errorMessage", data.getMsg());
                    map.put("code", data.getCode());
                } else {
                    List<VirualRespData.ResultBean.FailedCustomerInfoBean> failedCustomerInfo = data.getResult().getFailedCustomerInfo();
                    map.put("errorMessage", CollectionUtils.isNotEmpty(failedCustomerInfo) ? failedCustomerInfo.get(0).getFailedMessage() : null);
                    map.put("code", data.getCode());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("jiuyang,\u865a\u62df\u5546\u54c1\u5b9a\u5236\uff0c\u7ed3\u679c\u89e3\u6790\u9519\u8bef:{}", (Object)body, (Object)e);
            map.put("status", "fail");
            map.put("errorMessage", "\u865a\u62df\u5546\u54c1\u5145\u503c\u63a5\u53e3\u54cd\u5e94\u89e3\u6790\u9519\u8bef");
        }
        return JSON.toJSONString(map);
    }

    public static String getMD5(String str) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(str.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("NoSuchAlgorithmException caught!");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        byte[] byteArray = messageDigest.digest();
        StringBuffer md5StrBuff = new StringBuffer();
        for (int i = 0; i < byteArray.length; ++i) {
            if (Integer.toHexString(0xFF & byteArray[i]).length() == 1) {
                md5StrBuff.append("0").append(Integer.toHexString(0xFF & byteArray[i]));
                continue;
            }
            md5StrBuff.append(Integer.toHexString(0xFF & byteArray[i]));
        }
        return md5StrBuff.toString();
    }

    public static String getSign(Map<String, Object> params, String secret) {
        JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString(params));
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder query = new StringBuilder(secret);
        Object[] var5 = keys;
        int var6 = keys.length;
        for (int var7 = 0; var7 < var6; ++var7) {
            Object key = var5[var7];
            String value = jsonObject.getString((String)key);
            if (value == null || "".equals(value) || value.startsWith("[") || value.startsWith("{")) continue;
            query.append((String)key).append(value);
        }
        try {
            return JiuYangApi.encryptMD5(query.toString());
        }
        catch (IOException var10) {
            LOGGER.error("MD5\u52a0\u5bc6\u5f02\u5e38", (Throwable)var10);
            return null;
        }
    }

    private static String encryptMD5(String data) throws IOException {
        byte[] bytes;
        Object var1 = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            bytes = md.digest(data.getBytes("utf-8"));
        }
        catch (GeneralSecurityException var3) {
            throw new IOException(var3.getMessage());
        }
        return JiuYangApi.byte2hex(bytes);
    }

    private static String byte2hex(byte[] b) {
        StringBuilder hs = new StringBuilder();
        for (int n = 0; b != null && n < b.length; ++n) {
            String stmp = Integer.toHexString(b[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append('0');
            }
            hs.append(stmp);
        }
        return hs.toString().toUpperCase();
    }

    public static class VirualRespData {
        private String code;
        private String msg;
        private boolean success;
        private ResultBean result;
        private String requestId;

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg2) {
            this.msg = msg2;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public ResultBean getResult() {
            return this.result;
        }

        public void setResult(ResultBean result) {
            this.result = result;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public static class ResultBean {
            private int failedCount;
            private int remaining;
            private int successCount;
            private List<FailedCustomerInfoBean> failedCustomerInfo;
            private List<SuccessCustomerInfoBean> successCustomerInfo;

            public int getFailedCount() {
                return this.failedCount;
            }

            public void setFailedCount(int failedCount) {
                this.failedCount = failedCount;
            }

            public int getRemaining() {
                return this.remaining;
            }

            public void setRemaining(int remaining) {
                this.remaining = remaining;
            }

            public int getSuccessCount() {
                return this.successCount;
            }

            public void setSuccessCount(int successCount) {
                this.successCount = successCount;
            }

            public List<FailedCustomerInfoBean> getFailedCustomerInfo() {
                return this.failedCustomerInfo;
            }

            public void setFailedCustomerInfo(List<FailedCustomerInfoBean> failedCustomerInfo) {
                this.failedCustomerInfo = failedCustomerInfo;
            }

            public List<SuccessCustomerInfoBean> getSuccessCustomerInfo() {
                return this.successCustomerInfo;
            }

            public void setSuccessCustomerInfo(List<SuccessCustomerInfoBean> successCustomerInfo) {
                this.successCustomerInfo = successCustomerInfo;
            }

            public static class SuccessCustomerInfoBean {
                private String couponId;
                private String nick;
                private int sysCustomerId;

                public String getCouponId() {
                    return this.couponId;
                }

                public void setCouponId(String couponId) {
                    this.couponId = couponId;
                }

                public String getNick() {
                    return this.nick;
                }

                public void setNick(String nick) {
                    this.nick = nick;
                }

                public int getSysCustomerId() {
                    return this.sysCustomerId;
                }

                public void setSysCustomerId(int sysCustomerId) {
                    this.sysCustomerId = sysCustomerId;
                }
            }

            public static class FailedCustomerInfoBean {
                private String failedMessage;
                private String nick;
                private int sysCustomerId;

                public String getFailedMessage() {
                    return this.failedMessage;
                }

                public void setFailedMessage(String failedMessage) {
                    this.failedMessage = failedMessage;
                }

                public String getNick() {
                    return this.nick;
                }

                public void setNick(String nick) {
                    this.nick = nick;
                }

                public int getSysCustomerId() {
                    return this.sysCustomerId;
                }

                public void setSysCustomerId(int sysCustomerId) {
                    this.sysCustomerId = sysCustomerId;
                }
            }
        }
    }

    public static class VirualRequest {
        private String appKey;
        private Long nonce;
        private String sign;
        private String accessToken;
        private Long groupId;
        private Long shopId;
        private String outShopId;
        private String couponCode;
        private Integer sendChannelType;
        private String extJson;
        private Long sendChannelId;
        private Long sysTradeId;
        private Long guideId;
        private List<CustomerNickInfoBean> customerNickInfo;

        public String getAppKey() {
            return this.appKey;
        }

        public void setAppKey(String appKey) {
            this.appKey = appKey;
        }

        public Long getNonce() {
            return this.nonce;
        }

        public void setNonce(Long nonce) {
            this.nonce = nonce;
        }

        public String getSign() {
            return this.sign;
        }

        public void setSign(String sign) {
            this.sign = sign;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public Long getGroupId() {
            return this.groupId;
        }

        public void setGroupId(Long groupId) {
            this.groupId = groupId;
        }

        public Long getShopId() {
            return this.shopId;
        }

        public void setShopId(Long shopId) {
            this.shopId = shopId;
        }

        public String getOutShopId() {
            return this.outShopId;
        }

        public void setOutShopId(String outShopId) {
            this.outShopId = outShopId;
        }

        public String getCouponCode() {
            return this.couponCode;
        }

        public void setCouponCode(String couponCode) {
            this.couponCode = couponCode;
        }

        public Integer getSendChannelType() {
            return this.sendChannelType;
        }

        public void setSendChannelType(Integer sendChannelType) {
            this.sendChannelType = sendChannelType;
        }

        public String getExtJson() {
            return this.extJson;
        }

        public void setExtJson(String extJson) {
            this.extJson = extJson;
        }

        public Long getSendChannelId() {
            return this.sendChannelId;
        }

        public void setSendChannelId(Long sendChannelId) {
            this.sendChannelId = sendChannelId;
        }

        public Long getSysTradeId() {
            return this.sysTradeId;
        }

        public void setSysTradeId(Long sysTradeId) {
            this.sysTradeId = sysTradeId;
        }

        public Long getGuideId() {
            return this.guideId;
        }

        public void setGuideId(Long guideId) {
            this.guideId = guideId;
        }

        public List<CustomerNickInfoBean> getCustomerNickInfo() {
            return this.customerNickInfo;
        }

        public void setCustomerNickInfo(List<CustomerNickInfoBean> customerNickInfo) {
            this.customerNickInfo = customerNickInfo;
        }

        public static class CustomerNickInfoBean {
            private String nick;
            private Integer platform;
            private Long sysCustomerId;
            private String outCouponId;

            public String getNick() {
                return this.nick;
            }

            public void setNick(String nick) {
                this.nick = nick;
            }

            public Integer getPlatform() {
                return this.platform;
            }

            public void setPlatform(Integer platform) {
                this.platform = platform;
            }

            public Long getSysCustomerId() {
                return this.sysCustomerId;
            }

            public void setSysCustomerId(Long sysCustomerId) {
                this.sysCustomerId = sysCustomerId;
            }

            public String getOutCouponId() {
                return this.outCouponId;
            }

            public void setOutCouponId(String outCouponId) {
                this.outCouponId = outCouponId;
            }
        }
    }

    public static class TokenResponData {
        @JSONField(name="access_token")
        private String accessToken;
        private String type;
        @JSONField(name="expires_in")
        private Integer expiresIn;

        public String getAccessToken() {
            return this.accessToken;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Integer getExpiresIn() {
            return this.expiresIn;
        }

        public void setExpiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
        }
    }
}

