/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.dto.sn.CreditsExchangeParam;
import cn.com.duiba.dto.sn.SignAddCreditsParam;
import cn.com.duiba.dto.sn.SnbRequestParam;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.tool.sn.GenerateSequenceUtil;
import cn.com.duiba.tool.sn.InitData;
import cn.com.duiba.tool.sn.SnbUtil;
import cn.com.duiba.tool.sn.TimeUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SnsApi {
    private static final Logger log = LoggerFactory.getLogger(SnsApi.class);
    private static final String SUCCESS_CODE = "00000000";
    private static final String merchantID = "DBWL0001";
    private static final List<Long> snsAppIds = Arrays.asList(66453L, 66420L);

    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) {
        Map<String, String> authParam;
        String url = request.getHttpUrl();
        String host = url.substring(0, url.indexOf(63));
        request.setHttpUrl(host);
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> paramsMap = AssembleTool.getUrlParams(paramsStr);
        String uid = paramsMap.get("uid");
        String timestamp = paramsMap.get("timestamp");
        String transfer = paramsMap.get("transfer");
        String tranDate = "";
        String tranTime = "";
        if (StringUtils.isNotEmpty((String)timestamp) && NumberUtils.isNumber((String)timestamp) && (timestamp.length() == 10 || timestamp.length() == 13)) {
            String date = TimeUtil.timestampToDateStr(Long.parseLong(timestamp));
            tranDate = date.substring(0, 8).trim();
            tranTime = date.substring(8, date.length()).trim();
        }
        SnbRequestParam snbRequestDto = new SnbRequestParam();
        snbRequestDto.setChannelSerialNo(GenerateSequenceUtil.generateSequenceNo());
        snbRequestDto.setTransCode("snb.duiba.market.active.sign");
        SignAddCreditsParam signAddCreditsDto = new SignAddCreditsParam();
        signAddCreditsDto.setMerchantId(merchantID);
        signAddCreditsDto.setEncryCustId(uid);
        signAddCreditsDto.setTranDate(tranDate);
        signAddCreditsDto.setTranTime(tranTime);
        signAddCreditsDto.setTransfer(transfer);
        snbRequestDto.setPayLoad(signAddCreditsDto);
        try {
            authParam = SnbUtil.send(snbRequestDto);
        }
        catch (Exception e) {
            authParam = new HashMap<String, String>();
            authParam.put("transCode", snbRequestDto.getTransCode());
            log.error("\u82cf\u5b81\u94f6\u884c\u52a0\u79ef\u5206\u8bf7\u6c42\u53c2\u6570\u7ec4\u88c5\u5931\u8d25, snbRequestDto={}", (Object)JsonTool.objectToJson(snbRequestDto), (Object)e);
        }
        request.setAuthParams(authParam);
        request.setHttpType("post");
        return request;
    }

    public String parseCreditsRsp(String body) {
        Map respMap = new HashMap();
        try {
            respMap = (Map)InitData.OBJECTMAPPER.readValue(body, Map.class);
            respMap = SnbUtil.extendMap(respMap);
        }
        catch (Exception e) {
            log.error("\u82cf\u5b81\u94f6\u884cjson\u53cd\u5e8f\u5217\u5316\u5931\u8d25, body={}", (Object)body, (Object)e);
            return body;
        }
        log.info("\u82cf\u5b81\u94f6\u884c\u52a0\u79ef\u5206responseMap, body={}", respMap);
        JSONObject json = new JSONObject();
        if (SUCCESS_CODE.equals(respMap.get("respCode"))) {
            json.put("status", (Object)"ok");
            json.put("bizId", respMap.get("serialNo"));
            json.put("credits", respMap.get("availIntegral"));
            json.put("addCredits", respMap.get("jFsignIntegral"));
        } else {
            json.put("errorMessage", respMap.get("respMsg"));
            json.put("status", (Object)"fail");
        }
        return json.toString();
    }

    public SupplierRequest getVirtualRequest(SupplierRequest request) {
        Map<String, String> authParam;
        log.info("\u82cf\u5b81\u94f6\u884c\u5151\u6362\u79ef\u5206\u8bf7\u6c42\u53c2\u6570, request={}", (Object)JsonTool.objectToJson(request));
        String url = request.getHttpUrl();
        List<String> analysisList = AssembleTool.analysisUrl(url);
        if (analysisList.isEmpty()) {
            return request;
        }
        String host = analysisList.get(0);
        Map<String, String> paramsMap = AssembleTool.getUrlParams(analysisList.get(1));
        String uid = paramsMap.get("uid");
        String timestamp = paramsMap.get("timestamp");
        String transfer = paramsMap.get("transfer");
        String orderNum = paramsMap.get("orderNum");
        String params = "";
        Map<String, String> map = request.getParams();
        if (MapUtils.isNotEmpty(map)) {
            params = map.get("params");
        }
        if (StringUtils.isEmpty((String)params)) {
            params = paramsMap.get("params");
        }
        String tranDate = "";
        String tranTime = "";
        if (StringUtils.isNotEmpty((String)timestamp) && NumberUtils.isNumber((String)timestamp) && (timestamp.length() == 10 || timestamp.length() == 13)) {
            String date = TimeUtil.timestampToDateStr(Long.parseLong(timestamp));
            tranDate = date.substring(0, 8).trim();
            tranTime = date.substring(8, date.length()).trim();
        }
        SnbRequestParam snbRequestDto = new SnbRequestParam();
        snbRequestDto.setChannelSerialNo(GenerateSequenceUtil.generateSequenceNo());
        snbRequestDto.setTransCode("snb.duiba.market.active.exchange");
        CreditsExchangeParam creditsExchangeDto = new CreditsExchangeParam();
        creditsExchangeDto.setMerchantId(merchantID);
        creditsExchangeDto.setEncryCustId(uid);
        creditsExchangeDto.setTranDate(tranDate);
        creditsExchangeDto.setTranTime(tranTime);
        creditsExchangeDto.setTransfer(transfer);
        creditsExchangeDto.setActivityNo(params);
        creditsExchangeDto.setBusinessNo(orderNum);
        snbRequestDto.setPayLoad(creditsExchangeDto);
        try {
            authParam = SnbUtil.send(snbRequestDto);
        }
        catch (Exception e) {
            authParam = new HashMap<String, String>();
            authParam.put("transCode", snbRequestDto.getTransCode());
            log.error("\u82cf\u5b81\u94f6\u884c\u79ef\u5206\u5151\u6362\u8bf7\u6c42\u53c2\u6570\u7ec4\u88c5\u5931\u8d25, snbRequestDto={}", (Object)JsonTool.objectToJson(snbRequestDto), (Object)e);
        }
        request.setAuthParams(authParam);
        request.setHttpUrl(host);
        return request;
    }

    public String getVirtualResponse(String body) {
        log.info("\u82cf\u5b81\u94f6\u884c\u5151\u6362\u79ef\u5206response, body={}", (Object)body);
        Map respMap = new HashMap();
        try {
            respMap = (Map)InitData.OBJECTMAPPER.readValue(body, Map.class);
            SnbUtil.extendMap(respMap);
        }
        catch (Exception e) {
            log.error("\u82cf\u5b81\u94f6\u884cjson\u53cd\u5e8f\u5217\u5316\u5931\u8d25, body={}", (Object)body, (Object)e);
            return body;
        }
        JSONObject json = new JSONObject();
        if (SUCCESS_CODE.equals(respMap.get("respCode"))) {
            json.put("status", (Object)"success");
            json.put("supplierBizId", respMap.get("serialNo"));
        } else {
            json.put("errorMessage", respMap.get("respMsg"));
            json.put("status", (Object)"fail");
        }
        return json.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public void setHttpHeader(Map<String, String> authParams, HttpRequestBase http) {
        http.setHeader("Content-Type", "application/x-www-form-urlencoded");
        http.setHeader("charset", InitData.CHARSET_UTF8);
        http.setHeader("appCode", authParams.get("appCode"));
        http.setHeader("version", "1.0");
    }

    public boolean isSns(Long appId) {
        return appId != null && snsAppIds.contains(appId);
    }
}

