/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.constant.UnionPayConstants;
import cn.com.duiba.constant.ZJUnionBankConstants;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.DES3Tool;
import cn.com.duiba.tool.ZjUnionBankUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnionPayApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnionPayApi.class);
    @Autowired
    private UnionPayConstants unionPayConstants;
    @Autowired
    private ZJUnionBankConstants zjUnionBankConstants;

    public boolean isUnionPayApp(Long appId) {
        return this.unionPayConstants.getAppConfig(String.valueOf(appId)) != null;
    }

    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String authParams = url.substring(url.indexOf(63) + 1);
        Map<String, String> authParamMap = AssembleTool.getUrlParams(authParams);
        String goodsNum = authParamMap.get("params");
        LOGGER.info("\u94f6\u8054url:{}, goodNum:{}", (Object)url, (Object)goodsNum);
        if (StringUtils.isBlank((CharSequence)goodsNum) || !this.checkGoodsPrefix(goodsNum)) {
            return new HttpGet(url);
        }
        Map<String, String> requestParams = this.buildVirtualRequestParams(authParamMap, request.getParams(), Long.valueOf(request.getAppId()));
        LOGGER.info("\u94f6\u8054\u865a\u62df\u5546\u54c1\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString(requestParams));
        if (goodsNum.startsWith(this.zjUnionBankConstants.getVirtualCreditsPre())) {
            ZjUnionBankHelper zjUnionBankHelper = new ZjUnionBankHelper();
            return zjUnionBankHelper.getVirtualRequest(request);
        }
        HttpPost post = new HttpPost(this.unionPayConstants.getVirtualUrl());
        post.setEntity((HttpEntity)new StringEntity(JSON.toJSONString(requestParams), ContentType.APPLICATION_JSON));
        return post;
    }

    private Map<String, String> buildVirtualRequestParams(Map<String, String> authParamMap, Map<String, String> params, Long appId) {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)params.get("devAppId"))) {
            requestParams.put("appId", this.unionPayConstants.getAppConfig(String.valueOf(appId)).getAppId());
        } else {
            requestParams.put("appId", params.get("devAppId"));
        }
        requestParams.put("transSeqId", authParamMap.get("orderNum"));
        requestParams.put("transTs", DateUtil.format((Date)new Date(), (String)"yyyyMMdd"));
        requestParams.put("couponId", authParamMap.get("params").replaceAll(this.unionPayConstants.getPrefix(), ""));
        if (StringUtils.isBlank((CharSequence)params.get("devAppId"))) {
            requestParams.put("openId", authParamMap.get("uid"));
        } else {
            requestParams.put("mobile", params.get("mobile"));
        }
        requestParams.put("acctEntityTp", "03");
        requestParams.put("couponNum", "1");
        requestParams.put("nonceStr", this.createNonceStr());
        requestParams.put("timestamp", Long.toString(System.currentTimeMillis() / 1000L));
        requestParams.put("signature", this.sign(requestParams, this.unionPayConstants.getPrivateKey()));
        if (StringUtils.isNotBlank((CharSequence)params.get("devAppId"))) {
            try {
                LOGGER.info("appId:{},devAppId:{},SymmetricKey:{}", new Object[]{appId, params.get("devAppId"), this.unionPayConstants.getSymmetricKey(params.get("devAppId"))});
                requestParams.put("mobile", DES3Tool.getEncryptedValue(params.get("mobile"), this.unionPayConstants.getSymmetricKey(params.get("devAppId"))));
            }
            catch (Exception e) {
                LOGGER.warn("\u94f6\u8054\u865a\u62df\u5546\u54c1\u8bf7\u6c42\u53c2\u6570\u52a0\u5bc6\u5931\u8d25, mobile: =>{}, SymmetricKey: =>{}", new Object[]{params.get("mobile"), this.unionPayConstants.getSymmetricKey(params.get("devAppId")), e});
            }
        }
        return requestParams;
    }

    public String getVirtualResponse(SupplierRequest message, String body) {
        String url = message.getHttpUrl();
        String authParams = url.substring(url.indexOf(63) + 1);
        Map<String, String> authParamMap = AssembleTool.getUrlParams(authParams);
        String goodsNum = authParamMap.get("params");
        if (StringUtils.isBlank((CharSequence)goodsNum) || !this.checkGoodsPrefix(goodsNum)) {
            return body;
        }
        if (goodsNum.startsWith(this.zjUnionBankConstants.getVirtualCreditsPre())) {
            ZjUnionBankHelper zjUnionBankHelper = new ZjUnionBankHelper();
            return zjUnionBankHelper.getVirtualResponse(message, body);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)body)) {
            throw new ThirdpatyException("\u4e91\u95ea\u4ed8\uff0c\u865a\u62df\u5546\u54c1\u5b9a\u5236\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        LOGGER.info("\u4e91\u95ea\u4ed8\u5b9a\u5236\u8fd4\u56de\u7ed3\u679c\u4e3a:{}", (Object)(body.length() > 500 ? body.substring(0, 500) : body));
        try {
            JSONObject jsonObject = JSON.parseObject((String)body);
            map.put("status", Objects.equals("00", jsonObject.getString("resp")) ? "success" : "fail");
            map.put("errorMessage", StringEscapeUtils.unescapeHtml4((String)jsonObject.getString("msg")));
            map.put("supplierBizId", jsonObject.getString("transSeqId"));
        }
        catch (Exception e) {
            LOGGER.error("\u4e91\u95ea\u4ed8\uff0c\u865a\u62df\u5546\u54c1\u5b9a\u5236\uff0c\u7ed3\u679c\u89e3\u6790\u9519\u8bef:{}", (Object)body, (Object)e);
            map.put("status", "fail");
            map.put("errorMessage", "\u865a\u62df\u5546\u54c1\u5145\u503c\u63a5\u53e3\u54cd\u5e94\u89e3\u6790\u9519\u8bef");
        }
        return JSON.toJSONString(map);
    }

    public String createNonceStr() {
        String sl = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            sb.append(sl.charAt(new Random().nextInt(sl.length())));
        }
        return sb.toString();
    }

    public String sign(Map<String, String> param, String signKey) {
        try {
            String value = UnionPayApi.sortMap(param);
            LOGGER.info("\u4e91\u95ea\u4ed8\u5b9a\u5236\u7b7e\u540d\u539f\u4e32\u4e3a:{}", (Object)value);
            byte[] keyBytes = Base64.decodeBase64((String)signKey);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyf = KeyFactory.getInstance("RSA");
            PrivateKey priKey = keyf.generatePrivate(keySpec);
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initSign(priKey);
            signature.update(value.getBytes());
            byte[] signed = signature.sign();
            return Base64.encodeBase64String((byte[])signed);
        }
        catch (Exception e) {
            LOGGER.error("\u4e91\u95ea\u4ed8\u5b9a\u5236\u7b7e\u540d\u5931\u8d25", (Throwable)e);
            throw new ThirdpatyException("\u4e91\u95ea\u4ed8\u5b9a\u5236\u7b7e\u540d\u5931\u8d25");
        }
    }

    public static String sortMap(Map<String, String> param) {
        StringBuilder result = new StringBuilder();
        Set<String> keySet = param.keySet();
        ArrayList<String> list = new ArrayList<String>(keySet);
        Collections.sort(list);
        for (int i = 0; i < list.size(); ++i) {
            String key = (String)list.get(i);
            if ("symmetricKey".equals(key)) continue;
            result.append(key).append("=").append(param.get(key)).append("&");
        }
        String sortMap = result.substring(0, result.length() - 1);
        return sortMap;
    }

    private boolean checkGoodsPrefix(String goods) {
        return this.getPrefixList().stream().anyMatch(goods::startsWith);
    }

    private List<String> getPrefixList() {
        return Arrays.asList(this.unionPayConstants.getPrefix(), this.zjUnionBankConstants.getVirtualCreditsPre());
    }

    class ZjUnionBankHelper {
        ZjUnionBankHelper() {
        }

        public HttpRequestBase getVirtualRequest(SupplierRequest request) {
            LOGGER.info("\u6d59\u6c5f\u94f6\u8054\u865a\u62df\u5546\u54c1\u8bf7\u6c42, request={}", (Object)JSON.toJSONString((Object)request));
            String url = request.getHttpUrl();
            Map<String, String> params = request.getParams();
            String paramsStr = url.substring(url.indexOf(63) + 1);
            Map<String, String> authParams = AssembleTool.getUrlParams(paramsStr);
            String goodsNum = authParams.get("params");
            if (params == null || params.get("mobile") == null) {
                LOGGER.warn("\u6d59\u6c5f\u94f6\u8054\u865a\u62df\u5151\u6362\u63a5\u53e3\u53c2\u6570\u9519\u8bef param:{}", (Object)JSON.toJSONString(params));
                throw new RuntimeException("\u6d59\u6c5f\u94f6\u8054\u865a\u62df\u5151\u6362\u63a5\u53e3\u53c2\u6570\u9519\u8bef");
            }
            if (StringUtils.isBlank((CharSequence)goodsNum) || !goodsNum.startsWith(UnionPayApi.this.zjUnionBankConstants.getVirtualCreditsPre())) {
                LOGGER.warn("\u6d59\u6c5f\u94f6\u8054\u672a\u5b9a\u5236\u865a\u62df\u5151\u6362\u63a5\u53e3 param:{}", (Object)JSON.toJSONString(authParams));
                throw new RuntimeException("\u6d59\u6c5f\u94f6\u8054\u672a\u5b9a\u5236\u865a\u62df\u5151\u6362\u63a5\u53e3");
            }
            String[] goodsArray = (goodsNum = goodsNum.replace(UnionPayApi.this.zjUnionBankConstants.getVirtualCreditsPre(), "")).split("_");
            if (goodsArray.length != 2) {
                LOGGER.warn("\u6d59\u6c5f\u94f6\u8054\u5546\u54c1\u914d\u7f6e\u9519\u8bef param:{}", (Object)JSON.toJSONString(authParams));
                throw new RuntimeException("\u6d59\u6c5f\u94f6\u8054\u5546\u54c1\u914d\u7f6e\u9519\u8bef");
            }
            String mobile = params.get("mobile");
            String couponModelId = goodsArray[0];
            String issueChannelId = goodsArray[1];
            JSONObject object = new JSONObject();
            object.put("mobile_phone_num", (Object)mobile);
            JSONObject privateInfo = new JSONObject();
            privateInfo.put("sysId", (Object)"CXCP");
            try {
                privateInfo.put("data", (Object)ZjUnionBankUtil.encerypt(object.toJSONString(), UnionPayApi.this.zjUnionBankConstants.getPublicKey()));
            }
            catch (Exception e) {
                LOGGER.warn("\u6d59\u6c5f\u94f6\u8054\u5546\u54c1\u521b\u5efa\u52a0\u5bc6\u9519\u8bef param:{}", (Object)JSON.toJSONString(authParams));
                throw new RuntimeException("\u6d59\u6c5f\u94f6\u8054\u5546\u54c1\u521b\u5efa\u5931\u8d25");
            }
            JSONObject transferData = new JSONObject();
            transferData.put("payType", (Object)3);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("order_no", request.getOrderId());
            map.put("coupon_model_id", couponModelId);
            map.put("issue_channel_id", issueChannelId);
            map.put("transfer_data", transferData.toJSONString());
            map.put("is_pay", 1);
            map.put("private_info", privateInfo.toJSONString());
            return this.getHttpRequestBase(map, UnionPayApi.this.zjUnionBankConstants.getPropSvcApi());
        }

        public String getVirtualResponse(SupplierRequest request, String body) {
            LOGGER.info("\u6d59\u6c5f\u94f6\u8054\u865a\u62df\u5546\u54c1\u54cd\u5e94\u7ed3\u679cresponse, body={}\uff0c {}", (Object)body, (Object)JSONObject.toJSONString((Object)request));
            body = this.verifySign(body);
            if ("false".equals(body)) {
                throw new RuntimeException("\u6d59\u6c5f\u94f6\u8054\u94f6\u884c\u672a\u5b9a\u5236\u865a\u62df\u5151\u6362, \u63a5\u53e3\u54cd\u5e94 \u89e3\u6790\u5f02\u5e38");
            }
            JSONObject jsonObject = JSONObject.parseObject((String)body);
            JSONObject result = new JSONObject();
            result.put("status", (Object)"success");
            if (jsonObject.getInteger("status") != 1) {
                result.put("status", (Object)"fail");
                result.put("errorMessage", (Object)"\u865a\u62df\u5546\u54c1\u53d1\u653e\u5931\u8d25");
            }
            return result.toString();
        }

        private String verifySign(String body) {
            LOGGER.info("\u6d59\u6c5f\u94f6\u8054\u865a\u62df\u5546\u54c1\u9a8c\u7b7e, {}", (Object)body);
            JSONObject parse = JSONObject.parseObject((String)body);
            Object respCd = parse.get((Object)"respCd");
            if (!"0000".equals(respCd.toString())) {
                String respMsg = parse.get((Object)"respMsg").toString();
                LOGGER.info("\u6d59\u6c5f\u94f6\u8054-\u54cd\u5e94\u7ed3\u679c\u5f02\u5e38 {}, {}", respCd, (Object)respMsg);
                return "false";
            }
            String sign = parse.get((Object)"sign").toString();
            try {
                if (StringUtils.isBlank((CharSequence)sign) || !ZjUnionBankUtil.verifySign(parse, sign, UnionPayApi.this.zjUnionBankConstants.getPublicKey())) {
                    LOGGER.info("\u6d59\u6c5f\u94f6\u8054-\u9a8c\u7b7e\u5931\u8d25 {}", (Object)body);
                    return "false";
                }
            }
            catch (Exception exception) {
                LOGGER.info("\u6d59\u6c5f\u94f6\u8054-\u9a8c\u7b7e\u5f02\u5e38 {}\uff0c{}", (Object)body, (Object)exception.getMessage());
                return "false";
            }
            return parse.get((Object)"respContent").toString();
        }

        private HttpRequestBase getHttpRequestBase(Map<String, Object> paramMap, String svcApi) {
            String url = UnionPayApi.this.zjUnionBankConstants.getUrl();
            JSONObject reqMsg = new JSONObject();
            reqMsg.put("svcId", (Object)UnionPayApi.this.zjUnionBankConstants.getSvcId());
            reqMsg.put("svcApi", (Object)svcApi);
            reqMsg.put("signType", (Object)"RSA2");
            reqMsg.put("version", (Object)"1.0.0");
            reqMsg.put("timestamp", (Object)new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
            reqMsg.put("bizContent", (Object)JSON.toJSONString(paramMap));
            LOGGER.info("\u6d59\u6c5f\u94f6\u8054\u8c03\u7528\u670d\u52a1\uff1a" + url + "   \u539f\u8bf7\u6c42\u62a5\u6587\uff1a" + reqMsg.toJSONString());
            HttpPost httpPost = null;
            try {
                reqMsg.put("sign", (Object)ZjUnionBankUtil.sign(reqMsg, UnionPayApi.this.zjUnionBankConstants.getPriKey()));
                httpPost = new HttpPost(url);
                ByteArrayEntity bae = new ByteArrayEntity(reqMsg.toJSONString().getBytes());
                httpPost.setEntity((HttpEntity)bae);
                httpPost.addHeader("Content-Type", "application/json; charset=UTF-8");
            }
            catch (Exception e) {
                LOGGER.warn("\u6d59\u6c5f\u94f6\u8054 getHttpRequestBase", (Throwable)e);
            }
            return httpPost;
        }
    }
}

