/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.constant.GuoBenConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.dto.guoben.GuoBenBaseResp;
import cn.com.duiba.dto.guoben.req.MemberIntegralChangeDTO;
import cn.com.duiba.dto.guoben.resp.MemberIntegralLogDTO;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GuoBenApiStrategy
implements ApiStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(GuoBenApiStrategy.class);
    private static final String TOKEN = "token";
    @Autowired
    private GuoBenConfig guoBenConfig;
    @Resource(name="httpClient")
    private CloseableHttpClient httpClient;

    @PostConstruct
    private void init() {
        ApiStrategyRouter.register(this.guoBenConfig.getConfigMap().keySet(), this);
    }

    public Boolean isGuoben(Long appId) {
        Set<Long> appIds = this.guoBenConfig.getConfigMap().keySet();
        if (null == appIds) {
            return false;
        }
        return appIds.contains(appId);
    }

    @Override
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        String url = message.getHttpUrl();
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        Long appId = message.getSubCreditsMsg().getAppId();
        Map authParams = message.getSubCreditsMsg().getAuthParams();
        if (MapUtils.isEmpty((Map)authParams)) {
            authParams = Maps.newHashMap();
        }
        authParams.put("uid", params.get("uid"));
        authParams.put("appId", appId + "");
        message.getSubCreditsMsg().setAuthParams(authParams);
        GuoBenConfig.GuoBenConfigBean configBean = this.guoBenConfig.getConfigMap().get(appId);
        HttpPost httpPost = new HttpPost(GuoBenConfig.Api.CHANGE_MEMBER_INTEGRAL.getApiAbsolutePath(configBean));
        MemberIntegralChangeDTO req = new MemberIntegralChangeDTO();
        req.setAccountNumber(params.get("uid"));
        req.setAccountType(configBean.getAccountType());
        req.setBrandCode(configBean.getBrandCode());
        req.setBusinessId(params.get("orderNum"));
        req.setBusinessType("7");
        String type = params.get("type");
        if (StringUtils.isNotBlank((CharSequence)type) && (StringUtils.equalsIgnoreCase((CharSequence)"game", (CharSequence)type) || StringUtils.equalsIgnoreCase((CharSequence)"hdtool", (CharSequence)type) || StringUtils.equalsIgnoreCase((CharSequence)"sign", (CharSequence)type))) {
            req.setBusinessType("3");
        }
        req.setChangeReason(type);
        Date date = new Date();
        String dateStr = DateUtils.getSecondStr((Date)date);
        String expEndTimeStr = this.getExpEndTimeStr(date);
        req.setChangeTime(dateStr);
        req.setChangeType(1);
        req.setCreateBy(configBean.getCreateBy());
        req.setExpEndTime(expEndTimeStr);
        req.setExpStartTime(dateStr);
        Integer credits = Integer.valueOf(params.get("credits"));
        req.setIntegral(-credits.intValue());
        req.setRequestId(UUID.randomUUID().toString().replaceAll("-", ""));
        StringEntity stringEntity = new StringEntity(JSON.toJSONString((Object)req), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)stringEntity);
        httpPost.setHeader(TOKEN, this.getToken(configBean));
        LOGGER.info("\u679c\u672c\u51cf\u79ef\u5206\uff0creq={}", (Object)JSON.toJSONString((Object)req));
        return httpPost;
    }

    @Override
    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {
        if (addCredits.booleanValue()) {
            LOGGER.info("\u679c\u672c\u52a0\u79ef\u5206\uff0cresp={}", (Object)body);
        } else {
            LOGGER.info("\u679c\u672c\u51cf\u79ef\u5206\uff0cresp={}", (Object)body);
        }
        HashMap map = Maps.newHashMap();
        if (StringUtils.isBlank((CharSequence)body)) {
            map.put("status", "fail");
            map.put("errorMessage", "\u679c\u672c\u65b0\u589e/\u6263\u51cf\u79ef\u5206\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            return JSON.toJSONString((Object)map);
        }
        try {
            GuoBenBaseResp guobenResp = (GuoBenBaseResp)JSON.parseObject((String)body, (TypeReference)new TypeReference<GuoBenBaseResp<MemberIntegralLogDTO>>(new Type[]{MemberIntegralLogDTO.class}){}, (Feature[])new Feature[0]);
            if (BooleanUtils.isTrue((Boolean)guobenResp.getSuccess())) {
                map.put("status", "ok");
                map.put("bizId", ((MemberIntegralLogDTO)guobenResp.getData()).getBusinessId());
                map.put("credits", String.valueOf(this.getCredits(authParams.get("uid"), authParams.get("appId"))));
            } else {
                map.put("status", "fail");
                String errorMsg = guobenResp.getMsg();
                if (StringUtils.length((CharSequence)errorMsg) > 255) {
                    errorMsg = errorMsg.substring(0, 255);
                }
                map.put("errorMessage", errorMsg);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u679c\u672c\u65b0\u589e/\u6263\u51cf\u79ef\u5206\u63a5\u53e3\u89e3\u6790\u9519\u8bef:{}--\u662f\u5426\u65b0\u589e:{}", new Object[]{body, addCredits, e});
            map.put("status", "fail");
            map.put("errorMessage", "\u679c\u672c\u65b0\u589e/\u6263\u51cf\u79ef\u5206\u89e3\u6790\u7ed3\u679c\u9519\u8bef");
        }
        return JSONObject.toJSONString((Object)map);
    }

    @Override
    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        String url = message.getHttpUrl();
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        String appId = message.getAppId();
        Map authParams = message.getAuthParams();
        if (MapUtils.isEmpty((Map)authParams)) {
            authParams = Maps.newHashMap();
        }
        authParams.put("uid", params.get("uid"));
        authParams.put("appId", appId);
        message.setAuthParams(authParams);
        GuoBenConfig.GuoBenConfigBean configBean = this.guoBenConfig.getConfigMap().get(Long.valueOf(appId));
        HttpPost httpPost = new HttpPost(GuoBenConfig.Api.CHANGE_MEMBER_INTEGRAL.getApiAbsolutePath(configBean));
        MemberIntegralChangeDTO req = new MemberIntegralChangeDTO();
        req.setAccountNumber(params.get("uid"));
        req.setAccountType(configBean.getAccountType());
        req.setBrandCode(configBean.getBrandCode());
        req.setBusinessId(params.get("orderNum"));
        req.setBusinessType("7");
        String type = params.get("type");
        if (StringUtils.isNotBlank((CharSequence)type) && (StringUtils.equalsIgnoreCase((CharSequence)"game", (CharSequence)type) || StringUtils.equalsIgnoreCase((CharSequence)"hdtool", (CharSequence)type) || StringUtils.equalsIgnoreCase((CharSequence)"sign", (CharSequence)type) || StringUtils.equalsIgnoreCase((CharSequence)"task", (CharSequence)type) || StringUtils.equalsIgnoreCase((CharSequence)"reSign", (CharSequence)type))) {
            req.setBusinessType("3");
        }
        req.setChangeReason(type);
        Date date = new Date();
        String dateStr = DateUtils.getSecondStr((Date)date);
        String expEndTimeStr = this.getExpEndTimeStr(date);
        req.setChangeTime(dateStr);
        req.setChangeType(1);
        req.setCreateBy(configBean.getCreateBy());
        req.setExpEndTime(expEndTimeStr);
        req.setExpStartTime(dateStr);
        Integer credits = Integer.valueOf(params.get("credits"));
        req.setIntegral(credits);
        req.setRequestId(UUID.randomUUID().toString().replaceAll("-", ""));
        StringEntity stringEntity = new StringEntity(JSON.toJSONString((Object)req), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)stringEntity);
        httpPost.setHeader(TOKEN, this.getToken(configBean));
        LOGGER.info("\u679c\u672c\u52a0\u79ef\u5206\uff0creq={}", (Object)JSON.toJSONString((Object)req));
        return httpPost;
    }

    @Override
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record) {
        return null;
    }

    private String getExpEndTimeStr(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, 1);
        cal.set(2, 11);
        cal.set(5, 31);
        cal.set(11, 12);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date newDate = cal.getTime();
        return DateUtils.getSecondStr((Date)newDate);
    }

    private String getToken(GuoBenConfig.GuoBenConfigBean configBean) {
        String resp;
        String url = GuoBenConfig.Api.GET_TOKEN.getApiAbsolutePath(configBean);
        HttpGet httpGet = new HttpGet(url);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);){
            HttpEntity entity = response.getEntity();
            resp = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            LOGGER.warn("\u679c\u672c\uff0c\u8bf7\u6c42token\uff0c\u5f02\u5e38\uff0curl={}", (Object)url, (Object)e);
            throw new ThirdpatyException("\u679c\u672c\uff0c\u8bf7\u6c42token\uff0c\u5f02\u5e38");
        }
        if (StringUtils.isBlank((CharSequence)resp)) {
            throw new ThirdpatyException("\u679c\u672c\uff0c\u8bf7\u6c42token\uff0c\u5931\u8d25");
        }
        String data = (String)JSON.parseObject((String)resp).get((Object)"data");
        if (StringUtils.isBlank((CharSequence)data)) {
            throw new ThirdpatyException("\u679c\u672c\uff0c\u8bf7\u6c42token\uff0c\u5931\u8d25");
        }
        return data;
    }

    public Long getCredits(String uid, String appId) {
        String resp;
        GuoBenConfig.GuoBenConfigBean configBean = this.guoBenConfig.getConfigMap().get(Long.valueOf(appId));
        String url = GuoBenConfig.Api.GET_INTEGRAL.getApiAbsolutePath(configBean);
        String token = this.getToken(configBean);
        BasicHeader header = new BasicHeader(TOKEN, token);
        HashMap params = Maps.newHashMap();
        params.put("brandCode", configBean.getBrandCode());
        params.put("cellPhoneNo", uid);
        LOGGER.info("\u679c\u672c\u67e5\u8be2\u79ef\u5206\uff0creq={}", (Object)JSON.toJSONString((Object)params));
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)params), ContentType.APPLICATION_JSON));
        httpPost.setHeader((Header)header);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            HttpEntity entity = response.getEntity();
            resp = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            LOGGER.warn("\u679c\u672c\uff0c\u67e5\u8be2\u79ef\u5206\uff0c\u5f02\u5e38\uff0curl={}", (Object)url, (Object)e);
            throw new ThirdpatyException("\u679c\u672c\uff0c\u67e5\u8be2\u79ef\u5206\uff0c\u5f02\u5e38");
        }
        LOGGER.info("\u679c\u672c\u67e5\u8be2\u79ef\u5206\uff0cresp={}", (Object)resp);
        if (StringUtils.isBlank((CharSequence)resp)) {
            throw new ThirdpatyException("\u679c\u672c\u67e5\u8be2\u79ef\u5206\u5931\u8d25");
        }
        Boolean flag = JSON.parseObject((String)resp).getBoolean("success");
        if (!BooleanUtils.isTrue((Boolean)flag)) {
            throw new ThirdpatyException("\u679c\u672c\u67e5\u8be2\u79ef\u5206\u5931\u8d25");
        }
        Long credits = JSON.parseObject((String)resp).getJSONObject("data").getLong("integralAble");
        if (credits == null) {
            throw new ThirdpatyException("\u679c\u672c\u67e5\u8be2\u79ef\u5206\u5931\u8d25");
        }
        return credits;
    }
}

