/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.crecord.message;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.dao.HttpMessageDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.HttpMessageDO;
import cn.com.duiba.notifycenter.service.NotifyHttpClientPool;
import cn.com.duiba.service.CustomService;
import cn.com.duiba.service.HttpRetryRulesService;
import cn.com.duiba.service.ThreadPoolService;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import cn.com.duiba.thirdparty.dto.HttpResponseMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpRequestLog;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrecordAsyncHttp {
    private static Logger logger = LoggerFactory.getLogger(CrecordAsyncHttp.class);
    @Autowired
    private HttpRetryRulesService httpRetryRulesService;
    @Autowired
    private AppDAO appDAO;
    @Autowired
    private HttpMessageDAO httpMessageDAO;
    @Autowired
    private ThreadPoolService threadPoolService;
    @Autowired
    private NotifyHttpClientPool notifyHttpClientPool;
    @Autowired
    private CustomService customService;

    public void asyncSubmit(String message) {
        HttpRequestMessageDto dto = (HttpRequestMessageDto)JSONObject.parseObject((String)message, HttpRequestMessageDto.class);
        AppDO app = this.appDAO.findAppSimple(dto.getAppId());
        if (app == null) {
            logger.warn("appId:{} recordNotifyUrl: is empty", (Object)dto.getAppId());
            return;
        }
        if (!(!StringUtils.isEmpty((String)app.getRecordNotifyUrl()) || this.customService.isZHBApp(app.getId()) || ApiStrategyRouter.route(app.getId()) != null && ApiStrategyRouter.route(app.getId()).isCustomCrecord(dto))) {
            logger.warn("appId:{} recordNotifyUrl: is empty", (Object)dto.getAppId());
            return;
        }
        HttpMessageDO hmd = new HttpMessageDO();
        hmd.setAppId(dto.getAppId());
        hmd.setBizType(dto.getBizType());
        hmd.setBizParams(JSONObject.toJSONString((Object)dto.getHttpParams()));
        hmd.setNumber(0);
        hmd.setOffset(this.httpRetryRulesService.getNextSecond(hmd));
        this.httpMessageDAO.insert(hmd);
        this.asyncSubmit(hmd, dto, app);
    }

    public void asyncSubmit(HttpMessageDO db, HttpRequestMessageDto msg2, AppDO app) {
        String url;
        if (app == null) {
            return;
        }
        HttpRequestBase http = this.customService.getCrecordHttpRequest(msg2, app);
        if (http == null) {
            Map map = msg2.getHttpParams();
            if (MapUtils.isEmpty((Map)map)) {
                return;
            }
            map.put("appKey", app.getAppKey());
            map.put("appSecret", this.appDAO.getAppSecret(app));
            String sign = SignTool.sign((Map)map);
            map.put("sign", sign);
            map.remove("appSecret");
            if (StringUtils.isEmpty((String)app.getRecordNotifyUrl())) {
                return;
            }
            url = AssembleTool.assembleUrl(app.getRecordNotifyUrl(), map);
            http = new HttpGet(url.trim());
            HttpRequestLog.logUrl("[action crecord] [tag get request] [url " + url + "]");
        } else {
            url = http.getURI().toString();
        }
        this.submitReq(msg2, http, db, url);
    }

    private void submitReq(final HttpRequestMessageDto msg2, HttpRequestBase http, final HttpMessageDO db, final String url) {
        this.notifyHttpClientPool.submit(msg2.getAppId(), (HttpUriRequest)http, new FutureCallback<HttpResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(HttpResponse response) {
                HttpResponseMessageDto resp = new HttpResponseMessageDto();
                try {
                    String cont;
                    resp.setCallbackType("completed");
                    resp.setHttpUrl(url);
                    Header header = response.getEntity().getContentEncoding();
                    String body = header != null && header.toString().contains("gzip") ? EntityUtils.toString((HttpEntity)new GzipDecompressingEntity(response.getEntity())) : EntityUtils.toString((HttpEntity)response.getEntity());
                    body = CrecordAsyncHttp.this.customService.getCrecordResponse(body, msg2.getAppId());
                    if (StringUtils.isNotEmpty((String)body) && (cont = body.toLowerCase()).contains("ok")) {
                        resp.setSuccess(Boolean.valueOf(true));
                    }
                    resp.setBody(HttpRequestLog.subBody(body));
                    resp.setBizId(msg2.getBizId());
                    resp.setBizType(msg2.getBizType());
                }
                catch (Exception e) {
                    resp.setSuccess(Boolean.valueOf(false));
                    resp.setErrorMessage("\u8bf7\u6c42\u5931\u8d25:completed:" + e.getMessage());
                    logger.error("completed param: {}", (Object)CrecordAsyncHttp.this.getCrecordParam(msg2), (Object)e);
                }
                finally {
                    CrecordAsyncHttp.this.httpRequestComleted(db, msg2, resp);
                }
            }

            public void failed(Exception ex) {
                logger.warn("crecord failed param: {}, errMsg: {}", new Object[]{CrecordAsyncHttp.this.getCrecordParam(msg2), CrecordAsyncHttp.this.getErrorMsg(ex), ex});
                HttpResponseMessageDto resp = new HttpResponseMessageDto();
                resp.setCallbackType("failed");
                resp.setHttpUrl(url);
                resp.setBizId(msg2.getBizId());
                resp.setBizType(msg2.getBizType());
                resp.setSuccess(Boolean.valueOf(false));
                resp.setErrorMessage("\u8bf7\u6c42\u5931\u8d25:failed:" + ex.getMessage());
                CrecordAsyncHttp.this.httpRequestComleted(db, msg2, resp);
            }

            public void cancelled() {
                logger.warn("crecord failed param:" + CrecordAsyncHttp.this.getCrecordParam(msg2));
                HttpResponseMessageDto resp = new HttpResponseMessageDto();
                resp.setCallbackType("cancelled");
                resp.setHttpUrl(url);
                resp.setBizId(msg2.getBizId());
                resp.setBizType(msg2.getBizType());
                resp.setSuccess(Boolean.valueOf(false));
                resp.setErrorMessage("\u8bf7\u6c42\u5931\u8d25:cancelled");
                CrecordAsyncHttp.this.httpRequestComleted(db, msg2, resp);
            }
        });
    }

    private String getErrorMsg(Exception ex) {
        String errMsg = ex.getMessage();
        if (ex.getCause() != null) {
            errMsg = ex.getCause().getMessage();
        }
        return errMsg;
    }

    private String getCrecordParam(HttpRequestMessageDto msg2) {
        return msg2.getHttpParams() != null ? JSONObject.toJSONString((Object)msg2.getHttpParams()) : "null";
    }

    private String getCrecordId(HttpRequestMessageDto msg2) {
        Map map = msg2.getHttpParams();
        if (MapUtils.isEmpty((Map)map)) {
            return "";
        }
        return (String)map.get("recordId");
    }

    private void httpRequestComleted(final HttpMessageDO db, HttpRequestMessageDto requestMessageDto, final HttpResponseMessageDto resp) {
        HttpRequestLog.logUrl("[action crecord Response][callback " + resp.getCallbackType() + "] [body " + resp.getBody() + "][recordId " + this.getCrecordId(requestMessageDto) + "]");
        this.threadPoolService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!"completed".equals(resp.getCallbackType()) || !"ok".equalsIgnoreCase(resp.getBody())) {
                        if (db.getNumber() >= CrecordAsyncHttp.this.httpRetryRulesService.getRetryNumber(db)) {
                            CrecordAsyncHttp.this.httpMessageDAO.delete(db.getId());
                            return;
                        }
                        CrecordAsyncHttp.this.httpMessageDAO.updateNextTime(db.getId(), CrecordAsyncHttp.this.httpRetryRulesService.getNextSecond(db));
                        return;
                    }
                    CrecordAsyncHttp.this.httpMessageDAO.delete(db.getId());
                }
                catch (Exception e) {
                    logger.error("httpRequestComleted", (Throwable)e);
                }
            }
        });
    }
}

