/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.remoteimpl.cmb;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.thirdparty.api.cmb.RemoteCmbMachineService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteCmbMachineServiceImpl
implements RemoteCmbMachineService {
    private static Logger logger = LoggerFactory.getLogger(RemoteCmbMachineServiceImpl.class);

    public String sendCmbMachineRequest(String ipPort, String data) throws BizException {
        StringBuilder result = new StringBuilder();
        if (StringUtils.isBlank((String)ipPort)) {
            logger.info("\u524d\u7f6e\u673aip\u7aef\u53e3\u4e0d\u53ef\u4e3a\u7a7a");
            return null;
        }
        HttpURLConnection conn = null;
        try {
            String machineUrl = "http://" + ipPort;
            URL url = new URL(machineUrl);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3000);
            try (OutputStream os = conn.getOutputStream();){
                os.write(data.getBytes(StandardCharsets.UTF_8));
            }
            var8_10 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                String line;
                while ((line = br.readLine()) != null) {
                    result.append(line);
                }
            }
            catch (Throwable throwable) {
                var8_10 = throwable;
                throw throwable;
            }
        }
        catch (MalformedURLException e) {
            throw new BizException("\u8fde\u63a5\u914d\u7f6e\u5f02\u5e38" + e.getMessage());
        }
        catch (IOException e) {
            throw new BizException("\u6d41\u914d\u7f6e\u5f02\u5e38" + e.getMessage());
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return result.toString();
    }
}

