/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.CiticBankConfig;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={CiticBankConfig.class})
public class CustomHttpClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomHttpClientFactory.class);
    @Autowired
    private CiticBankConfig citicBankConfig;
    private static final int CONNECT_TIMEOUT = 10000;
    private static final int DEFAULT_REQUEST_TIMEOUT = 3000;
    private static final int KEEPALIVE_TIMEOUT = 5000;
    private static final int SOCKET_TIMEOUT = 10000;
    private static final int MAX_CONNECT = 300;
    private static final int MAX_ROUTE_CONNECT = 20;

    @Bean(initMethod="start", destroyMethod="close", name={"citicBankHttpAsyncClient"})
    public CloseableHttpAsyncClient citicBankHttpAsyncClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(3000).setSocketTimeout(10000).build();
        CloseableHttpAsyncClient httpClient = HttpAsyncClients.custom().setConnectionManager((NHttpClientConnectionManager)this.getConnectionManager()).setDefaultRequestConfig(config).setMaxConnTotal(300).setMaxConnPerRoute(20).setKeepAliveStrategy((ConnectionKeepAliveStrategy)CustomHttpClientFactory.getKeepAliveStrategy()).build();
        return httpClient;
    }

    @Bean(initMethod="start", destroyMethod="close", name={"citicBankHttpAsyncNotifyClient"})
    public CloseableHttpAsyncClient citicBankHttpAsyncNotifyClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(3000).setSocketTimeout(10000).build();
        CloseableHttpAsyncClient httpClient = HttpAsyncClients.custom().setConnectionManager((NHttpClientConnectionManager)this.getConnectionManager()).setDefaultRequestConfig(config).setMaxConnTotal(300).setMaxConnPerRoute(20).setKeepAliveStrategy((ConnectionKeepAliveStrategy)CustomHttpClientFactory.getKeepAliveStrategy()).build();
        return httpClient;
    }

    @Bean(initMethod="start", destroyMethod="close", name={"ctsHttpAsyncClient"})
    public CloseableHttpAsyncClient ctsHttpAsyncClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(3000).setSocketTimeout(20000).build();
        CloseableHttpAsyncClient httpClient = HttpAsyncClients.custom().setConnectionManager((NHttpClientConnectionManager)this.getConnectionManager()).setDefaultRequestConfig(config).setMaxConnTotal(300).setMaxConnPerRoute(20).setKeepAliveStrategy((ConnectionKeepAliveStrategy)CustomHttpClientFactory.getKeepAliveStrategy()).build();
        return httpClient;
    }

    private PoolingNHttpClientConnectionManager getConnectionManager() {
        try {
            SSLContext sslContext = this.getSSLContext();
            if (sslContext == null) {
                throw new BizException("getConnectionManager failed, sslContext is null!!!");
            }
            return new PoolingNHttpClientConnectionManager((ConnectingIOReactor)new DefaultConnectingIOReactor(), RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE).register("https", (Object)new SSLIOSessionStrategy(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build());
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SSLContext getSSLContext() {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64.decodeBase64((String)this.citicBankConfig.getCaCertBase64()));){
            KeyStore keyStore = KeyStore.getInstance("jks");
            keyStore.load(inputStream, this.citicBankConfig.getKeyStorePass().toCharArray());
            SSLContext sSLContext = SSLContexts.custom().loadTrustMaterial(keyStore, (TrustStrategy)new TrustSelfSignedStrategy()).build();
            return sSLContext;
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
            return null;
        }
    }

    private static DefaultConnectionKeepAliveStrategy getKeepAliveStrategy() {
        return new DefaultConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                long duration = super.getKeepAliveDuration(response, context);
                if (duration == -1L) {
                    return 5000L;
                }
                return duration;
            }
        };
    }
}

