/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool.suning;

import cn.com.duiba.tool.suning.EncryptUtil;
import cn.com.duiba.tool.suning.MD5;
import cn.com.duiba.tool.suning.RSAUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuningSignUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SuningSignUtils.class);
    private static final int INDEX_NOT_FOUND = -1;
    private static final String EQ = "=";
    private static final String AND = "&";
    private static final String SIGN_TYPE = "signType";
    private static final String SIGN_KEY_INDEX = "signkeyIndex";
    private static final String SIGN = "sign";
    private static final String GS_SIGN = "gsSign";
    public static final String PARAMS = "params";
    private static final String ENCRYPT = "encrypt";
    private static final String KEY = "key";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_JSON_UTF_8 = "application/json;charset=UTF-8";
    private static final String UTF8_CHARSET = "UTF-8";

    public static void encrypt(String aesKey, String publicKey, Map<String, Object> params) {
        try {
            String str1 = SuningSignUtils.getString(params, PARAMS);
            String str2 = EncryptUtil.encryptBase64DecorateAES(str1, aesKey);
            params.put(PARAMS, str2);
            String encrypt = EncryptUtil.encryptByPublicKey(aesKey, publicKey);
            params.put(KEY, encrypt);
        }
        catch (Exception e) {
            LOGGER.error("AES\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
        }
    }

    public static Map<String, Object> decrypt(String aesKey, Map<String, Object> params) {
        String str = SuningSignUtils.getString(params, PARAMS);
        try {
            if (params.containsKey(ENCRYPT) && ((Boolean)params.get(ENCRYPT)).booleanValue()) {
                str = EncryptUtil.decryptBase64DecorateAES(str, aesKey);
            }
            return (Map)JSON.parseObject((String)str, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            LOGGER.error("AES\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private static String getString(Map map, Object key) {
        Object answer;
        if (map != null && (answer = map.get(key)) != null) {
            return answer.toString();
        }
        return null;
    }

    public static boolean verifySign(Map<String, Object> resultMap, String publicKey) {
        try {
            String resultSign = (String)resultMap.get(SIGN);
            if (SuningSignUtils.isBlank(resultSign)) {
                return false;
            }
            PublicKey pk = RSAUtil.getPublicKey(publicKey);
            String digestData = SuningSignUtils.mapToString(resultMap, SIGN, "sign_type", SIGN_TYPE);
            digestData = MD5.digest(digestData, UTF8_CHARSET);
            return RSAUtil.vertiy(digestData, resultSign, pk);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void getSign(Map<String, Object> params, String privateKey) {
        try {
            String digestData = SuningSignUtils.mapToString(params, "sign_type", "signkey_index", SIGN_TYPE, SIGN_KEY_INDEX);
            digestData = MD5.digest(digestData, UTF8_CHARSET);
            PrivateKey pk = RSAUtil.getPrivateKey(privateKey);
            String sign = RSAUtil.sign(digestData, pk);
            params.put(SIGN, sign);
        }
        catch (Exception e) {
            LOGGER.error("\u751f\u6210\u7b7e\u540d\u53d1\u751f\u5f02\u5e38,param={},privateKey={},error={}", new Object[]{params.toString(), privateKey, e.getMessage()});
        }
    }

    private static String mapToString(Map<String, Object> map, String ... exclude) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            if (key == null || SuningSignUtils.contains(exclude, key)) continue;
            if (entry.getValue() instanceof String) {
                treeMap.put(entry.getKey(), entry.getValue().toString().trim());
                continue;
            }
            treeMap.put(entry.getKey(), JSON.toJSONString((Object)entry.getValue()));
        }
        return SuningSignUtils.append(treeMap);
    }

    private static String append(Map<String, String> map) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            builder.append(entry.getKey());
            builder.append(EQ);
            builder.append(entry.getValue());
            builder.append(AND);
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString().trim();
    }

    private static boolean contains(Object[] array, Object objectToFind) {
        return SuningSignUtils.indexOf(array, objectToFind) != -1;
    }

    private static int indexOf(Object[] array, Object objectToFind) {
        block4: {
            block3: {
                if (array == null) {
                    return -1;
                }
                if (objectToFind != null) break block3;
                for (int i = 0; i < array.length; ++i) {
                    if (array[i] != null) continue;
                    return i;
                }
                break block4;
            }
            if (!array.getClass().getComponentType().isInstance(objectToFind)) break block4;
            for (int i = 0; i < array.length; ++i) {
                if (!objectToFind.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static Map<String, String> toStringMap(Map<String, Object> map) {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof String) {
                stringMap.put(entry.getKey(), entry.getValue().toString().trim());
                continue;
            }
            stringMap.put(entry.getKey(), JSON.toJSONString((Object)entry.getValue()));
        }
        return stringMap;
    }
}

