package cn.com.duiba.biz.credits;

import cn.com.duiba.api.enums.SubjectTypeEnum;
import cn.com.duiba.client.FuLuClient;
import cn.com.duiba.constant.ChangChengConfig;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.dto.fulu.FuLuBaseResp;
import cn.com.duiba.tool.AssembleTool;
import com.alibaba.fastjson.JSON;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * 长城汽车定制 虚拟商品以为
 * @author cmm
 */
@Service
public class ChangChengApi {
    private static final Logger log = LoggerFactory.getLogger(ChangChengApi.class);

    @Autowired
    private ChangChengConfig changChengConfig;
    @Autowired
    private FuLuClient fuLuClient;

    public Boolean isChangCheng(Long appId) {
        Set<Long> appIds = changChengConfig.getAppIds();
        if (CollectionUtils.isEmpty(appIds)) {
            return false;
        }
        return appIds.contains(appId);
    }


    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        log.info("长城虚拟兑换SupplierRequest:{}",JSON.toJSONString(request));
        String goodsNum = getGoodsNum(request);
        if (StringUtils.isNotBlank(goodsNum) && goodsNum.startsWith(changChengConfig.getFuluPrefix())) {
            return fuLuClient.getFuLuDirectRequest(request, goodsNum.replace(changChengConfig.getFuluPrefix(), ""), SubjectTypeEnum.DUIA.getType());
        }
        //默认返回
        return new HttpGet(request.getHttpUrl());
    }

    public String getVirtualResponse(SupplierRequest request, String body, String callbackTopic, String msgTag, String msgKey) {
        log.info("福禄直充返回 body:{},request:{}",body,JSON.toJSONString(request));
        String goodsNum = getGoodsNum(request);
        if (StringUtils.isNotBlank(goodsNum) && goodsNum.startsWith(changChengConfig.getFuluPrefix())) {
            Map<String, String> duibaDoc = new HashMap<>();
            try {
                FuLuBaseResp fuluBaseResp = JSON.parseObject(body, FuLuBaseResp.class);
                duibaDoc = fuLuClient.getDuibaVirtualResponse(request, fuluBaseResp, callbackTopic, msgTag, msgKey);
            } catch (Exception e) {
                log.error("fulu，充值商品定制，结果解析错误:{}", body, e);
                duibaDoc.put("status", "fail");
                duibaDoc.put("errorMessage", "福禄直充响应解析错误");
            }
            return JSON.toJSONString(duibaDoc);
        }
        return body;
    }



    private String getGoodsNum(SupplierRequest request) {
        String url = request.getHttpUrl();
        String paramsStr = url.substring(url.indexOf('?') + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        String goodsNum = params.get("params");
        return goodsNum;
    }


}
