package cn.com.duiba.biz.credits;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.constant.HaoXiangNiConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.dto.haoxiangni.resp.AccessTokenRegisterResponse;
import cn.com.duiba.dto.haoxiangni.resp.CouponSendListResponse;
import cn.com.duiba.dto.haoxiangni.resp.CustomerBasicInfoGetResponse;
import cn.com.duiba.dto.haoxiangni.resp.PointAddResponse;
import cn.com.duiba.dto.haoxiangni.resp.PointInfoGetResponse;
import cn.com.duiba.dto.haoxiangni.resp.PointReduceResponse;
import cn.com.duiba.dto.haoxiangni.resp.basis.AccessTokenDetail;
import cn.com.duiba.dto.haoxiangni.resp.basis.CouponSendInfo;
import cn.com.duiba.dto.haoxiangni.resp.basis.CustomerPointInfo;
import cn.com.duiba.dto.haoxiangni.resp.basis.NickInfo;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.haoxiangni.SignUtils;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.redis.RedisAtomicClient;
import cn.com.duiba.wolf.redis.RedisLock;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;
import java.time.Duration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/**
 * 好想你定制
 *
 * @author haojiahong
 * @date 2020-12-22
 */
@Service
public class HaoXiangNiApi {

    private static final Logger LOGGER = LoggerFactory.getLogger(HaoXiangNiApi.class);


    private static final String CACHE_TOKEN_KEY_FORMAT = "haoXiangNiToken_%s_%s";
    private static final String LOCK_TOKEN_KEY_FORMAT = "haoXiangNiLock_%s_%s";


    @Autowired
    private HaoXiangNiConfig haoXiangNiConfig;
    @Resource(name = "httpClient")
    private CloseableHttpClient httpClient;
    @Resource(name = "redisTemplate")
    private RedisAtomicClient redisAtomicClient;
    @Resource(name = "redisTemplate")
    private AdvancedCacheClient advancedCacheClient;


    public Boolean isHaoXiangNi(Long appId) {
        Set<Long> appIds = haoXiangNiConfig.getAppIds();
        if (null == appIds) {
            return false;
        }
        return appIds.contains(appId);
    }


    /**
     * 减积分请求封装
     * <p>
     * rpc
     * SubCreditsToDeveloper.submit customService.getSubCreditsHttpRequest(request)
     *
     * @param message
     * @return
     */
    public HttpRequestBase getSubCreditsMessage(CreditsMessage message) {
        String url = message.getHttpUrl();
        String paramsStr = url.substring(url.indexOf('?') + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        return getSubCreditsRequest(params);
    }

    /**
     * 减积分请求封装
     * <p>
     * mq
     * CreditsServiceImpl.subCredits customService.getMqSubCreditsHttpRequest(request)
     *
     * @param message
     * @return
     */
    public HttpRequestBase getSubCreditsMessage(SubCreditsMsgWrapper message) {
        String url = message.getHttpUrl();
        String paramsStr = url.substring(url.indexOf('?') + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        return getSubCreditsRequest(params);
    }


    /**
     * 获取定制的减积分请求
     *
     * @param params
     * @return
     */
    private HttpPost getSubCreditsRequest(Map<String, String> params) {
        HttpPost httpPost = new HttpPost(HaoXiangNiConfig.Api.POINT_REDUCE.getApiAbsolutePath(haoXiangNiConfig));
        Map<String, Object> map = Maps.newHashMap();
        map.put("appKey", haoXiangNiConfig.getAppKey());
        map.put("nonce", System.currentTimeMillis());
        map.put("accessToken", this.getToken());
        map.put("groupId", haoXiangNiConfig.getGroupId());
        NickInfo nickInfo = this.getNickInfo(params.get("uid"));
        map.put("nick", nickInfo.getNick());
        map.put("platform", nickInfo.getPlatform());
        map.put("integralAccount", haoXiangNiConfig.getIntegralAccount());
        map.put("point", params.get("credits"));
        map.put("reduceType", 3);
        String desc = params.get("description");
        if (StringUtils.isNotBlank(desc)) {
            if (desc.length() > 100) {
                desc = desc.substring(0, 100);
            }
        } else {
            desc = "扣积分";
        }
        map.put("remark", desc);
        map.put("sign", SignUtils.getSign(map, haoXiangNiConfig.getAppSecret()));

        StringEntity stringEntity = new StringEntity(JSON.toJSONString(map), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity(stringEntity);
        return httpPost;
    }


    /**
     * 加积分请求封装
     *
     * @param message
     * @return
     */
    public HttpRequestBase getAddCreditsMessage(CreditsMessageDto message) {
        // 截取请求url
        String httpUrl = message.getHttpUrl();
        // 截取url请求参数，构造新的请求参数
        String paramStr = httpUrl.substring(httpUrl.indexOf('?') + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramStr);
        return getAddCreditsRequest(params);
    }

    /**
     * 获取定制的加积分请求
     *
     * @param params
     * @return
     */
    private HttpPost getAddCreditsRequest(Map<String, String> params) {
        HttpPost httpPost = new HttpPost(HaoXiangNiConfig.Api.POINT_ADD.getApiAbsolutePath(haoXiangNiConfig));
        Map<String, Object> map = Maps.newHashMap();
        map.put("appKey", haoXiangNiConfig.getAppKey());
        map.put("nonce", System.currentTimeMillis());
        map.put("accessToken", this.getToken());
        map.put("groupId", haoXiangNiConfig.getGroupId());
        NickInfo nickInfo = this.getNickInfo(params.get("uid"));
        map.put("nick", nickInfo.getNick());
        map.put("platform", nickInfo.getPlatform());
        map.put("integralAccount", haoXiangNiConfig.getIntegralAccount());
        map.put("point", params.get("credits"));
        map.put("sendType", 1);
        String desc = params.get("description");
        if (StringUtils.isNotBlank(desc)) {
            if (desc.length() > 100) {
                desc = desc.substring(0, 100);
            }
        } else {
            desc = "加积分";
        }
        map.put("remark", desc);
        map.put("sign", SignUtils.getSign(map, haoXiangNiConfig.getAppSecret()));

        StringEntity stringEntity = new StringEntity(JSON.toJSONString(map), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity(stringEntity);
        return httpPost;
    }


    /**
     * 积分响应处理
     *
     * @param body
     * @param addCredits
     * @param authParams
     * @return
     */
    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {
        Map<String, String> map = new HashMap<>();
        if (StringUtils.isBlank(body)) {
            map.put("status", "fail");
            map.put("errorMessage", "好想你新增/扣减积分接口返回为空");
            return JSON.toJSONString(map);
        }
        try {
            if (addCredits) {
                parseAwardIntegralResp(body, map, authParams);
            } else {
                parseReduceIntegralResp(body, map, authParams);
            }
        } catch (Exception e) {
            LOGGER.error("好想你新增/扣减积分接口解析错误:{}--是否新增:{}", body, addCredits, e);
            map.put("status", "fail");
            map.put("errorMessage", "好想你新增/扣减积分解析结果错误");
        }
        return JSONObject.toJSONString(map);
    }


    private void parseAwardIntegralResp(String body, Map<String, String> map, Map<String, String> authParams) {
        PointAddResponse response = JSON.parseObject(body, PointAddResponse.class);
        if (response.getSuccess()) {
            CustomerPointInfo customerPointInfo = response.getResult();
            map.put("status", "ok");
            map.put("bizId", response.getRequestId());
            map.put("credits", customerPointInfo.getAvailPoint().longValue() + "");
        } else {
            LOGGER.warn("好想你，加积分，失败，params={} response={}", JSON.toJSONString(authParams), JSON.toJSONString(response));
            map.put("status", "fail");
            String errorMsg = response.getMsg();
            if (StringUtils.length(errorMsg) > 255) {
                errorMsg = errorMsg.substring(0, 255);
            }
            map.put("errorMessage", errorMsg);
        }
    }

    /**
     * 减积分响应处理
     *
     * @param body
     * @param map
     * @param authParams
     */
    public void parseReduceIntegralResp(String body, Map<String, String> map, Map<String, String> authParams) {
        PointReduceResponse response = JSON.parseObject(body, PointReduceResponse.class);
        if (response.getSuccess()) {
            CustomerPointInfo customerPointInfo = response.getResult();
            map.put("status", "ok");
            map.put("bizId", response.getRequestId());
            map.put("credits", customerPointInfo.getAvailPoint().longValue() + "");
        } else {
            LOGGER.warn("好想你，减积分，失败，params={} response={}", JSON.toJSONString(authParams), JSON.toJSONString(response));
            map.put("status", "fail");
            String errorMsg = response.getMsg();
            if (StringUtils.length(errorMsg) > 255) {
                errorMsg = errorMsg.substring(0, 255);
            }
            map.put("errorMessage", errorMsg);
        }
    }


    /**
     * 充值商品定制请求封装
     *
     * @param request
     * @return
     */
    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String paramsStr = url.substring(url.indexOf('?') + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        request.setAuthParams(params);
        return getRechargeRequest(params);
    }

    private HttpRequestBase getRechargeRequest(Map<String, String> params) {
        HttpPost httpPost = new HttpPost(HaoXiangNiConfig.Api.STORE_COUPON_SEND.getApiAbsolutePath(haoXiangNiConfig));
        Map<String, Object> map = Maps.newHashMap();
        map.put("appKey", haoXiangNiConfig.getAppKey());
        map.put("nonce", System.currentTimeMillis());
        map.put("accessToken", this.getToken());
        map.put("groupId", haoXiangNiConfig.getGroupId());

        JSONObject customerNickInfo = new JSONObject();
        NickInfo nickInfo = this.getNickInfo(params.get("uid"));
        customerNickInfo.put("nick", nickInfo.getNick());
        customerNickInfo.put("platform", nickInfo.getPlatform());
        map.put("customerNickInfo", Lists.newArrayList(customerNickInfo));
        map.put("couponCode", params.get("params"));
        map.put("sendChannelType", 2);
        map.put("shopId", haoXiangNiConfig.getShopId());
        map.put("sign", SignUtils.getSign(map, haoXiangNiConfig.getAppSecret()));
        StringEntity stringEntity = new StringEntity(JSON.toJSONString(map), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity(stringEntity);
        return httpPost;
    }


    public String getVirtualResponse(SupplierRequest request, String body) {
        Map<String, String> params = request.getAuthParams();
        String uid = params.get("uid");
        return getVirtualRechargeResponse(body, uid);

    }

    private String getVirtualRechargeResponse(String body, String uid) {
        Map<String, String> duibaDoc = new HashMap<>();
        if (StringUtils.isBlank(body)) {
            throw new ThirdpatyException("好想你，充值商品定制，返回结果为空");
        }
        try {
            CouponSendListResponse response = JSON.parseObject(body, CouponSendListResponse.class);
            if (response.getSuccess() && response.getResult().getSuccessCount() > 0) {
                duibaDoc.put("status", "success");
                duibaDoc.put("supplierBizId", response.getRequestId());
            } else {
                LOGGER.warn("好想你，充值商品定制，失败，uid={} resp={}", uid, JSON.toJSONString(response));
                duibaDoc.put("status", "fail");
                String errorMsg = response.getMsg();
                if (response.getResult() != null) {
                    CouponSendInfo couponSendInfo = response.getResult();
                    if (couponSendInfo.getFailedCount() > 0 && CollectionUtils.isNotEmpty(couponSendInfo.getFailedCustomerInfo())) {
                        errorMsg = couponSendInfo.getFailedCustomerInfo().get(0).getFailedMessage();
                    }
                }
                if (StringUtils.length(errorMsg) > 255) {
                    errorMsg = errorMsg.substring(0, 255);
                }
                duibaDoc.put("errorMessage", errorMsg);
            }
            duibaDoc.put("credits", getCredits(uid));
        } catch (Exception e) {
            LOGGER.error("好想你，充值商品定制，结果解析错误:{}", body, e);
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", "注券接口响应解析错误");
        }
        return JSON.toJSONString(duibaDoc);
    }

    public String getCredits(String uid) {
        String url = HaoXiangNiConfig.Api.CONSUMER_POINT_INFO_GET.getApiAbsolutePath(haoXiangNiConfig);
        HttpPost httpPost = new HttpPost(url);
        Map<String, Object> map = new HashMap<>();
        map.put("appKey", haoXiangNiConfig.getAppKey());
        map.put("nonce", System.currentTimeMillis());
        map.put("accessToken", getToken());
        map.put("groupId", haoXiangNiConfig.getGroupId());

        NickInfo nickInfo = this.getNickInfo(uid);
        map.put("nick", nickInfo.getNick());
        map.put("platform", nickInfo.getPlatform());
        map.put("integralAccount", haoXiangNiConfig.getIntegralAccount());
        map.put("sign", SignUtils.getSign(map, haoXiangNiConfig.getAppSecret()));

        StringEntity stringEntity = new StringEntity(JSON.toJSONString(map), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity(stringEntity);

        String resp = null;
        try (CloseableHttpResponse response = httpClient.execute(httpPost)) {
            HttpEntity entity = response.getEntity();
            resp = EntityUtils.toString(entity, "UTF-8");
        } catch (IOException e) {
            LOGGER.warn("好想你，获取用户积分，异常，请求参数params={}", JSON.toJSONString(map), e);
            throw new ThirdpatyException("好想你，获取用户积分，异常");
        }
        if (StringUtils.isBlank(resp)) {
            throw new ThirdpatyException("好想你，获取用户积分，失败");
        }
        PointInfoGetResponse response = JSON.parseObject(resp, PointInfoGetResponse.class);
        if (!response.getSuccess()) {
            LOGGER.warn("好想你，获取用户积分，失败，请求参数params={},response={}", JSON.toJSONString(map), JSON.toJSONString(response));
            throw new ThirdpatyException("好想你，获取用户积分，失败");
        }
        String credits = String.valueOf(response.getResult().getAvailPoint().longValue());
        return credits;
    }


    /**
     * 获取会员详情
     *
     * @return
     */
    public NickInfo getNickInfo(String wechatUnionId) {
        String url = HaoXiangNiConfig.Api.CUSTOMER_INFO_4_THIRD_PARTY_GET.getApiAbsolutePath(haoXiangNiConfig);
        HttpPost httpPost = new HttpPost(url);
        Map<String, Object> map = new HashMap<>();
        map.put("appKey", haoXiangNiConfig.getAppKey());
        map.put("nonce", System.currentTimeMillis());
        map.put("accessToken", getToken());
        map.put("groupId", haoXiangNiConfig.getGroupId());
        map.put("wechatUnionid", wechatUnionId);
        map.put("sign", SignUtils.getSign(map, haoXiangNiConfig.getAppSecret()));

        StringEntity stringEntity = new StringEntity(JSON.toJSONString(map), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity(stringEntity);

        String resp = null;
        try (CloseableHttpResponse response = httpClient.execute(httpPost)) {
            HttpEntity entity = response.getEntity();
            resp = EntityUtils.toString(entity, "UTF-8");
        } catch (IOException e) {
            LOGGER.warn("好想你，请求获取会员详情，异常，请求参数params={}", JSON.toJSONString(map), e);
            throw new ThirdpatyException("好想你，请求获取会员详情，异常");
        }
        if (StringUtils.isBlank(resp)) {
            throw new ThirdpatyException("好想你，请求获取会员详情，失败");
        }
        CustomerBasicInfoGetResponse response = JSON.parseObject(resp, CustomerBasicInfoGetResponse.class);
        if (!response.getSuccess()) {
            LOGGER.warn("好想你，请求获取会员详情，失败，params={} response={}", JSON.toJSONString(map), JSON.toJSONString(response));
            throw new ThirdpatyException("好想你，请求获取会员详情，失败");
        }
        return response.getResult().getNickInfoList().get(0);
    }

    /**
     * 获取token
     *
     * @return
     */
    public String getToken() {
        String cacheKey = String.format(CACHE_TOKEN_KEY_FORMAT, haoXiangNiConfig.getAppKey(), haoXiangNiConfig.getGroupId());
        String cacheToken = advancedCacheClient.get(cacheKey);
        if (StringUtils.isNotBlank(cacheToken)) {
            AccessTokenDetail tokenDetail = JSON.parseObject(cacheToken, AccessTokenDetail.class);
            return tokenDetail.getAccessToken();
        }
        String lockKey = String.format(LOCK_TOKEN_KEY_FORMAT, haoXiangNiConfig.getAppKey(), haoXiangNiConfig.getGroupId());
        RedisLock lock = redisAtomicClient.getLock(lockKey, 2);
        if (lock == null) {
            throw new ThirdpatyException("好想你，请求token，获取分布式锁失败");
        }
        try {
            String url = HaoXiangNiConfig.Api.ACCESS_TOKEN_REGISTER.getApiAbsolutePath(haoXiangNiConfig);
            HttpPost httpPost = new HttpPost(url);
            Map<String, Object> map = new HashMap<>();
            map.put("appKey", haoXiangNiConfig.getAppKey());
            map.put("groupId", haoXiangNiConfig.getGroupId());
            map.put("nonce", System.currentTimeMillis());
            map.put("sign", SignUtils.getSign(map, haoXiangNiConfig.getAppSecret()));

            StringEntity stringEntity = new StringEntity(JSON.toJSONString(map), "UTF-8");
            stringEntity.setContentEncoding("UTF-8");
            stringEntity.setContentType("application/json");
            httpPost.setEntity(stringEntity);

            String resp = null;
            try (CloseableHttpResponse response = httpClient.execute(httpPost)) {
                HttpEntity entity = response.getEntity();
                resp = EntityUtils.toString(entity, "UTF-8");
            } catch (IOException e) {
                LOGGER.warn("好想你，请求token，异常，请求参数params={}", JSON.toJSONString(map), e);
                throw new ThirdpatyException("好想你，请求token，异常");
            }
            if (StringUtils.isBlank(resp)) {
                throw new ThirdpatyException("好想你，请求token，失败");
            }
             AccessTokenRegisterResponse accessTokenRegisterResponse = JSON.parseObject(resp, AccessTokenRegisterResponse.class);
            if (!accessTokenRegisterResponse.getSuccess()) {
                LOGGER.warn("好想你，请求token，失败，params={},response={}", JSON.toJSONString(map), JSON.toJSONString(accessTokenRegisterResponse));
                throw new ThirdpatyException("好想你，请求token，失败");
            }
            AccessTokenDetail accessTokenDetail = accessTokenRegisterResponse.getResult();
            Date now = new Date();
            Date expireTime = accessTokenDetail.getExpiredTime();
            long seconds = Duration.between(now.toInstant(), expireTime.toInstant()).getSeconds();
            int exp = (int) (seconds - 10);
            if (exp <= 0) {
                exp = 1;
            }
            //刷新缓存
            advancedCacheClient.set(cacheKey, JSON.toJSONString(accessTokenDetail), exp, TimeUnit.SECONDS);
            return accessTokenDetail.getAccessToken();
        } finally {
            lock.unlock();
        }

    }


}
