package cn.com.duiba.biz.credits.unionpay.impl;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.biz.credits.unionpay.UnionPayRequest;
import cn.com.duiba.constant.GuiYangUnionBankConstants;
import cn.com.duiba.constant.UnionPayConstants;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.DES3Tool;
import cn.com.duiba.tool.UnionPayBankUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

/**
 * 贵阳中信-发云闪付红包
 *
 * @author haojiahong
 * @date 2021-04-13
 */
@Component
public class GuiYangUnionPayRequest implements UnionPayRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(GuiYangUnionPayRequest.class);

    @Autowired
    private GuiYangUnionBankConstants guiYangUnionBankConstants;

    @Autowired
    private UnionPayConstants unionPayConstants;

    @Override
    public Set<Long> getAppIdSet() {
        return guiYangUnionBankConstants.getAppIdSet();
    }

    @Override
    public HttpRequestBase getVirtualRequest(SupplierRequest request, String merchantCoding) {
        if (StringUtils.isBlank(merchantCoding) || !merchantCoding.startsWith(guiYangUnionBankConstants.getVirtualCreditsPre())) {
            return null;
        }
        String url = request.getHttpUrl();
        Long appId = Long.valueOf(request.getAppId());
        String authParams = url.substring(url.indexOf('?') + 1);
        Map<String, String> authParamMap = AssembleTool.getUrlParams(authParams);

        String[] arr = merchantCoding.split("_");
        if (arr.length < 2) {
            LOGGER.info("贵阳中信商品编码错误:{}, orderNum:{}", merchantCoding, authParamMap.get("orderNum"));
            throw new ThirdpatyException("贵阳中信商品编码错误");
        }

        Map<String, String> requestParams = buildVirtualRequestParams(authParamMap, appId, arr[1]);
        LOGGER.info("贵阳中信虚拟商品请求url={} req={}", guiYangUnionBankConstants.getVirtualUrl(), JSON.toJSONString(requestParams));

        HttpPost post = new HttpPost(guiYangUnionBankConstants.getVirtualUrl());
        post.setEntity(new StringEntity(JSON.toJSONString(requestParams), ContentType.APPLICATION_JSON));
        return post;
    }

    /**
     * 构造虚拟商品请求参数
     */
    private Map<String, String> buildVirtualRequestParams(Map<String, String> authParamMap, Long appId, String pointAt) {
        Map<String, String> requestParams = new HashMap<>();
        requestParams.put("appId", unionPayConstants.getAppConfig(String.valueOf(appId)).getAppId());
        requestParams.put("transSeqId", authParamMap.get("orderNum"));
        requestParams.put("transTs", DateUtil.format(new Date(), "yyyyMMddHHmmss"));
        requestParams.put("nonceStr", UnionPayBankUtil.createNonceStr());
        requestParams.put("insAcctId", guiYangUnionBankConstants.getInsAcctId());
        String mobile;
        if (guiYangUnionBankConstants.getMobileUidAppIdSet().contains(appId)) {
            mobile = authParamMap.get("uid");
        } else {
            mobile = authParamMap.get("account");
        }
        requestParams.put("mobile", mobile);
        requestParams.put("acctEntityTp", "01");
        requestParams.put("pointId", guiYangUnionBankConstants.getPointId());
        requestParams.put("pointAt", pointAt);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("campaignId", authParamMap.get("orderNum"));
        jsonObject.put("campaignName", authParamMap.get("orderNum"));
        requestParams.put("busiInfo", jsonObject.toJSONString());
        String desc = authParamMap.get("description");
        if (StringUtils.isNotBlank(desc) && desc.length() > 200) {
            desc = desc.substring(0, 200);
        }
        requestParams.put("transDigest", desc);
        requestParams.put("timestamp", Long.toString(System.currentTimeMillis() / 1000));
        requestParams.put("signature", UnionPayBankUtil.sign(requestParams, unionPayConstants.getPrivateKey()));

        String symmetricKey = unionPayConstants.getSymmetricKey(String.valueOf(appId));
        try {
            LOGGER.info("贵阳中信参数加密appId={},SymmetricKey={},mobile={}", appId, symmetricKey, mobile);
            //先签再加密
            requestParams.put("mobile", DES3Tool.getEncryptedValue(mobile, symmetricKey));
        } catch (Exception e) {
            LOGGER.warn("贵阳中信虚拟商品请求参数加密失败, mobile={}, SymmetricKey={}", mobile, symmetricKey, e);
            throw new ThirdpatyException("贵阳中信请求参数加密失败");
        }
        return requestParams;
    }


    @Override
    public String getVirtualResponse(SupplierRequest request, String body, String merchantCoding) {
        if (StringUtils.isBlank(merchantCoding) || !merchantCoding.startsWith(guiYangUnionBankConstants.getVirtualCreditsPre())) {
            return null;
        }
        return getBaseResponse(body, request);
    }

    @NotNull
    public String getBaseResponse(String body, SupplierRequest request) {
        Map<String, String> map = new HashMap<>();
        LOGGER.info("贵阳中信虚拟商品返回结果为 orderId={} resp={}", request.getOrderId(), body.length() > 500 ? body.substring(0, 500) : body);
        if (StringUtils.isBlank(body)) {
            throw new ThirdpatyException("贵阳中信，虚拟商品定制，返回结果为空");
        }
        try {
            JSONObject jsonObject = JSON.parseObject(body);
            map.put("status", Objects.equals("00", jsonObject.getString("resp")) ? "success" : "fail");
            map.put("errorMessage", StringEscapeUtils.unescapeHtml4(jsonObject.getString("msg")));
            JSONObject params = jsonObject.getJSONObject("params");
            if (params != null) {
                map.put("supplierBizId", params.getString("transSeqId"));
            }
        } catch (Exception e) {
            LOGGER.error("贵阳中信，虚拟商品定制，结果解析错误:{}", body, e);
            map.put("status", "fail");
            map.put("errorMessage", "虚拟商品充值接口响应解析错误");
        }
        return JSON.toJSONString(map);
    }
}