package cn.com.duiba.client;

import cn.com.duiba.api.enums.SubjectTypeEnum;
import cn.com.duiba.constant.nongzonghang.FuLuConfig;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.domain.VirtualSupplierProcessingOrderLogEntity;
import cn.com.duiba.dto.fulu.FuLuBaseReq;
import cn.com.duiba.dto.fulu.FuLuBaseResp;
import cn.com.duiba.dto.fulu.req.OrderDirectAddReq;
import cn.com.duiba.dto.fulu.req.OrderMobileAddReq;
import cn.com.duiba.dto.fulu.resp.OrderDirectAddResp;
import cn.com.duiba.dto.virtualsupplierprocess.MqInfo;
import cn.com.duiba.service.ThreadPoolService;
import cn.com.duiba.service.virtualsupplierprocess.VirtualSupplierProcessOrderService;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.fulu.FuLuUtils;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;


/**
 * @Date 2021/1/9 11:45 上午
 * @Created by cmm
 */
@Component
public class FuLuClient {
    private static final Logger log = LoggerFactory.getLogger(FuLuClient.class);

    private static Set<Integer> UNUSUAL_CODE = Sets.newHashSet(4008, 4009, 4010, 4012, 5000);

    @Autowired
    private FuLuConfig fuluConfig;
    @Autowired
    private VirtualSupplierProcessOrderService virtualSupplierProcessOrderService;
    @Autowired
    private ThreadPoolService threadPoolService;
    /**
     * 获取福禄直充下单请求体
     * @param request
     * @param productId 商品id
     * @param subject  主体，1兑吧2兑啊 SubjectTypeEnum
     * @return
     */
    public HttpRequestBase getFuLuDirectRequest(SupplierRequest request,String productId,String subject) {
        log.info("福禄直充---SupplierRequest:{},productId:{}",JSON.toJSONString(request),productId);
        String url = request.getHttpUrl();
        String paramsStr = url.substring(url.indexOf('?') + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        //兑吧订单号
        String orderNum = params.get("orderNum");
        //用户兑换虚拟商品时输入的账号
        String account = params.get("account");
        request.setAuthParams(params);

        HttpPost httpPost = new HttpPost(fuluConfig.getUrl());
        //拼装请求
        FuLuBaseReq fuLuBaseReq = new FuLuBaseReq(fuluConfig, FuLuConfig.Api.ORDER_DIRECT_ADD.getMethodName());
        String appkey = SubjectTypeEnum.DUIA.getType().equals(subject)? fuluConfig.getDuiaAppKey() : fuluConfig.getAppKey();
        fuLuBaseReq.setAppKey(appkey);
        OrderDirectAddReq orderDirectAddReq = new OrderDirectAddReq();
        orderDirectAddReq.setProductId(Long.valueOf(productId));
        orderDirectAddReq.setCustomerOrderNo(orderNum);
        orderDirectAddReq.setChargeAccount(account);
        orderDirectAddReq.setBuyNum(1);
        fuLuBaseReq.setBizContent(FuLuUtils.toJSON(orderDirectAddReq));
        //如果是兑啊，传兑啊的appSecret否则传兑吧的appSecret
        String appSecret = SubjectTypeEnum.DUIA.getType().equals(subject)? fuluConfig.getDuiaSysSecret() : fuluConfig.getSysSecret();
        fuLuBaseReq.setSign(FuLuUtils.sign(appSecret, fuLuBaseReq));

        StringEntity stringEntity = new StringEntity(FuLuUtils.toJSON(fuLuBaseReq), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity(stringEntity);
        return httpPost;
    }

    /**
     * 获取福禄话费下单请求体
     * @param request
     * @param chargeValue  充值金额单位元
     * @return
     */
    public HttpRequestBase getFuLuMobileRequest(SupplierRequest request,Double chargeValue) {
        log.info("福禄话费---SupplierRequest:{},chargeValue:{}",JSON.toJSONString(request),chargeValue);
        String url = request.getHttpUrl();
        String paramsStr = url.substring(url.indexOf('?') + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        //兑吧订单号
        String orderNum = params.get("orderNum");
        //用户兑换虚拟商品时输入的账号 手机号
        String phone = params.get("account");
        request.setAuthParams(params);
        HttpPost httpPost = new HttpPost(fuluConfig.getUrl());
        //拼装请求
        FuLuBaseReq fuLuBaseReq = new FuLuBaseReq(fuluConfig, FuLuConfig.Api.ORDER_MOBILE_GET.getMethodName());
        OrderMobileAddReq orderDirectAddReq = new OrderMobileAddReq();
        orderDirectAddReq.setChargeValue(chargeValue);
        orderDirectAddReq.setCustomerOrderNo(orderNum);
        orderDirectAddReq.setChargePhone(phone);
        fuLuBaseReq.setBizContent(FuLuUtils.toJSON(orderDirectAddReq));
        fuLuBaseReq.setSign(FuLuUtils.sign(fuluConfig.getSysSecret(), fuLuBaseReq));

        StringEntity stringEntity = new StringEntity(FuLuUtils.toJSON(fuLuBaseReq), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity(stringEntity);
        return httpPost;
    }


    public Map<String, String> getDuibaVirtualResponse(SupplierRequest message, FuLuBaseResp fuluBaseResp, String callbackTopic, String msgTag, String msgKey) {
        Map<String, String> duibaDoc = new HashMap<>();
        //请求成功
        if (Objects.equals(fuluBaseResp.getCode(), 0)) {
            OrderDirectAddResp orderDirectAddResp = JSON.parseObject(fuluBaseResp.getResult(), OrderDirectAddResp.class);
            //下单成功
            if (StringUtils.equals(orderDirectAddResp.getOrderState(), "success")) {
                duibaDoc.put("status", "success");
                duibaDoc.put("supplierBizId", orderDirectAddResp.getOrderId());
                return duibaDoc;
            }
            //下单失败
            if (StringUtils.equals(orderDirectAddResp.getOrderState(), "failed")) {
                log.warn("fulu，下单失败，resp=={}", JSON.toJSONString(fuluBaseResp));
                duibaDoc.put("status", "fail");
                duibaDoc.put("errorMessage", "出了点小问题，请重新下单");
                return duibaDoc;
            }
            //订单未处理或处理中，记录中间状态记录表，发送消息时，会先查询中间状态记录表，如有，会之后通过定时任务轮询订单状态发送消息。
            if (StringUtils.equals(orderDirectAddResp.getOrderState(), "untreated")
                    || StringUtils.equals(orderDirectAddResp.getOrderState(), "processing")) {
                initSave(message, callbackTopic, msgTag, msgKey);
                duibaDoc.put("status", "process");
                return duibaDoc;
            }
        }
        //特殊code，订单进入异常订单
        else if (UNUSUAL_CODE.contains(fuluBaseResp.getCode())) {
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", fuluBaseResp.getMessage());
            return duibaDoc;
        }
        //其他情况：下单失败
        else {
            log.warn("fulu，下单失败，resp=={}", JSON.toJSONString(fuluBaseResp));
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", "出了点小问题，请重新下单");
            return duibaDoc;
        }
        return duibaDoc;
    }

    private void initSave(SupplierRequest message, String callbackTopic, String msgTag, String msgKey) {
        String url = message.getHttpUrl();
        String params = url.substring(url.indexOf('?') + 1);
        // 1.将请求URL的参数转换为MAP
        Map<String, String> paramMap = AssembleTool.getUrlParams(params);

        VirtualSupplierProcessingOrderLogEntity entity = new VirtualSupplierProcessingOrderLogEntity();
        entity.setAppId(Long.valueOf(message.getAppId()));
        entity.setConsumerId(Long.valueOf(message.getConsumerId()));
        entity.setOrderId(Long.valueOf(message.getOrderId()));
        entity.setOrderNum(paramMap.get("orderNum"));
        entity.setSupplierOrderId(Long.valueOf(message.getSupplierOrderId()));
        entity.setSupplierName(message.getSupplierName());
        entity.setHttpUrl(message.getHttpUrl());
        MqInfo mqInfo = new MqInfo();
        mqInfo.setMqCallbackTopic(callbackTopic);
        mqInfo.setMqTag(msgTag);
        mqInfo.setMqMsgKey(msgKey);
        entity.setMqInfo(JSON.toJSONString(mqInfo));
        virtualSupplierProcessOrderService.initSave(entity);
    }
}
