package cn.com.duiba.constant;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.biz.credits.strategy.Impl.DemoApiStrategy;
import com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

/**
 * cmm
 **/
@Configuration
@ConfigurationProperties(prefix = "demo.strategy")
public class DemoConfig implements InitializingBean {

    private static final Logger log = LoggerFactory.getLogger(DemoConfig.class);

    @Autowired
    private DemoApiStrategy demoApiStrategy;

    /** 应用id集合*/
    private Set<Long> appIdSet = Sets.newHashSet(9999999L);

    /**
     * 注册方法尽量放到配置类里，因为开发者可能会增加appId，刷新阿波罗配置会重新走一遍afterPropertiesSet方法，从而达到动态注册的效果
     * @throws Exception
     */
    @Override
    public void afterPropertiesSet() throws Exception {
        log.info("开始注册策略---------");
        ApiStrategyRouter.register(appIdSet, demoApiStrategy);
    }

    public Set<Long> getAppIdSet() {
        return appIdSet;
    }

    public void setAppIdSet(Set<Long> appIdSet) {
        this.appIdSet = appIdSet;
    }

}

