package cn.com.duiba.constant;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

/**
 * @author: zhengjianhao
 * @date: 2020/4/17 16:54
 * @description: 河北移动配置
 */
@Configuration
@ConfigurationProperties(prefix = "hebei.mobile")
public class HeBeiMobileConfig {

    /**
     * 应用id集合
     */
    private Set<Long> appIdSet;

    /**
     * 请求地址
     */
    private String url = "http://hb.tztec.com:10000/app/api/app_api_V2.int";

    /**
     * 接口入参-用户名
     */
    private String askacc = "duiba";

    /**
     * 接口入参-密码
     */
    private String askcode = "xw#@duiba";

    /**
     * 接口入参-渠道id
     */
    private String channelCode = "duiba";

    /**
     * 获取token接口入参-url
     */
    private String requestUrlToken = "getTokenLocalService";

    /**
     * 发送卡券接口入参-url
     */
    private String requestUrlSendCard = "queryChargeService";

    /**
     * 获取token是否走缓存
     */
    private Boolean tokenByCache = true;

    public Set<Long> getAppIdSet() {
        return appIdSet;
    }

    public void setAppIdSet(Set<Long> appIdSet) {
        this.appIdSet = appIdSet;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getAskacc() {
        return askacc;
    }

    public void setAskacc(String askacc) {
        this.askacc = askacc;
    }

    public String getAskcode() {
        return askcode;
    }

    public void setAskcode(String askcode) {
        this.askcode = askcode;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getRequestUrlToken() {
        return requestUrlToken;
    }

    public void setRequestUrlToken(String requestUrlToken) {
        this.requestUrlToken = requestUrlToken;
    }

    public String getRequestUrlSendCard() {
        return requestUrlSendCard;
    }

    public void setRequestUrlSendCard(String requestUrlSendCard) {
        this.requestUrlSendCard = requestUrlSendCard;
    }

    public Boolean getTokenByCache() {
        return tokenByCache;
    }

    public void setTokenByCache(Boolean tokenByCache) {
        this.tokenByCache = tokenByCache;
    }

    public boolean isHeBeiMobile(Long appId) {
        return appId != null
                && CollectionUtils.isNotEmpty(appIdSet)
                && appIdSet.contains(appId);
    }
}

