package cn.com.duiba.constant;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Map;

/**
 * @author qiurenjie
 * @date 2021-07-15 20:09
 */
@Configuration
@ConfigurationProperties(prefix = "virtual.huazhu")
public class HuazhuConfig implements InitializingBean {

    //app主体对应的密钥
    private String appConfigBySubject;
    private Map<String, Object> appConfigBySubjectMap = Maps.newHashMap();
    //请求域名
    private String domain = "https://crm-bd.huazhu.com";
    //业务编码
    private String activityId = "";

    @Override
    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isNotBlank(appConfigBySubject)) {
            appConfigBySubjectMap = JSON.parseObject(appConfigBySubject);
        }
    }

    public String getAppConfigBySubject() {
        return appConfigBySubject;
    }

    public void setAppConfigBySubject(String appConfigBySubject) {
        this.appConfigBySubject = appConfigBySubject;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getActivityId() {
        return activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public Map<String, Object> getAppConfigBySubjectMap() {
        return appConfigBySubjectMap;
    }

    public void setAppConfigBySubjectMap(Map<String, Object> appConfigBySubjectMap) {
        this.appConfigBySubjectMap = appConfigBySubjectMap;
    }

}
