package cn.com.duiba.constant;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.biz.credits.strategy.Impl.LenovoApiStrategy;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author haojiahong
 * @date 2021-08-03
 */
@Configuration
@ConfigurationProperties(prefix = "lenovo.multi")
public class LenovoMultiConfig implements InitializingBean {

    private static final Logger LOGGER = LoggerFactory.getLogger(LenovoMultiConfig.class);

    @Autowired
    private LenovoApiStrategy lenovoApiStrategy;

    private String configStr = "[{\"appIdSet\":[84929],\"crecordNotifyUrl\":\"https://devmmembership.lenovo.com.cn/member-center/member-center-outer-api/duiba/giftRecordSynchronize\"},{\"appIdSet\":[84373],\"crecordNotifyUrl\":\"https://mmembership.lenovo.com.cn/member-center/member-center-outer-api/duiba/giftRecordSynchronize\"}]";

    private Map<Long, String> configMap;


    @Override
    public void afterPropertiesSet() throws Exception {
        try {
            if (StringUtils.isNotBlank(configStr)) {
                configMap = new HashMap<>();
                List<LenovoMultiBean> list = JSON.parseArray(configStr, LenovoMultiBean.class);
                for (LenovoMultiBean lenovoMultiBean : list) {
                    for (Long appId : lenovoMultiBean.getAppIdSet()) {
                        configMap.put(appId, lenovoMultiBean.getCrecordNotifyUrl());
                    }
                }
            }
            LOGGER.info("联想定制，配置初始化成功，configStr={}", configStr);
        } catch (Exception e) {
            LOGGER.warn("联想定制，配置初始化异常，configStr={}", configStr);
        }
        LOGGER.info("联想开始注册策略---------");
        ApiStrategyRouter.register(configMap.keySet(), lenovoApiStrategy);

    }

    public String getConfigStr() {
        return configStr;
    }

    public void setConfigStr(String configStr) {
        this.configStr = configStr;
    }

    public Map<Long, String> getConfigMap() {
        return configMap;
    }

    public void setConfigMap(Map<Long, String> configMap) {
        this.configMap = configMap;
    }

    public static class LenovoMultiBean {

        private Set<Long> appIdSet;

        private String crecordNotifyUrl;

        public Set<Long> getAppIdSet() {
            return appIdSet;
        }

        public void setAppIdSet(Set<Long> appIdSet) {
            this.appIdSet = appIdSet;
        }

        public String getCrecordNotifyUrl() {
            return crecordNotifyUrl;
        }

        public void setCrecordNotifyUrl(String crecordNotifyUrl) {
            this.crecordNotifyUrl = crecordNotifyUrl;
        }
    }

    public static void main(String[] args) {
        List<LenovoMultiBean> list = Lists.newArrayList();
        LenovoMultiBean bean1 = new LenovoMultiBean();
        bean1.setAppIdSet(Sets.newHashSet(84929L));
        bean1.setCrecordNotifyUrl("https://devmmembership.lenovo.com.cn/member-center/member-center-outer-api/duiba/giftRecordSynchronize");
        list.add(bean1);

        LenovoMultiBean bean2 = new LenovoMultiBean();
        bean2.setAppIdSet(Sets.newHashSet(84373L));
        bean2.setCrecordNotifyUrl("https://mmembership.lenovo.com.cn/member-center/member-center-outer-api/duiba/giftRecordSynchronize");
        list.add(bean2);



        System.out.println(JSON.toJSONString(list));
    }

}
