package cn.com.duiba.dto;

import java.io.Serializable;

/**
 * Created by fangdong on 2018/10/17.
 */
public class AppSimpleDto implements Serializable {
    private static final long serialVersionUID = 3127921401934762974L;

    public static final int SWITCH_CREDITS_LOG = 32; // 是否开启积分流水开关,默认关闭

    private Long id; //id
    private Long developerId;//开发者Id
    private String appKey;//应用唯一标识
    private Long appSwitch; //开关
    private String secretCode;
    private String recordNotifyUrl;//兑换记录通知链接
    private String creditsConsumeNotifyUrl; // 积分消耗的结果通知地址

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getDeveloperId() {
        return developerId;
    }

    public void setDeveloperId(Long developerId) {
        this.developerId = developerId;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public Long getAppSwitch() {
        return appSwitch;
    }

    public void setAppSwitch(Long appSwitch) {
        this.appSwitch = appSwitch;
    }

    public String getRecordNotifyUrl() {
        return recordNotifyUrl;
    }

    public void setRecordNotifyUrl(String recordNotifyUrl) {
        this.recordNotifyUrl = recordNotifyUrl;
    }

    public String getCreditsConsumeNotifyUrl() {
        return creditsConsumeNotifyUrl;
    }

    public void setCreditsConsumeNotifyUrl(String creditsConsumeNotifyUrl) {
        this.creditsConsumeNotifyUrl = creditsConsumeNotifyUrl;
    }

    public String getSecretCode() {
        return secretCode;
    }

    public void setSecretCode(String secretCode) {
        this.secretCode = secretCode;
    }

    /**
     * 用来判断开关位的状态
     * @param boundType 开关位
     * @return 是否开启
     */
    public boolean isAppSwitch(int boundType) {
        long v = 1 << boundType;
        long ret = appSwitch & v;
        return ret != 0;
    }

    @Override
    public String toString() {
        return "AppSimpleDto{" +
                "id=" + id +
                ", developerId=" + developerId +
                ", appKey='" + appKey + '\'' +
                ", appSwitch=" + appSwitch +
                ", secretCode='" + secretCode + '\'' +
                ", recordNotifyUrl='" + recordNotifyUrl + '\'' +
                ", creditsConsumeNotifyUrl='" + creditsConsumeNotifyUrl + '\'' +
                '}';
    }
}
