package cn.com.duiba.remoteimpl.cgb;

import cn.com.duiba.biz.credits.CgbBankApi;
import cn.com.duiba.constant.CgbBankConfig;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.thirdparty.api.cgb.RemoteCgbPushService;
import cn.com.duiba.thirdparty.dto.cgb.PushCouponDto;
import cn.com.duiba.thirdparty.dto.cgb.PushCouponRequest;
import cn.com.duiba.thirdparty.dto.cgb.SvcInfo;
import cn.com.duiba.thirdparty.dto.cgb.TermInfo;
import cn.com.duiba.thirdparty.dto.cgb.TranInfo;
import cn.com.duiba.tool.cgb.CgbSign;
import cn.com.duiba.tool.cgb.MD5;
import cn.com.duiba.tool.cgb.SM4Util;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.UUID;

/**
 * @Author: lufeng
 * @Description:
 * @Date: Created in 2020/6/18
 */
@RestController
public class RemoteCgbPushServiceImpl implements RemoteCgbPushService {

    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteCgbPushServiceImpl.class);

    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;
    @Autowired
    private CgbBankConfig cgbBankConfig;
    @Autowired
    private CgbBankApi cgbBankApi;

    //兑吧私钥
    private static String merchantPriKey="duiba.pvk";
    //兑吧公钥
    private static String merchantPubKey="duiba.puk";
    //广发公钥
    private static String guangfaPubKey="guangfa.puk";
    private static String encoding="UTF-8";
    private static String contentType="application/json";

    @Override
    public void pushCouponMessage(Long appId, List<PushCouponDto> pushCouponDtos) {
        LOGGER.info("广发中心上架优惠券推送-开始, appId={}", appId);
        if(!cgbBankApi.isCgbBank(appId)){
            return;
        }
        String httpUrl = null;
        try {
            httpUrl = cgbBankConfig.getHttpUrl();

            HttpPost http = new HttpPost(httpUrl);
            PushCouponRequest pushCouponRequest = getPushRequestRequest(pushCouponDtos);
            JSONObject reqStr = (JSONObject) JSONObject.toJSON(pushCouponRequest);

            JSONObject jsonObject1 = new JSONObject();
            jsonObject1.put("Header", getHeadJson());
            JSONObject jsonObject2 = new JSONObject();
            jsonObject2.put("Body", reqStr);

            JSONObject allJsonObject = new JSONObject();
            allJsonObject.putAll(jsonObject1);
            allJsonObject.putAll(jsonObject2);

            String dataStr = allJsonObject.toJSONString();
            LOGGER.info("广发中心上架优惠券推送,报文原文={}", dataStr);

            //签名
            String signature= CgbSign.sign(dataStr,merchantPriKey,encoding);
            String certId= MD5.getMD5(merchantPubKey);

            //加密
            RandomStringUtils rs = new RandomStringUtils();
            String verifyChars = "123457890abcdefghijklmnopqrstuvwxyz";
            String encryptKey = rs.random(16, verifyChars).toUpperCase();

            byte[] encryptBytes= SM4Util.encryptCBC(dataStr.getBytes(encoding), encryptKey.getBytes(), encryptKey.getBytes());
            String reqEncrypStr= Base64.getEncoder().encodeToString(encryptBytes);
            LOGGER.info("广发中心上架优惠券推送,报文加密结果={}", reqEncrypStr);

            //使用广发公钥对密码进行加密
            String encryptKey1=CgbSign.sm2EncryptString(encryptKey, guangfaPubKey, encoding);

            http.addHeader("signature",signature);
            http.addHeader("signType","SM2");
            http.addHeader("encryptType","SM4");
            http.addHeader("encryptKey",encryptKey1);
            http.addHeader("certId",certId);

            StringEntity stringEntity = new StringEntity(reqEncrypStr, contentType, encoding);
            http.setEntity(stringEntity);

            httpAsyncClientPool.submit(appId.toString(), http, new FutureCallback<HttpResponse>() {

                @Override
                public void completed(HttpResponse response) {
                    try {
                        LOGGER.info("广发中心上架优惠券推送-通知成功,statusCode={}", response.getStatusLine().getStatusCode());

                        String result = EntityUtils.toString(response.getEntity());
                        LOGGER.info("广发中心上架优惠券推送-通知成功。返回报文结果={}", result);

                        //解密
                        byte[] decryptBytes=SM4Util.decryptCBC(Base64.getDecoder().decode(result), encryptKey.getBytes(), encryptKey.getBytes());
                        String respStr=new String(decryptBytes,encoding);
                        LOGGER.info("广发中心上架优惠券推送-通知成功。返回报文解密结果={}", respStr);

                        //验签
                        String respSignature = response.getHeaders("signature")[0].getValue();
                        LOGGER.info("广发中心上架优惠券推送-通知成功。返回签名signature={}", respSignature);
                        boolean veryfyResult=CgbSign.veryfySign(respStr, respSignature, guangfaPubKey, encoding);
                        LOGGER.info("广发中心上架优惠券推送-通知成功。返回报文验签结果={}", veryfyResult);
                    } catch (Exception e) {
                        LOGGER.error("广发中心上架优惠券推送-通知成功。处理返回数据异常" , e);
                    }
                }

                @Override
                public void failed(Exception ex) {
                    LOGGER.info("广发中心上架优惠券推送-通知失败", ex);
                }

                @Override
                public void cancelled() {
                    LOGGER.info("广发中心上架优惠券推送-通知取消");
                }
            }, null);
        }catch (Exception e){
            LOGGER.info("广发中心上架优惠券推送异常, 请求路径={}", httpUrl, e);
        }
    }

    private JSONObject getHeadJson() {
        JSONObject headJson = new JSONObject();
        headJson.put("version", "1.0.0");
        headJson.put("instId", "0120200616000002");
        headJson.put("appId", "01202006160000020001");
        headJson.put("productCode", "lifeValue");
        headJson.put("tradeCode", "compSvcInfoSync");
        headJson.put("signType", "SM2");
        headJson.put("senderSN", UUID.randomUUID().toString().substring(0,32));
        headJson.put("requestTime", formatDateToSS(new Date()));
        return headJson;
    }

    private PushCouponRequest getPushRequestRequest(List<PushCouponDto> pushCouponDtos) {
        PushCouponRequest request = new PushCouponRequest();

        TermInfo termInfo = new TermInfo();
        termInfo.setTranChannel("TC");
        request.setTermInfo(termInfo);

        TranInfo tranInfo = new TranInfo();
        tranInfo.setIssuer("30000150");
        tranInfo.setNum(pushCouponDtos.size());
        request.setTranInfo(tranInfo);

        List<SvcInfo> svcInfos = Lists.newArrayList();
        for (PushCouponDto pushCouponDto : pushCouponDtos) {
            SvcInfo svcInfo = new SvcInfo();
            svcInfo.setThirdActNo(pushCouponDto.getAppItemId().toString());
            svcInfo.setSvcName(pushCouponDto.getName());
            svcInfo.setStartTime(formatDateToSS(new Date()));
            if (pushCouponDto.getValidEndDateList() != null) {
                svcInfo.setEndTime(formatDateToSS(pushCouponDto.getValidEndDateList()));
                svcInfo.setShowEndDate(formatDateToSS(pushCouponDto.getValidEndDateList()));
                svcInfo.setSvcCyc(formatDateToDD(pushCouponDto.getValidEndDateList()));
            }
            svcInfo.setShowStartDate(formatDateToSS(new Date()));
            svcInfo.setSvcSummery(pushCouponDto.getName());
            if (pushCouponDto.getDescription() != null) {
                String description = pushCouponDto.getDescription().replaceAll("<{1}[^<>]*>{1}","");
                if (description.length() > 1000) {
                    svcInfo.setSvcDetail(description.substring(0,1000));
                } else {
                    svcInfo.setSvcDetail(description);
                }
            }
            svcInfo.setTotalNum(pushCouponDto.getStock());
            svcInfo.setCustNum(pushCouponDto.getLimitCountForever() == null ? 100 : pushCouponDto.getLimitCountForever());
            svcInfo.setDayLimitNum(pushCouponDto.getLimitCountEveryday() == null ? 100 : pushCouponDto.getLimitCountEveryday());
            svcInfo.setSvcCycType("02");
            svcInfo.setCouponAmt(0.00);
            svcInfo.setSvcListPic(pushCouponDto.getSmallImage());
            svcInfo.setSvcDetailPic(pushCouponDto.getImage());
            svcInfo.setActiveCate(pushCouponDto.getActiveCate());
            svcInfos.add(svcInfo);
        }
        request.setSvcInfo(svcInfos);
        return request;
    }

    //将时间转换成 yyyyMMddHHmmss 格式
    private String formatDateToSS(Date date) {
        LocalDateTime time=date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        DateTimeFormatter dtf2 = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        return dtf2.format(time);
    }

    //将时间转换成 yyyy-MM-dd 格式
    private String formatDateToDD(Date date) {
        LocalDateTime time=date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        DateTimeFormatter dtf2 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        return dtf2.format(time);
    }



}
