package cn.com.duiba.remoteimpl.zhiji;

import cn.com.duiba.enums.zhiji.ZhiJiCodeEnum;
import cn.com.duiba.enums.zhiji.ZhiJiStatusEnum;
import cn.com.duiba.thirdparty.api.zhiji.RemoteZhiJiService;
import cn.com.duiba.thirdparty.dto.zhiji.ZhiJiCreditsDto;
import cn.com.duiba.thirdparty.dto.zhiji.ZhiJiOrderInfoDto;
import cn.com.duiba.thirdparty.dto.zhiji.request.ZhiJiCreditsRequest;
import cn.com.duiba.thirdparty.dto.zhiji.request.ZhiJiGoodsRequest;
import cn.com.duiba.thirdparty.dto.zhiji.request.ZhiJiOrderInfoRequest;
import cn.com.duiba.thirdparty.dto.zhiji.response.ZhiJiOrderResponse;
import cn.com.duiba.thirdparty.dto.zhiji.response.ZhiJiResponse;
import cn.com.duiba.thirdparty.dto.zhiji.ZhiJiReturnFlowDto;
import cn.com.duiba.thirdparty.dto.zhiji.ZhiJiUserReceivedAddressDto;
import cn.com.duiba.tool.zhiji.ZhiJiParamTool;
import com.alibaba.fastjson.JSON;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;
import javax.annotation.Resource;
import java.util.*;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author: pengyi
 * @description: 智己汽车-对外接口实现
 * @date: 2021/9/1 下午1:52
 */
@RestController
public class RemoteZhiJiServiceImpl implements RemoteZhiJiService {

    private static final Logger log = LoggerFactory.getLogger(RemoteZhiJiServiceImpl.class);
    @Resource(name = "httpClient")
    private CloseableHttpClient httpClient;

    @Override
    public String saveReceiveAddress(ZhiJiUserReceivedAddressDto dto) {
        HttpPost httpPost = ZhiJiParamTool.createHttpPost(dto, "");
        try(final CloseableHttpResponse response = httpClient.execute(httpPost)) {
            // 响应参数
            String responseStr = EntityUtils.toString(response.getEntity());
            log.info("智己-新增收获地址信息，智己响应参数，param:{}", responseStr);
            ZhiJiResponse respParam = JSONObject.parseObject(responseStr, ZhiJiResponse.class);
            // 智己侧响应失败
            if (ZhiJiStatusEnum.FAIL.getCode().equals(respParam.getStatus()) || !ZhiJiCodeEnum.SUCCESS.getCode().equals(respParam.getCode())) {
                log.warn("智己-新增收获地址信息，智己响应失败，param:{}", responseStr);
                return ZhiJiStatusEnum.FAIL.getCode();
            }
            // 响应成功
            return respParam.getAddressId();
        } catch (Exception e) {
            log.warn("智己-新增收获地址信息，智己响应异常，param:{}", dto, e);
        }
        return ZhiJiStatusEnum.FAIL.getCode();
    }

    @Override
    public Long removeReceiveAddress(ZhiJiUserReceivedAddressDto dto) {
        HttpPost httpPost = ZhiJiParamTool.createHttpPost(dto,"");
        try(final CloseableHttpResponse response = httpClient.execute(httpPost)) {
            // 响应参数
            String responseStr = EntityUtils.toString(response.getEntity());
            log.info("智己-删除收获地址信息，智己响应参数，param:{}", responseStr);
            ZhiJiResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiResponse.class);
            // 智己侧响应失败
            if (ZhiJiStatusEnum.FAIL.getCode().equals(zhiJiResponse.getStatus()) || !ZhiJiCodeEnum.SUCCESS.getCode().equals(zhiJiResponse.getCode())) {
                log.warn("智己-删除收获地址信息，智己响应失败，param:{}", responseStr);
                return -1L;
            }
            // 响应成功
            return 1L;
        } catch (Exception e) {
            log.warn("智己-删除收获地址信息，智己响应异常，param:{}", dto, e);
        }
        return -1L;
    }

    @Override
    public Long updateReceiveAddress(ZhiJiUserReceivedAddressDto dto) {
        HttpPost httpPost = ZhiJiParamTool.createHttpPost(dto,"");
        try(final CloseableHttpResponse response = httpClient.execute(httpPost)) {
            // 响应参数
            String responseStr = EntityUtils.toString(response.getEntity());
            log.info("智己-编辑收获地址信息，智己响应参数，param:{}", responseStr);
            ZhiJiResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiResponse.class);
            // 智己侧响应失败
            if (ZhiJiStatusEnum.FAIL.getCode().equals(zhiJiResponse.getStatus()) || !ZhiJiCodeEnum.SUCCESS.getCode().equals(zhiJiResponse.getCode())) {
                log.warn("智己-编辑收货地址信息，智己响应失败，param:{}", responseStr);
                return -1L;
            }
            // 响应成功
            return 1L;
        } catch (Exception e) {
            log.warn("智己-编辑收货地址信息，智己响应异常，param:{}", dto, e);
        }
        return -1L;
    }

    @Override
    public List<ZhiJiUserReceivedAddressDto> selectReceiveAddress(ZhiJiUserReceivedAddressDto dto) {
        HttpPost httpPost = ZhiJiParamTool.createHttpPost(dto,"");
        try(final CloseableHttpResponse response = httpClient.execute(httpPost)) {
            // 响应参数
            String responseStr = EntityUtils.toString(response.getEntity());
            log.info("智己-查询收获地址信息，智己响应参数，param:{}", responseStr);
            ZhiJiResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiResponse.class);
            // 智己侧响应失败
            if (ZhiJiStatusEnum.FAIL.getCode().equals(zhiJiResponse.getStatus()) || !ZhiJiCodeEnum.SUCCESS.getCode().equals(zhiJiResponse.getCode())) {
                log.warn("智己-查询收货地址信息，智己响应失败，param:{}", responseStr);
                return Collections.emptyList();
            }
            List<ZhiJiUserReceivedAddressDto> dtoList = JSONObject.parseArray(JSONObject.toJSONString(zhiJiResponse.getData()), ZhiJiUserReceivedAddressDto.class);
            // 响应成功
            return dtoList;
        } catch (Exception e) {
            log.warn("智己-查询收货地址信息，智己响应异常，param:{}", dto, e);
        }
        return Collections.emptyList();
    }

    @Override
    public Long saveReturnFlow(ZhiJiReturnFlowDto dto) {
        HttpPost httpPost = ZhiJiParamTool.createHttpPost(dto,"");
        try(final CloseableHttpResponse response = httpClient.execute(httpPost)) {
            // 响应参数
            String responseStr = EntityUtils.toString(response.getEntity());
            log.info("智己-推送退货物流信息，智己响应参数，param:{}", responseStr);
            ZhiJiResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiResponse.class);
            // 智己侧响应失败
            if (ZhiJiStatusEnum.FAIL.getCode().equals(zhiJiResponse.getStatus()) || !ZhiJiCodeEnum.SUCCESS.getCode().equals(zhiJiResponse.getCode())) {
                log.warn("智己-推送退货物流信息，智己响应失败，param:{}", responseStr);
                return -1L;
            }
            // 响应成功
            return 1L;
        } catch (Exception e) {
            log.warn("智己-推送退货物流信息，智己响应异常，param:{}", dto, e);
        }
        return -1L;
    }

    @Override
    public ZhiJiOrderResponse syncOrderInfo(ZhiJiOrderInfoDto orderInfoDto) {
        // 构造订单同步信息
        ZhiJiOrderInfoRequest orderInfoRequest = generateOrderInfo(orderInfoDto);
        HttpPost httpPost = ZhiJiParamTool.createHttpPost(orderInfoRequest, "");
        try(final CloseableHttpResponse response = retryRequest(httpPost)) {
            // 响应参数
            String responseStr = EntityUtils.toString(response.getEntity());
            log.info("智己-同步订单信息信息，智己响应参数，param:{}", responseStr);
            ZhiJiOrderResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiOrderResponse.class);
            // 智己侧响应失败
            if (ZhiJiStatusEnum.FAIL.getCode().equals(zhiJiResponse.getStatus()) || !ZhiJiCodeEnum.SUCCESS.getCode().equals(zhiJiResponse.getCode())) {
                log.warn("智己-同步订单信息，智己响应失败，param:{}", responseStr);
                return null;
            }
            // 响应成功
            return zhiJiResponse;
        } catch (Exception e) {
            log.warn("智己-同步订单信息，智己响应异常，param:{}", orderInfoDto, e);
        }
        return null;
    }

    @Override
    public ZhiJiOrderResponse syncOrderStatus(String orderNum, String status) {
        // 构造订单同步信息
        Map<String, Object> map = new HashMap<>();
        map.put("sourceCode", "DUIBA");
        map.put("traceId", orderNum + RandomUtils.nextInt(100000, 999999));
        map.put("timestamp", System.currentTimeMillis());
        map.put("orderStatus", status);
        map.put("orderNum", orderNum);
        HttpPost httpPost = ZhiJiParamTool.createHttpPost(map, "");
        try(final CloseableHttpResponse response = retryRequest(httpPost)) {
            // 响应参数
            String responseStr = EntityUtils.toString(response.getEntity());
            log.info("智己-同步订单信息信息，智己响应参数，param:{}", responseStr);
            ZhiJiOrderResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiOrderResponse.class);
            // 智己侧响应失败
            if (ZhiJiStatusEnum.FAIL.getCode().equals(zhiJiResponse.getStatus()) || !ZhiJiCodeEnum.SUCCESS.getCode().equals(zhiJiResponse.getCode())) {
                log.warn("智己-同步订单信息，智己响应失败，param:{}", responseStr);
                return null;
            }
            // 响应成功
            return zhiJiResponse;
        } catch (Exception e) {
            log.warn("智己-同步订单信息，智己响应异常，orderNum:{}, status:{}", orderNum, status, e);
        }
        return null;
    }

    @Override
    public JSONObject getUserCredits(String superiId) {
        Map<String, Object> params = new HashMap<>();
        params.put("superiId", superiId);
        params.put("sourceCode", "DUIBA");
        params.put("traceId", System.currentTimeMillis() + StringUtils.EMPTY + RandomUtils.nextInt(100000, 999999));
        HttpPost httpPost = ZhiJiParamTool.createHttpRequest(params,"");
        try(final CloseableHttpResponse response = httpClient.execute(httpPost)) {
            // 响应参数
            String responseStr = EntityUtils.toString(response.getEntity());
            log.info("智己-查询用户积分，智己响应参数，param:{}", responseStr);
            ZhiJiResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiResponse.class);
            // 智己侧响应失败
            if (!ZhiJiCodeEnum.SUCCESS_1.getCode().equals(zhiJiResponse.getCode())) {
                log.warn("智己-查询用户积分，智己响应失败，param:{}", responseStr);
                return null;
            }
            // 响应成功
            return JSONObject.parseObject(zhiJiResponse.getData().toString());
        } catch (Exception e) {
            log.warn("智己-查询用户积分，智己响应异常，param:{}", superiId, e);
        }
        return null;
    }

    @Override
    public JSONObject queryUserInfo(String token) {
        Map<String, Object> params = new HashMap<>();
        params.put("accessToken", token);
        HttpPost httpPost = ZhiJiParamTool.createHttpRequest(params,"");
        try(final CloseableHttpResponse response = httpClient.execute(httpPost)) {
            // 响应参数
            String responseStr = EntityUtils.toString(response.getEntity());
            log.info("智己-查询用户id信息，智己响应参数，param:{}", responseStr);
            ZhiJiResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiResponse.class);
            // 智己侧响应失败
            if (!ZhiJiCodeEnum.SUCCESS_1.getCode().equals(zhiJiResponse.getCode())) {
                log.warn("智己-查询用户id信息，智己响应失败，param:{}", responseStr);
                return null;
            }
            // 响应成功
            return JSONObject.parseObject(zhiJiResponse.getData().toString());
        } catch (Exception e) {
            log.warn("智己-查询用户id信息，智己响应异常，param:{}", token, e);
        }
        return null;
    }

    @Override
    public boolean syncGoods(Map<String, Object> params) {
        HttpPost httpPost = ZhiJiParamTool.createHttpRequest(params,"");
        try(final CloseableHttpResponse response = httpClient.execute(httpPost)) {
            // 响应参数
            String responseStr = EntityUtils.toString(response.getEntity());
            log.info("智己-同步商品信息，智己响应参数，param:{}", responseStr);
            ZhiJiResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiResponse.class);
            // 智己侧响应失败
            if (ZhiJiStatusEnum.FAIL.getCode().equals(zhiJiResponse.getStatus()) || !ZhiJiCodeEnum.SUCCESS.getCode().equals(zhiJiResponse.getCode())) {
                log.warn("智己-同步商品信息，智己响应失败，param:{}", responseStr);
                return false;
            }
            JSONObject jsonObject = JSONObject.parseObject(zhiJiResponse.getData().toString());
            // 响应成功
            return Objects.equals(jsonObject.getString("code"), "0");
        } catch (Exception e) {
            log.warn("智己-同步商品信息，智己响应异常，param:{}", JSON.toJSONString(params), e);
        }
        return false;
    }


    public CloseableHttpResponse retryRequest(HttpUriRequest httpRequest) {
        CloseableHttpResponse response = null;
        for (int i = 0; i < 2; i++) {
            try {
                response = httpClient.execute(httpRequest);
                String responseStr = EntityUtils.toString(response.getEntity());
                log.info("智己-同步订单信息信息，智己响应参数，param:{}", responseStr);
                ZhiJiOrderResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiOrderResponse.class);
                // 智己侧响应失败
                if (ZhiJiStatusEnum.OK.getCode().equals(zhiJiResponse.getStatus()) || ZhiJiCodeEnum.SUCCESS.getCode().equals(zhiJiResponse.getCode())) {
                    return response;
                }
                if (i > 0) {
                    log.warn("智己-同步订单信息，智己响应失败，第{}次重试，param:{}", i, responseStr);
                }
            } catch (IOException e) {
                log.warn("智己-同步订单信息，智己响应异常，param:{}", httpRequest);
            }
        }
        return response;
    }

    /**
     * 构建智己订单请求参数
     * @param orderInfoDto
     * @return
     */
    public ZhiJiOrderInfoRequest generateOrderInfo(ZhiJiOrderInfoDto orderInfoDto) {
        ZhiJiOrderInfoRequest orderInfoRequest = BeanUtils.copy(orderInfoDto, ZhiJiOrderInfoRequest.class);
        orderInfoRequest.setImSuperId(orderInfoDto.getSuperId());
        orderInfoRequest.setWeborderNumber(orderInfoDto.getOrderNum());
        orderInfoRequest.setStatus(orderInfoDto.getOrderStatus());
        orderInfoRequest.setImPoints(orderInfoDto.getCredits());
        orderInfoRequest.setImAmount(orderInfoDto.getPrice());
        orderInfoRequest.setComments(orderInfoDto.getMark());
        orderInfoRequest.setImLicenseAddress(orderInfoDto.getAddressSnapshot());
        // 礼赏服务
        ZhiJiCreditsDto creditsDto = orderInfoDto.getRedeemPointData();
        ZhiJiCreditsRequest creditsRequest = BeanUtils.copy(creditsDto, ZhiJiCreditsRequest.class);
        creditsRequest.setRedeemPoints(creditsDto.getRedeemPoints());
        creditsRequest.setRedeemTime(creditsDto.getRedeemTime());
        orderInfoRequest.setReducePointData(JSON.toJSONString(creditsRequest));
        // 商品信息
        List<ZhiJiGoodsRequest> orderLine = new ArrayList<>();
        orderInfoDto.getGoodsList().forEach(zhiJiGoodsDto -> {
            ZhiJiGoodsRequest goodsRequest = new ZhiJiGoodsRequest();
            goodsRequest.setImGoodsType(zhiJiGoodsDto.getOrderType());
            goodsRequest.setProduct(zhiJiGoodsDto.getGoodsTitle());
            goodsRequest.setGoodsId(zhiJiGoodsDto.getGoodsId());
            goodsRequest.setImPoints(zhiJiGoodsDto.getCredits());
            goodsRequest.setImAmount(zhiJiGoodsDto.getPrice());
            goodsRequest.setQuantityRequested(zhiJiGoodsDto.getNumber());
            goodsRequest.setImSkuId(zhiJiGoodsDto.getSkuId());
            orderLine.add(goodsRequest);
        });
        orderInfoRequest.setOrderLine(JSON.toJSONString(orderLine));
        return orderInfoRequest;
    }
}
