package cn.com.duiba.service.impl;

import cn.com.duiba.service.KeyMetadata;
import cn.com.duiba.service.KeyProvider;
import cn.com.duiba.service.KeyRegistry;
import org.springframework.util.Assert;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class KeyRegistryImpl implements KeyRegistry {

    private Map<String, Key> cache = new ConcurrentHashMap<>();
    private volatile boolean sync = false;

    @Override
    public Key getKey(KeyMetadata metadata) {
        Assert.notNull(metadata, "[Assertion failed] - metadata is required; it must not be null");
        Key key = cache.get(metadata.getId());
        if (key == null || sync) {
            key = getKeyInternal(metadata);
            cache.put(metadata.getId(), key);
        }
        return key;
    }
    @Override
    public Certificate getCertificate(String base64) {
        Assert.hasText(base64, "[Assertion failed] - base64 must have text; it must not be null, empty, or blank");
        try(BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(base64.trim().getBytes()))){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate cert = cf.generateCertificate(is);
            return cert;
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
    private Key getKeyInternal(KeyMetadata metadata) {
        KeyProvider provider = new KeyProviderImpl(metadata.getFile(), metadata.getKeyStorePassword());
        Key key = provider.getKey(metadata.getKeyAlias(), metadata.getKeyPassword());
        Assert.notNull(key, "[Assertion failed] - key must not be null");
        return key;
    }
}
