package cn.com.duiba.biz.alipay.supplier;

import cn.com.duiba.biz.alipay.dao.AlipayBatchLogDAO;
import cn.com.duiba.biz.alipay.domain.AlipayBatchLogDO;
import cn.com.duiba.biz.alipay.domain.AlipayOfficialRequest;
import cn.com.duiba.domain.MessageUniqueCheckDO;
import cn.com.duiba.service.MessageService;
import cn.com.duiba.tool.CodeException;
import cn.com.duiba.tool.ErrorCode;
import cn.com.duiba.tool.HttpRequestLog;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/**
 * 此功能已迁移到pay-center
 * 支付宝批量付款
 */
@Deprecated
@Service
public class AlipayBatchExecutor implements InitializingBean {

	private static Logger log = LoggerFactory.getLogger(AlipayBatchExecutor.class);

	@Value("${supplier.supply.alipay.url}")
	private String requestUrl;

	@Value("${supplier.supply.alipay.batchNotifyUrl}")
	private String batchNotifyUrl;

	@Value("${supplier.supply.alipay.account}")
	private String account;

	@Value("${supplier.supply.tawalipay.batchNotifyUrl}")
	private String tawBatchNotifyUrl;

	@Value("${supplier.supply.alipay.md5Key}")
	private String md5Key;

	@Value("${supplier.supply.alipay.partner}")
	private String partner;
	private Integer batchCount = 100;
	private static final String ACCOUNT_NAME = "杭州兑吧网络科技有限公司";

	private static final String CHART_SET = "utf-8";

	@Autowired
	private AlipayBatchLogDAO alipayBatchLogDAO;
	@Autowired
	private MessageService messageService;
	@Resource
	private ScheduledExecutorService scheduler;

	@Resource(name="httpClient")
	private CloseableHttpClient httpClient;

	private LinkedBlockingQueue<AlipayOfficialRequest> queue = new LinkedBlockingQueue<>();

	/**
	 * 获取队列大小
	 * @return
	 */
	public Integer getQueueSize() {
		return queue.size();
	}

	/**
	 * 获取队列详细信息
	 * @return
	 */
	public Map<String, Object> dumpDetail() {
		Map<String, AlipayOfficialRequest> maps = new HashMap<>();
		for (AlipayOfficialRequest request : queue) {
			maps.put(request.getOrderNum(), request);
		}
		Map<String, Object> map = new HashMap<>(1);
		map.put("runningStat", maps);
		return map;
	}

	@Override
	public void afterPropertiesSet() throws Exception {
		scheduler.scheduleWithFixedDelay(new Runnable() {

			@Override
			public void run() {
				try {
					innerRun();
				} catch (Exception e) {
					log.error("AlipayBatchExecutor scheduleWithFixedDelay error", e);
				}
			}

		}, 3, 3, TimeUnit.SECONDS);
		log.info("AlipayBatchExecutor schedule started");
	}

	/**
	 * 请求支付宝接口
	 */
	public void innerRun() {
		List<AlipayOfficialRequest> list = new ArrayList<>();
		for (int i = 0; i < batchCount; i++) {
			if (!queue.isEmpty()) {
				AlipayOfficialRequest req = queue.poll();
				if (req != null) {
					list.add(req);
				}
			} else {
				break;
			}
		}

		if (!list.isEmpty()) {
			SimpleDateFormat f = new SimpleDateFormat("yyyyMMddHHmmss");

			AlipayBatchLogDO blog = new AlipayBatchLogDO(true);
			alipayBatchLogDAO.insert(blog);

			String batchNo = f.format(new Date()) + blog.getId();
			List<String> orderNums = new ArrayList<>();
			for (AlipayOfficialRequest req : list) {
				orderNums.add(req.getOrderNum());
			}
			postRequest(list, blog, batchNo, orderNums);
		}
	}

	private void postRequest(List<AlipayOfficialRequest> list, AlipayBatchLogDO blog, String batchNo, List<String> orderNums) {
		String url = generateUrl(batchNo, list);
		String body = "";
		CloseableHttpResponse response = null;
		try {
//				CloseableHttpClient client = HttpClientBuilder.create().build();
			HttpPost post = generatePostRequest(batchNo, list);
			post.setConfig(getTimeoutConfig());
			HttpRequestLog.logUrl("[action alipay] [tag request] [url "+url+"]");
			response = httpClient.execute(post);
			body = EntityUtils.toString(response.getEntity());
			HttpRequestLog.logUrl("[action alipay] [tag response] [body "+body+"]");
		} catch (Exception e) {
			log.error("scheduler httpclient error", e);
		} finally {
			try {
				AlipayBatchLogDO ablog = new AlipayBatchLogDO(blog.getId());
				ablog.setBatchNo(batchNo);
				ablog.setAllOrderNums(orderNums);
				ablog.setRequestUrl(url);
				ablog.setResponse(body);
				alipayBatchLogDAO.update(ablog);
			} catch (Exception e) {
				log.error("scheduler update log error", e);
			}
			if(response != null){
				try{
					response.close();
				}catch (Exception e){
					log.error("close CloseableHttpResponse error", e);
				}
			}
		}
	}

	private RequestConfig getTimeoutConfig() {
		return RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
	}

	/**
	 * 添加到支付宝队列
	 * @param req
	 */
	public void addAlipayOrder(AlipayOfficialRequest req) {
		if (!messageService.messageUniqueCheck(req.getOrderNum(), MessageUniqueCheckDO.TYPE_ALIPAY)) {
			return;
		}
		queue.add(req);
		HttpRequestLog.logUrl("[action alipay] [tag request] [bizId " + req.getOrderNum() + "]");
	}

	/**
	 * 申请批量请求url
	 *
	 * @param batchNo
	 *            批次号 必填，格式：当天日期[8位]+序列号[3至16位]，如：201008010000001
	 * @param list
	 */
	private HttpPost generatePostRequest(String batchNo, List<AlipayOfficialRequest> list) {
		Date now = new Date();
		SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
		// 必填，个人支付宝账号是真实姓名公司支付宝账号是公司名称

		// 付款当天日期
		String payDate = format.format(now);
		// 必填，格式：年[4位]月[2位]日[2位]，如：20100801

		// 必填，即参数detail_data的值中，“|”字符出现的数量加1，最大支持1000笔（即“|”字符出现的数量999个）

		// 付款详细数据
		StringBuilder detailDataStr = new StringBuilder("");
		// 必填，格式：流水号1^收款方帐号1^真实姓名^付款金额1^备注说明1|流水号2^收款方帐号2^真实姓名^付款金额2^备注说明2....

		Integer fee = 0;

		for (AlipayOfficialRequest req : list) {
			String no = req.getOrderNum();
			String alipay = req.getAlipay();
			String realname = req.getRealname();
			String price = req.getQuantity() + "";
			fee += req.getQuantity();
			String memo = req.getMemo();
			detailDataStr.append(no).append("^").append(alipay).append("^").append(realname).append("^").append(price).append("^").append(memo).append("|");
		}
		String detailData = detailDataStr.toString();
		if (detailData.endsWith("|")) {
			detailData = detailData.substring(0, detailData.length() - 1);
		}

		// 付款总金额
		String batchFee = fee.toString();
		// 必填，即参数detail_data的值中所有金额的总和

		// 付款笔数
		String batchNum = Integer.toString(list.size());

		// ////////////////////////////////////////////////////////////////////////////////

		// 把请求参数打包成数组
		Map<String, String> sParaTemp = new HashMap<>();
		sParaTemp.put("service", "batch_trans_notify_no_pwd");
		sParaTemp.put("partner", partner);
		sParaTemp.put("_input_charset", CHART_SET);
		sParaTemp.put("notify_url", tawBatchNotifyUrl);
		sParaTemp.put("email", account);
		sParaTemp.put("account_name", ACCOUNT_NAME);
		sParaTemp.put("pay_date", payDate);
		sParaTemp.put("batch_no", batchNo);
		sParaTemp.put("batch_fee", batchFee);
		sParaTemp.put("batch_num", batchNum);
		sParaTemp.put("detail_data", detailData);

		List<String> keys = new ArrayList<>(sParaTemp.keySet());
		Collections.sort(keys);
		StringBuilder stringBf = new StringBuilder("");
		for (String s : keys) {
			if (stringBf.toString().length() == 0) {
				stringBf.append(s).append("=").append(sParaTemp.get(s));
			} else {
				stringBf.append("&").append(s).append("=").append(sParaTemp.get(s));
			}
		}

		stringBf.append(md5Key);
		String string = stringBf.toString();

		String sign = "";
		try {
			sign = toHexValue(encryptMD5(string.getBytes(Charset.forName(CHART_SET))));
		} catch (Exception e) {
			log.error("toHexValue", e);
		}

		sParaTemp.put("sign", sign);
		sParaTemp.put("sign_type", "MD5");

		List<NameValuePair> pairs = new ArrayList<>(sParaTemp.size());
		for (Map.Entry<String, String> entry : sParaTemp.entrySet()) {
			String value = entry.getValue();
			if (value != null) {
				pairs.add(new BasicNameValuePair(entry.getKey(), value));
			}
		}

		String url = requestUrl;
		if (!url.endsWith("?")) {
			url += "?";
		}

		HttpPost post = new HttpPost(url + "_input_charset=utf-8");
		post.setEntity(new UrlEncodedFormEntity(pairs, Charset.forName(CHART_SET)));
		post.addHeader("Content-Type", "application/x-www-form-urlencoded; text/html; charset=utf-8");
		return post;
	}

	/**
	 * 申请批量请求url
	 *
	 * @param batchNo
	 *            批次号 必填，格式：当天日期[8位]+序列号[3至16位]，如：201008010000001
	 * @param list
	 */
	private String generateUrl(String batchNo, List<AlipayOfficialRequest> list) {
		Date now = new Date();
		SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
		// 必填，个人支付宝账号是真实姓名公司支付宝账号是公司名称

		// 付款当天日期
		String payDate = format.format(now);
		// 必填，格式：年[4位]月[2位]日[2位]，如：20100801

		// 必填，即参数detail_data的值中，“|”字符出现的数量加1，最大支持1000笔（即“|”字符出现的数量999个）

		// 付款详细数据
		StringBuilder detailBf = new StringBuilder("");
		// 必填，格式：流水号1^收款方帐号1^真实姓名^付款金额1^备注说明1|流水号2^收款方帐号2^真实姓名^付款金额2^备注说明2....

		Integer fee = 0;

		for (AlipayOfficialRequest req : list) {
			String no = req.getOrderNum();
			String alipay = req.getAlipay();
			String realname = req.getRealname();
			String price = req.getQuantity() + "";
			fee += req.getQuantity();
			String memo = req.getMemo();
			detailBf.append(no).append("^").append(alipay).append("^").append(realname).append("^").append(price).append("^").append(memo).append("|");
		}

		String detailData = detailBf.toString();
		if (detailData.endsWith("|")) {
			detailData = detailData.substring(0, detailData.length() - 1);
		}

		// 付款总金额
		String batchFee = fee.toString();
		// 必填，即参数detail_data的值中所有金额的总和

		// 付款笔数
		String batchNum = Integer.toString(list.size());

		// ////////////////////////////////////////////////////////////////////////////////

		// 把请求参数打包成数组
		Map<String, String> sParaTemp = new HashMap<>();
		sParaTemp.put("service", "batch_trans_notify_no_pwd");
		sParaTemp.put("partner", partner);
		sParaTemp.put("_input_charset", CHART_SET);
		sParaTemp.put("notify_url", batchNotifyUrl);
		sParaTemp.put("email", account);
		sParaTemp.put("account_name", ACCOUNT_NAME);
		sParaTemp.put("pay_date", payDate);
		sParaTemp.put("batch_no", batchNo);
		sParaTemp.put("batch_fee", batchFee);
		sParaTemp.put("batch_num", batchNum);
		sParaTemp.put("detail_data", detailData);

		List<String> keys = new ArrayList<>(sParaTemp.keySet());
		Collections.sort(keys);
		StringBuilder string = new StringBuilder();
		for (String s : keys) {
			if (string.length() == 0) {
				string.append(s).append("=").append(sParaTemp.get(s));
			} else {
				string.append("&").append(s).append("=").append(sParaTemp.get(s));
			}
		}
		string.append(md5Key);

		String sign = "";
		try {
			sign = toHexValue(encryptMD5(string.toString().getBytes(Charset.forName(CHART_SET))));
		} catch (Exception e) {
			log.error("encryptMD5", e);
		}

		sParaTemp.put("sign", sign);
		sParaTemp.put("sign_type", "MD5");

		return assembleUrl(requestUrl, sParaTemp);

	}

	private static String assembleUrl(String url, Map<String, String> params) {
		StringBuilder str = new StringBuilder(url);
		str.append("?");
		for (Map.Entry<String, String> entry : params.entrySet()) {
			try {
				if (entry.getValue() == null || entry.getValue().length() == 0) {
					str.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
				} else {
					str.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), "utf-8")).append("&");
				}
			} catch (UnsupportedEncodingException e) {
				log.error("assembleUrl", e);
			}
		}
		return str.toString();
	}

	private static String toHexValue(byte[] messageDigest) {
		if (messageDigest == null)
			return "";
		StringBuilder hexValue = new StringBuilder();
		for (byte aMessageDigest : messageDigest) {
			int val = 0xFF & aMessageDigest;
			if (val < 16) {
				hexValue.append("0");
			}
			hexValue.append(Integer.toHexString(val));
		}
		return hexValue.toString();
	}

	private static byte[] encryptMD5(byte[] data) throws CodeException {
		try {
			MessageDigest md5 = MessageDigest.getInstance("MD5");
			md5.update(data);
			return md5.digest();
		} catch (NoSuchAlgorithmException e) {
			log.error("encryptMD5", e);
			throw new CodeException(ErrorCode.E9999999);
		}
	}

	public void setMd5Key(String md5Key) {
		this.md5Key = md5Key;
	}

	public void setAccount(String account) {
		this.account = account;
	}

	public void setBatchNotifyUrl(String batchNotifyUrl) {
		this.batchNotifyUrl = batchNotifyUrl;
	}

	public void setRequestUrl(String requestUrl) {
		this.requestUrl = requestUrl;
	}

	public void setPartner(String partner) {
		this.partner = partner;
	}

	public void setBatchCount(Integer batchCount) {
		this.batchCount = batchCount;
	}

}
