package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.credits.sdk.CreditNotifyParams;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.tool.AssembleTool;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
public class BaiduApi {

    private static Logger logger = LoggerFactory.getLogger(BaiduApi.class);

    private String baiduAppSecret = "4Vs1LSp1Xo4KHE6dm3BkFojNFW7N";


    /**
     * 构造百度扣积分请求.
     *
     * @param request
     * @return
     */
    public CreditsMessage getSubCreditsMessage(CreditsMessage request) {
        String url = request.getHttpUrl();
        String host = url.substring(0, url.indexOf('?'));
        String params = url.substring(url.indexOf('?') + 1);
        // 1.将请求URL的参数转换为MAP
        Map<String, String> paramMap = AssembleTool.getUrlParams(params);
        //remove transfer add access_token
        String accessToken = paramMap.get("transfer");
        paramMap.remove("transfer");
        paramMap.remove("sign");
        paramMap.put("access_token", accessToken);
        paramMap.put("appSecret", baiduAppSecret);
        // 签名包含access_token
        String sign = SignTool.sign(paramMap);
        paramMap.remove("appSecret");
        paramMap.put("sign", sign);
        // 4.生成URL
        String requestUrl = AssembleTool.assembleUrl(host, paramMap);
        request.setHttpUrl(requestUrl);
        request.setHttpType(CreditsMessage.HTTP_GET);
        request.setAuthParams(new HashMap<>());
        return request;
    }

    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        String url = subCreditsMsgWrapper.getHttpUrl();
        String host = url.substring(0, url.indexOf('?'));
        String params = url.substring(url.indexOf('?') + 1);
        // 1.将请求URL的参数转换为MAP
        Map<String, String> paramMap = AssembleTool.getUrlParams(params);
        //remove transfer add access_token
        String accessToken = paramMap.get("transfer");
        paramMap.remove("transfer");
        paramMap.remove("sign");
        paramMap.put("access_token", accessToken);
        paramMap.put("appSecret", baiduAppSecret);
        // 签名包含access_token
        String sign = SignTool.sign(paramMap);
        paramMap.remove("appSecret");
        paramMap.put("sign", sign);
        // 4.生成URL
        String requestUrl = AssembleTool.assembleUrl(host, paramMap);
        subCreditsMsgWrapper.setHttpUrl(requestUrl);
        subCreditsMsgWrapper.getSubCreditsMsg().setHttpType(SubCreditsMsgDto.HTTP_GET);
        return subCreditsMsgWrapper;
    }

    /**
     * @param url
     * @param record
     * @param p
     * @return
     */
    public HttpRequestBase getRequestNotify(String url, NotifyQueueDO record, CreditNotifyParams p) {
        String transfer = record.getTransfer();
        HashMap map = new HashMap();
        map.put("success", Boolean.toString(p.isSuccess()));
        map.put("errorMessage", getString(p.getErrorMessage()));
        map.put("bizId", getString(p.getBizId()));
        map.put("appKey", getString(p.getAppKey()));
        map.put("appSecret", baiduAppSecret);
        map.put("timestamp", getString(Long.valueOf(p.getTimestamp().getTime())));
        map.put("uid", getString(record.getPartnerUserId()));
        map.put("orderNum", getString(p.getOrderNum()));
        //transfer参数用于放置access_token
        map.put("access_token", getString(transfer));
        // 签名包含access_token
        String sign = SignTool.sign(map);
        map.remove("appSecret");
        map.put("sign", sign);

        HttpRequestBase request;
        request = new HttpGet(AssembleTool.assembleUrl(url, map));
        request.setConfig(getDefaultConfig());
        return request;
    }

    private String getString(Object o) {
        return o == null ? "" : o.toString();
    }

    /**
     * 通知超时时间
     *
     * @return
     */
    private RequestConfig getDefaultConfig() {
        return RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
    }

    /**
     * 构造 虚拟商品充值 请求参数
     * @param request
     * @return
     */
    public SupplierRequest getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String host = url.substring(0, url.indexOf('?'));
        String params = url.substring(url.indexOf('?') + 1);
        // 1.将请求URL的参数转换为MAP
        Map<String, String> paramMap = AssembleTool.getUrlParams(params);
        //remove transfer add access_token
        String accessToken = paramMap.get("transfer");
        paramMap.remove("transfer");
        paramMap.remove("sign");
        paramMap.put("access_token", accessToken);
        paramMap.put("appSecret", baiduAppSecret);
        // 签名包含access_token
        String sign = SignTool.sign(paramMap);
        paramMap.remove("appSecret");
        paramMap.put("sign", sign);
        // 4.生成URL
        String requestUrl = AssembleTool.assembleUrl(host, paramMap);
        request.setHttpUrl(requestUrl);
        return request;
    }

}
