package cn.com.duiba.biz.credits;

import cn.com.duiba.domain.SupplierRequest;

/**
 * @Description: 南京中信银行接口定制
 * @Author: fxr
 * @Date: 2019/4/3
 */
public interface CiticApi {

    /**
     * 是否南京中信银行APP
     *
     * @param appId
     * @return
     */
    Boolean isCiticApp(Long appId);

    /**
     * 南京中信银行-未对接兑吧虚拟商品接口，要求兑吧方使用他们的加积分接口，作为虚拟商品，在活动中发放
     *
     * @param request
     * @return
     */
    SupplierRequest getVirturalRequest(SupplierRequest request);

    /**
     * 南京中信银行-解析虚拟商品接口开发者请求响应
     *
     * @param message
     * @param body
     * @return
     */
    String getVirturalResponse(SupplierRequest message, String body);
}
