package cn.com.duiba.biz.credits;

import cn.com.duiba.domain.HttpMessageDO;
import cn.com.duiba.domain.RequestTypeEnum;
import cn.com.duiba.order.center.api.dto.CreditsCallbackMessage;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.CaiNiaoTool;
import cn.com.duiba.tool.HttpRequestLog;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @author JunAngLiu
 * @Title: CustomQueryCreditsToDeveloper
 * @Description:
 * @date 2019/10/2317:05
 */
@Service
public class CustomQueryCreditsToDeveloper {

    private static final Logger LOG = LoggerFactory.getLogger(CustomQueryCreditsToDeveloper.class);

    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;
    @Autowired
    private ErweihuoApi erweihuoApi;
    @Autowired
    private AddCreditsToDeveloper addCreditsToDeveloper;


    /**
     * 二维火定制 加积分后 回调上游接口（先查询积分，再回调）
     * @param httpMessage
     * @param req
     * @param resp
     */
    public void dealCredits(HttpMessageDO httpMessage, CreditsMessageDto req, CreditsCallbackMessage resp){

        CreditsMessageDto creditsMessageDto = erweihuoApi.getQueryCreditsMessage(req);

        HttpRequestBase http;
        if (CreditsMessage.HTTP_POST.equals(creditsMessageDto.getHttpType())) {
            Map<String, String> authParams = creditsMessageDto.getAuthParams();
            if (MapUtils.isNotEmpty(authParams)) {
                // 移除appSecret
                authParams.remove("appSecret");
            }
            http = AssembleTool.assembleRequest(creditsMessageDto.getHttpUrl(), authParams);
        } else {
            http = new HttpGet(creditsMessageDto.getHttpUrl());
        }

        HttpRequestLog.logUrl("[action queryCredits][request bizId " + creditsMessageDto.getRelationId() + "] [type " + creditsMessageDto.getRelationType() + "] [url " + creditsMessageDto.getHttpUrl()+ "][authParams "+creditsMessageDto.getAuthParams() + "][consumerId "+creditsMessageDto.getConsumerId()+"]");


        httpAsyncClientPool.submit(creditsMessageDto.getAppId(), http, new FutureCallback<HttpResponse>() {

            @Override
            public void completed(HttpResponse response) {
                try {
                    Header header = response.getEntity().getContentEncoding();
                    String result;
                    if (header != null && header.toString().contains(CaiNiaoTool.CONTENT_ENCODING_GZIP)) {
                        result = EntityUtils.toString(new GzipDecompressingEntity(response.getEntity()));
                    } else {
                        result = EntityUtils.toString(response.getEntity());
                    }
                    HttpRequestLog.logUrl("[action queryCredits] [response type completed] [body " + result + "]");
                    Object credits = erweihuoApi.parseQueryCrditsRsp(result);
                    if(credits == null){
                        LOG.info("查询二维火积分为空");
                        return;
                    }
                    String message = resp.getMessage();
                    if(StringUtils.isBlank(message)){
                        LOG.info("二维火加积分解析的返回message为空");
                        return;
                    }
                    JSONObject jsonObject = JSONObject.parseObject(message);
                    jsonObject.put("credits",String.valueOf(credits));
                    //填充积分值
                    resp.setMessage(jsonObject.toJSONString());
                    addCreditsToDeveloper.sendBlockMq(httpMessage,req,resp);
                } catch (Exception e) {
                    LOG.info("toDeveloper completed", e);
                }
            }

            @Override
            public void failed(Exception ex) {
                LOG.info("toDeveloper cancelled bizId:" + creditsMessageDto.getRelationId() + " bizType:" + creditsMessageDto.getRelationType());
            }

            @Override
            public void cancelled() {
                LOG.info("toDeveloper cancelled bizId:" + creditsMessageDto.getRelationId() + " bizType:" + creditsMessageDto.getRelationType());
            }
        }, RequestTypeEnum.ADD_CREDITS);

    };
}
