package cn.com.duiba.biz.credits;

import cn.com.duiba.constant.GuMingConstant;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.GuMingSignTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponentsBuilder;

import javax.annotation.Resource;
import java.util.Map;
import java.util.Objects;

/**
 * Created by fangdong on 2020/09/22
 */
@Service
public class GuMingApi {
    private static final Logger log = LoggerFactory.getLogger(GuMingApi.class);

    @Resource
    private GuMingConstant guMingConstant;

    /**
     * 是否是该应用
     */
    public boolean isGuMing(Long appId) {
        return Objects.equals(guMingConstant.getAppId(), appId);
    }

    /**
     * 虚拟商品请求
     */
    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf('?'));
        String paramsStr = url.substring(url.indexOf('?') + 1);
        Map<String, String> authParams = AssembleTool.getUrlParams(paramsStr);

        Map<String, String> newAuthParams = Maps.newHashMap();
        newAuthParams.put("channel", "2");
        newAuthParams.put("note", authParams.get("description"));
        newAuthParams.put("template_id", authParams.get("params"));
        newAuthParams.put("uid", authParams.get("uid"));
        newAuthParams.put("out_trade_no", authParams.get("orderNum"));
        newAuthParams.put("mid", guMingConstant.getMid());

        request.setHttpUrl(newUrl);
        request.setAuthParams(newAuthParams);

        Map<String, Object> bodyRequest = Maps.newHashMap(newAuthParams);
        bodyRequest.put("channel", 2);

        Map<String, Object> body = Maps.newHashMap();
        body.put("method", "coupon_send");
        body.put("coupon_send_request", bodyRequest);

        return this.getHttpPost(newUrl, JSON.toJSONString(body));
    }

    /**
     * 解析虚拟商品充值响应结果
     */
    public String getVirtualResponse(SupplierRequest message, String body) {
        log.info("古茗虚拟商品充值响应结果response, body={}", body);

        JSONObject jsonBody = JSON.parseObject(body);

        JSONObject result = new JSONObject();
        if (!Objects.equals(0, jsonBody.getInteger("status"))) {
            result.put("status", "fail");
            result.put("errorMessage", jsonBody.getString("msg"));

            return result.toString();
        }

        result.put("status", "success");
        return result.toString();
    }

    private HttpRequestBase getHttpPost(String httpUrl, String jsonBody) {
        String urlPath = UriComponentsBuilder.fromHttpUrl(httpUrl).build().getPath();

        HttpPost request = new HttpPost(httpUrl);
        request.setEntity(new StringEntity(jsonBody, ContentType.APPLICATION_JSON));

        Map<String, String> headers = GuMingSignTool.getSignHeaders(
                urlPath, jsonBody, guMingConstant.getDeveloperAppKey(), guMingConstant.getDeveloperAppSecret());
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            request.setHeader(entry.getKey(), entry.getValue());
        }

        return request;
    }
}
