package cn.com.duiba.biz.credits;

import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.dto.sn.CreditsExchangeParam;
import cn.com.duiba.dto.sn.SignAddCreditsParam;
import cn.com.duiba.dto.sn.SnbRequestParam;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.*;
import cn.com.duiba.tool.sn.GenerateSequenceUtil;
import cn.com.duiba.tool.sn.InitData;
import cn.com.duiba.tool.sn.SnbUtil;
import cn.com.duiba.tool.sn.TimeUtil;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class SnsApi {

    private static final Logger log = LoggerFactory.getLogger(SnsApi.class);
    private static final String SUCCESS_CODE = "00000000";
    private static final String merchantID = "DBWL0001";

    private static final List<Long> snsAppIds = Arrays.asList(66453L,66420L);


    /**
     * rpc加积分
     */
    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request){

        String url = request.getHttpUrl();
        String host = url.substring(0, url.indexOf('?'));
        request.setHttpUrl(host);

        String paramsStr = url.substring(url.indexOf('?') + 1);
        Map<String, String> paramsMap = AssembleTool.getUrlParams(paramsStr);
        String uid = paramsMap.get("uid");
        String timestamp = paramsMap.get("timestamp");
        String transfer = paramsMap.get("transfer");

        String tranDate = "";
        String tranTime = "";
        if(StringUtils.isNotEmpty(timestamp) && NumberUtils.isNumber(timestamp) && (timestamp.length()==10 || timestamp.length()==13)){
            String date = TimeUtil.timestampToDateStr(Long.parseLong(timestamp));
            tranDate = date.substring(0,8).trim();
            tranTime = date.substring(8,date.length()).trim();
        }

        SnbRequestParam snbRequestDto = new SnbRequestParam();
        snbRequestDto.setChannelSerialNo(GenerateSequenceUtil.generateSequenceNo());// 唯一交易流水号
        snbRequestDto.setTransCode("snb.duiba.market.active.sign");// 交易码

        // 具体业务数据（payload）。根据不同的接口,调用包com.snb.fsos.bean下面的具体bean。
        // 如果包下面没有符合实际使用的Bean,需要自定义bean，该bean继承PayLoadBean即可。
        SignAddCreditsParam signAddCreditsDto = new SignAddCreditsParam();
        signAddCreditsDto.setMerchantId(merchantID);
        signAddCreditsDto.setEncryCustId(uid);
        signAddCreditsDto.setTranDate(tranDate);
        signAddCreditsDto.setTranTime(tranTime);
        signAddCreditsDto.setTransfer(transfer);
        // 具体业务数据
        snbRequestDto.setPayLoad(signAddCreditsDto);

        Map<String,String> authParam;
        try {
            authParam = SnbUtil.send(snbRequestDto);
        }catch (Exception e){
            authParam = new HashMap<>();
            authParam.put("transCode",snbRequestDto.getTransCode());
            log.error("苏宁银行加积分请求参数组装失败, snbRequestDto={}", JsonTool.objectToJson(snbRequestDto), e);
        }

        request.setAuthParams(authParam);
        request.setHttpType(CreditsMessage.HTTP_POST);
        return request;
    }

    /**
     * 解析积分响应
     * @param body 积分响应
     * @return 积分响应
     */
    public String parseCreditsRsp(String body) {
        Map respMap = new HashMap();
        try {
            // 将返回的JSON格式的数据转化成Map格式
            respMap = InitData.OBJECTMAPPER.readValue(body, Map.class);
            respMap = SnbUtil.extendMap(respMap);
        } catch (Exception e) {
            log.error("苏宁银行json反序列化失败, body={}", body, e);
            return body;
        }
        log.info("苏宁银行加积分responseMap, body={}", respMap);
        JSONObject json = new JSONObject();
        if (SUCCESS_CODE.equals(respMap.get("respCode"))) {
            json.put("status", "ok");
            json.put("bizId", respMap.get("serialNo"));
            json.put("credits", respMap.get("availIntegral"));
            // 苏宁金融增加积分
            json.put("addCredits", respMap.get("jFsignIntegral"));
        } else {
            json.put("errorMessage", respMap.get("respMsg"));
            json.put("status", "fail");
        }

        return json.toString();
    }

    public SupplierRequest getVirtualRequest(SupplierRequest request) {
        log.info("苏宁银行兑换积分请求参数, request={}", JsonTool.objectToJson(request));

        String url = request.getHttpUrl();
        //  解析URL
        List<String> analysisList = AssembleTool.analysisUrl(url);
        if (analysisList.isEmpty()) {
            return request;
        }
        //  网关地址
        String host = analysisList.get(0);
        //  请求参数
        Map<String, String> paramsMap = AssembleTool.getUrlParams(analysisList.get(1));
        String uid = paramsMap.get("uid");
        String timestamp = paramsMap.get("timestamp");
        String transfer = paramsMap.get("transfer");
        String orderNum = paramsMap.get("orderNum");
        String params = "";

        Map<String, String> map = request.getParams();
        if(MapUtils.isNotEmpty(map)){
            params = map.get("params");
        }

        if(StringUtils.isEmpty(params)){
            params = paramsMap.get("params");
        }

        String tranDate = "";
        String tranTime = "";
        if(StringUtils.isNotEmpty(timestamp) && NumberUtils.isNumber(timestamp) && (timestamp.length()==10 || timestamp.length()==13)){
            String date = TimeUtil.timestampToDateStr(Long.parseLong(timestamp));
            tranDate = date.substring(0,8).trim();
            tranTime = date.substring(8,date.length()).trim();
        }

        SnbRequestParam snbRequestDto = new SnbRequestParam();
        snbRequestDto.setChannelSerialNo(GenerateSequenceUtil.generateSequenceNo());// 唯一交易流水号
        snbRequestDto.setTransCode("snb.duiba.market.active.exchange");// 交易码

        // 具体业务数据（payload）。根据不同的接口,调用包com.snb.fsos.bean下面的具体bean。
        // 如果包下面没有符合实际使用的Bean,需要自定义bean，该bean继承PayLoadBean即可。
        CreditsExchangeParam creditsExchangeDto = new CreditsExchangeParam();
        creditsExchangeDto.setMerchantId(merchantID);
        creditsExchangeDto.setEncryCustId(uid);
        creditsExchangeDto.setTranDate(tranDate);
        creditsExchangeDto.setTranTime(tranTime);
        creditsExchangeDto.setTransfer(transfer);
        creditsExchangeDto.setActivityNo(params);
        creditsExchangeDto.setBusinessNo(orderNum);
        // 具体业务数据
        snbRequestDto.setPayLoad(creditsExchangeDto);

        Map<String,String> authParam;
        try {
            authParam = SnbUtil.send(snbRequestDto);
        }catch (Exception e){
            authParam = new HashMap<>();
            authParam.put("transCode",snbRequestDto.getTransCode());
            log.error("苏宁银行积分兑换请求参数组装失败, snbRequestDto={}", JsonTool.objectToJson(snbRequestDto), e);
        }

        request.setAuthParams(authParam);
        request.setHttpUrl(host);
        return request;
    }


    public String getVirtualResponse(String body) {

        log.info("苏宁银行兑换积分response, body={}", body);
        Map respMap = new HashMap();
        try {
            // 将返回的JSON格式的数据转化成Map格式
            respMap = InitData.OBJECTMAPPER.readValue(body, Map.class);
            SnbUtil.extendMap(respMap);
        } catch (Exception e) {
            log.error("苏宁银行json反序列化失败, body={}", body, e);
            return body;
        }

        JSONObject json = new JSONObject();
        if (SUCCESS_CODE.equals(respMap.get("respCode"))) {
            json.put("status", "success");
            json.put("supplierBizId", respMap.get("serialNo"));
        } else {
            json.put("errorMessage", respMap.get("respMsg"));
            json.put("status", "fail");
        }

        return json.toString();
    }


    public static boolean isEmpty(String str){
        return str == null || str.isEmpty();
    }

    public void setHttpHeader(Map<String, String> authParams,HttpRequestBase http){
        http.setHeader("Content-Type", "application/x-www-form-urlencoded");
        http.setHeader("charset", InitData.CHARSET_UTF8);
        http.setHeader("appCode", authParams.get("appCode"));
        http.setHeader("version", "1.0");
    }

    public boolean isSns(Long appId){
        return appId != null && snsAppIds.contains(appId);
    }

}
