package cn.com.duiba.biz.credits;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.constant.WuFangZhaiConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.dto.wufangzhai.WfzBaseResp;
import cn.com.duiba.dto.wufangzhai.WfzReq;
import cn.com.duiba.dto.wufangzhai.WfzTokenBean;
import cn.com.duiba.dto.wufangzhai.req.AwardIntegralReq;
import cn.com.duiba.dto.wufangzhai.req.CardQueryInfoReq;
import cn.com.duiba.dto.wufangzhai.req.ReduceIntegralReq;
import cn.com.duiba.dto.wufangzhai.req.SendCouponReq;
import cn.com.duiba.dto.wufangzhai.resp.AwardIntegralResp;
import cn.com.duiba.dto.wufangzhai.resp.CardQueryInfoResp;
import cn.com.duiba.dto.wufangzhai.resp.ReduceIntegralResp;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpUtils;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.redis.RedisAtomicClient;
import cn.com.duiba.wolf.redis.RedisLock;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/**
 * 五芳斋定制
 *
 * @author haojiahong
 * @date 2020-06-23
 */
@Service
public class WuFangZhaiApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(WuFangZhaiApi.class);

    private static final String VIRTUAL_CREDITS_PRE = "JF-";
    private static final String VIRTUAL_RECHARGE_PRE = "ZQ-";
    private static final String HTTP_HEADER_CONTENT_TYPE = "Content-Type";
    private static final String FORM_TYPE = "application/x-www-form-urlencoded";
    private static final String CACHE_TOKEN_KEY_FORMAT = "wuFangZhaiToken_%s_%s";
    private static final String LOCK_TOKEN_KEY_FORMAT = "wuFangZhaiLock_%s_%s";

    @Autowired
    private WuFangZhaiConfig wuFangZhaiConfig;
    @Resource(name = "httpClient")
    // HTTP超时已经修复
    private CloseableHttpClient httpClient;
    @Resource(name = "redisTemplate")
    private RedisAtomicClient redisAtomicClient;
    @Resource(name = "redisTemplate")
    private AdvancedCacheClient advancedCacheClient;


    public Boolean isWuFangZhai(Long appId) {
        Set<Long> appIds = wuFangZhaiConfig.getAppIds();
        if (null == appIds) {
            return false;
        }
        return appIds.contains(appId);
    }

    /**
     * 减积分请求封装
     *
     * @param message
     * @return
     */
    public HttpRequestBase getSubCreditsMessage(CreditsMessage message) {
        String url = message.getHttpUrl();
        String paramsStr = url.substring(url.indexOf('?') + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        return getSubCreditsRequest(params,message.getAppId());
    }

    public HttpRequestBase getSubCreditsMessage(SubCreditsMsgWrapper message) {
        String url = message.getHttpUrl();
        String paramsStr = url.substring(url.indexOf('?') + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        return getSubCreditsRequest(params,message.getSubCreditsMsg().getAppId().toString());
    }

    /**
     * 加积分请求封装
     *
     * @param message
     * @return
     */
    public HttpRequestBase getAddCreditsMessage(CreditsMessageDto message) {
        // 截取请求url
        String httpUrl = message.getHttpUrl();
        // 截取url请求参数，构造新的请求参数
        String paramStr = httpUrl.substring(httpUrl.indexOf('?') + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramStr);
        return getAddCreditsRequest(params,message.getAppId());
    }

    /**
     * 充值商品定制请求封装
     *
     * @param request
     * @return
     */
    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String paramsStr = url.substring(url.indexOf('?') + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        params.put("consumerId", request.getConsumerId());
        String goodsNum = params.get("params");
        request.setAuthParams(params);
        if (goodsNum.startsWith(VIRTUAL_CREDITS_PRE)) {
            params.put("credits", goodsNum.replace(VIRTUAL_CREDITS_PRE, ""));
            return getAddCreditsRequest(params,request.getAppId());
        }
        if (goodsNum.startsWith(VIRTUAL_RECHARGE_PRE)) {
            params.put("batchNo", goodsNum.replace(VIRTUAL_RECHARGE_PRE, ""));
            return getRechargeRequest(params,request.getAppId());
        }
        return AssembleTool.assembleRequest(request.getHttpUrl(), request.getAuthParams());
    }

    private HttpRequestBase getRechargeRequest(Map<String, String> params,String appId) {
        WfzTokenBean wfzTokenBean = this.getToken(appId);
        String mobile = this.getMobile(params.get("uid"),appId);
        String openId = params.get("transfer");
        HttpPost httpPost = new HttpPost(WuFangZhaiConfig.Api.COUPON_SEND_COUPON.getApiAbsolutePath(wuFangZhaiConfig));
        SendCouponReq sendCouponReq = new SendCouponReq();
        sendCouponReq.setBrandId(wfzTokenBean.getBrandId());
        sendCouponReq.setMobile(mobile);
        sendCouponReq.setBatchNo(Integer.valueOf(params.get("batchNo")));
        sendCouponReq.setOpenId(openId);
        WfzReq req = new WfzReq();
        req.setAccessToken(wfzTokenBean.getAccessToken());
        req.setCiphertext(JSON.toJSONString(sendCouponReq));
        StringEntity stringEntity = new StringEntity(JSON.toJSONString(req), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity(stringEntity);
        return httpPost;
    }

    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams, Long appId) {
        Map<String, String> map = new HashMap<>();
        if (StringUtils.isBlank(body)) {
            map.put("status", "fail");
            map.put("errorMessage", "五芳斋新增/扣减积分接口返回为空");
            return JSON.toJSONString(map);
        }
        try {
            if (addCredits) {
                parseAwardIntegralResp(body, map);
            } else {
                parseReduceIntegralResp(body, map);
            }
            map.put("credits", getCredits(authParams.get("uid"),appId.toString()));
        } catch (Exception e) {
            LOGGER.error("五芳斋新增/扣减积分接口解析错误:{}--是否新增:{}", body, addCredits, e);
            map.put("status", "fail");
            map.put("errorMessage", "五芳斋新增/扣减积分解析结果错误");
        }
        return JSONObject.toJSONString(map);
    }

    public void parseAwardIntegralResp(String body, Map<String, String> map) {
        WfzBaseResp<AwardIntegralResp> wfzResp = JSON.parseObject(body, new TypeReference<WfzBaseResp<AwardIntegralResp>>(AwardIntegralResp.class) {
        });
        if (Objects.equals(wfzResp.getCode(), 0)) {
            map.put("status", "ok");
            map.put("bizId", wfzResp.getData().getVoucher().toString());
        } else {
            map.put("status", "fail");
            String errorMsg = wfzResp.getMessage();
            if (StringUtils.length(errorMsg) > 255) {
                errorMsg = errorMsg.substring(0, 255);
            }
            map.put("errorMessage", errorMsg);
        }
    }

    public void parseReduceIntegralResp(String body, Map<String, String> map) {
        WfzBaseResp<ReduceIntegralResp> wfzResp = JSON.parseObject(body, new TypeReference<WfzBaseResp<ReduceIntegralResp>>(ReduceIntegralResp.class) {
        });
        if (Objects.equals(wfzResp.getCode(), 0)) {
            map.put("status", "ok");
            map.put("bizId", wfzResp.getData().getVoucher().toString());
        } else {
            map.put("status", "fail");
            String errorMsg = wfzResp.getMessage();
            if (StringUtils.length(errorMsg) > 255) {
                errorMsg = errorMsg.substring(0, 255);
            }
            map.put("errorMessage", errorMsg);
        }
    }

    public String getVirtualResponse(SupplierRequest request, String body) {
        Map<String, String> params = request.getAuthParams();
        String goodsNum = params.get("params");
        String uid = params.get("uid");
        if (goodsNum.startsWith(VIRTUAL_CREDITS_PRE)) {
            return getVirtualCreditsResponse(body, uid,request.getAppId());
        }
        if (goodsNum.startsWith(VIRTUAL_RECHARGE_PRE)) {
            return getVirtualRechargeResponse(body, uid,request.getAppId());
        }
        return body;
    }

    private String getVirtualRechargeResponse(String body, String uid, String appId) {
        Map<String, String> duibaDoc = new HashMap<>();
        if (StringUtils.isBlank(body)) {
            throw new ThirdpatyException("五芳斋，充值商品定制，返回结果为空");
        }
        try {
            WfzBaseResp wfzResp = JSON.parseObject(body, WfzBaseResp.class);
            if (Objects.equals(wfzResp.getCode(), 0)) {
                duibaDoc.put("status", "success");
                //开发者注券接口不产生订单
                duibaDoc.put("supplierBizId", "");
            } else {
                duibaDoc.put("status", "fail");
                String errorMsg = wfzResp.getMessage();
                if (StringUtils.length(errorMsg) > 255) {
                    errorMsg = errorMsg.substring(0, 255);
                }
                duibaDoc.put("errorMessage", errorMsg);
            }
            duibaDoc.put("credits", getCredits(uid,appId));
        } catch (Exception e) {
            LOGGER.error("五芳斋，充值商品定制，结果解析错误:{}", body, e);
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", "注券接口响应解析错误");
        }
        return JSON.toJSONString(duibaDoc);
    }

    private String getVirtualCreditsResponse(String body, String uid,String appId) {
        Map<String, String> duibaDoc = new HashMap<>();
        if (StringUtils.isBlank(body)) {
            throw new ThirdpatyException("五芳斋，充值商品定制，返回结果为空");
        }
        try {
            WfzBaseResp<AwardIntegralResp> wfzResp = JSON.parseObject(body, new TypeReference<WfzBaseResp<AwardIntegralResp>>(AwardIntegralResp.class) {
            });
            if (Objects.equals(wfzResp.getCode(), 0)) {
                duibaDoc.put("status", "success");
                duibaDoc.put("supplierBizId", wfzResp.getData().getVoucher().toString());
            } else {
                duibaDoc.put("status", "fail");
                String errorMsg = wfzResp.getMessage();
                if (StringUtils.length(errorMsg) > 255) {
                    errorMsg = errorMsg.substring(0, 255);
                }
                duibaDoc.put("errorMessage", errorMsg);
            }
            duibaDoc.put("credits", getCredits(uid,appId));
        } catch (Exception e) {
            LOGGER.error("五芳斋，充值商品定制，结果解析错误:{}", body, e);
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", "积分兑换响应解析错误");
        }
        return JSON.toJSONString(duibaDoc);
    }

    /**
     * 获取定制的减积分请求
     *
     * @param params
     * @return
     */
    private HttpPost getSubCreditsRequest(Map<String, String> params,String appId) {
        WfzTokenBean wfzTokenBean = this.getToken(appId);
        HttpPost httpPost = new HttpPost(WuFangZhaiConfig.Api.TRADE_REDUCE_INTEGRAL.getApiAbsolutePath(wuFangZhaiConfig));

        ReduceIntegralReq reduceIntegralReq = new ReduceIntegralReq();
        reduceIntegralReq.setBrandId(wfzTokenBean.getBrandId().longValue());
        reduceIntegralReq.setCardNo(params.get("uid"));
        reduceIntegralReq.setMerchantNo(wfzTokenBean.getMerchantNo());
        reduceIntegralReq.setIntegralValue(new BigDecimal(params.get("credits")));
        reduceIntegralReq.setCashierSerial(params.get("orderNum"));
        reduceIntegralReq.setRemark(params.get("description"));
        reduceIntegralReq.setMobile("");

        WfzReq req = new WfzReq();
        req.setAccessToken(wfzTokenBean.getAccessToken());
        req.setCiphertext(JSON.toJSONString(reduceIntegralReq));
        StringEntity stringEntity = new StringEntity(JSON.toJSONString(req), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity(stringEntity);
        return httpPost;
    }


    /**
     * 获取定制的加积分请求
     *
     * @param params
     * @return
     */
    private HttpPost getAddCreditsRequest(Map<String, String> params,String appId) {
        WfzTokenBean wfzTokenBean = this.getToken(appId);
        HttpPost httpPost = new HttpPost(WuFangZhaiConfig.Api.TRADE_AWARD_INTEGRAL.getApiAbsolutePath(wuFangZhaiConfig));
        AwardIntegralReq awardIntegralReq = new AwardIntegralReq();
        awardIntegralReq.setBrandId(wfzTokenBean.getBrandId().longValue());
        awardIntegralReq.setCardNo(params.get("uid"));
        awardIntegralReq.setMerchantNo(wfzTokenBean.getMerchantNo());
        awardIntegralReq.setIntegralValue(new BigDecimal(params.get("credits")));
        awardIntegralReq.setCashierSerial(params.get("orderNum"));
        awardIntegralReq.setRemark(params.get("description"));

        WfzReq req = new WfzReq();
        req.setAccessToken(wfzTokenBean.getAccessToken());
        req.setCiphertext(JSON.toJSONString(awardIntegralReq));
        StringEntity stringEntity = new StringEntity(JSON.toJSONString(req), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity(stringEntity);
        return httpPost;
    }


    /**
     * 查询用户积分
     *
     * @param uid 五芳斋的defaultCard字段值作为兑吧的uid
     * @return
     */
    private String getCredits(String uid,String appId) {
        WfzTokenBean wfzTokenBean = this.getToken(appId);
        CardQueryInfoReq req = new CardQueryInfoReq();
        req.setBrandId(wfzTokenBean.getBrandId());
        req.setMerchantNo(wfzTokenBean.getMerchantNo());
        req.setQueryStr(uid);

        WfzReq wfzReq = new WfzReq();
        wfzReq.setAccessToken(wfzTokenBean.getAccessToken());
        wfzReq.setCiphertext(JSON.toJSONString(req));
        String url = WuFangZhaiConfig.Api.CARD_QUERY_INFO.getApiAbsolutePath(wuFangZhaiConfig);
        HttpPost httpPost = new HttpPost(url);
        StringEntity stringEntity = new StringEntity(JSON.toJSONString(wfzReq), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity(stringEntity);
        String resp = "";
        HttpUtils.resetTimeOut(httpPost);
        try (CloseableHttpResponse response = httpClient.execute(httpPost)) {
            HttpEntity entity = response.getEntity();
            resp = EntityUtils.toString(entity, "UTF-8");
        } catch (IOException e) {
            LOGGER.warn("五芳斋，查询积分，发送post请求异常，uid={}，url={},req={}", uid, url, JSON.toJSONString(wfzReq), e);
            return null;
        }
        WfzBaseResp<CardQueryInfoResp> result = JSON.parseObject(resp, new TypeReference<WfzBaseResp<CardQueryInfoResp>>(CardQueryInfoResp.class) {
        });
        if (Objects.equals(result.getCode(), 0)) {
            long credits = result.getData().getCard().getIntegralAvailable().longValue();
            return String.valueOf(credits);
        } else {
            LOGGER.warn("五芳斋，查询积分，发送post请求失败，uid={}，resp={}", uid, resp);
            return null;
        }
    }

    /**
     * 查询用户手机号
     *
     * @param uid 五芳斋的defaultCard字段值作为兑吧的uid
     * @return
     */
    private String getMobile(String uid,String appId) {
        WfzTokenBean wfzTokenBean = this.getToken(appId);
        CardQueryInfoReq req = new CardQueryInfoReq();
        req.setBrandId(wfzTokenBean.getBrandId());
        req.setMerchantNo(wfzTokenBean.getMerchantNo());
        req.setQueryStr(uid);

        WfzReq wfzReq = new WfzReq();
        wfzReq.setAccessToken(wfzTokenBean.getAccessToken());
        wfzReq.setCiphertext(JSON.toJSONString(req));
        String url = WuFangZhaiConfig.Api.CARD_QUERY_INFO.getApiAbsolutePath(wuFangZhaiConfig);
        HttpPost httpPost = new HttpPost(url);
        StringEntity stringEntity = new StringEntity(JSON.toJSONString(wfzReq), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity(stringEntity);
        String resp = "";
        HttpUtils.resetTimeOut(httpPost);
        try (CloseableHttpResponse response = httpClient.execute(httpPost)) {
            HttpEntity entity = response.getEntity();
            resp = EntityUtils.toString(entity, "UTF-8");
        } catch (IOException e) {
            LOGGER.warn("五芳斋，查询手机号，发送post请求异常，uid={}，url={},req={}", uid, url, JSON.toJSONString(wfzReq), e);
            return null;
        }
        WfzBaseResp<CardQueryInfoResp> result = JSON.parseObject(resp, new TypeReference<WfzBaseResp<CardQueryInfoResp>>(CardQueryInfoResp.class) {
        });
        if (Objects.equals(result.getCode(), 0)) {
            return result.getData().getMembership().getMobile();
        } else {
            LOGGER.warn("五芳斋，查询手机号，发送post请求失败，uid={}，resp={}", uid, resp);
            return null;
        }
    }

    /**
     * 获取token
     *
     * @return
     */
    public WfzTokenBean getToken(String appId) {
        String username ;
        String password;
        if (StringUtils.isBlank(appId)) {
            //做一层兼容保证RPC老接口没问题
            username= wuFangZhaiConfig.getUsername();
            password= wuFangZhaiConfig.getPassword();
        }else {
            username= wuFangZhaiConfig.getConfigByAppIdIfNullThrowEx(appId).getUsername();
            password= wuFangZhaiConfig.getConfigByAppIdIfNullThrowEx(appId).getPassword();
        }
        String cacheKey = String.format(CACHE_TOKEN_KEY_FORMAT, wuFangZhaiConfig.getClientId(), username);
        String cacheToken = advancedCacheClient.get(cacheKey);
        if (StringUtils.isNotBlank(cacheToken)) {
            WfzTokenBean wfzTokenBean = JSON.parseObject(cacheToken, WfzTokenBean.class);
            return wfzTokenBean;
        }
        String lockKey = String.format(LOCK_TOKEN_KEY_FORMAT, wuFangZhaiConfig.getClientId(), username);
        RedisLock lock = redisAtomicClient.getLock(lockKey, 2);
        if (lock == null) {
            throw new ThirdpatyException("五芳斋，请求token，获取分布式锁失败");
        }
        try {
            String url = WuFangZhaiConfig.Api.GET_TOKEN.getApiAbsolutePath(wuFangZhaiConfig);
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader(HTTP_HEADER_CONTENT_TYPE, FORM_TYPE);
            Map<String, String> map = new HashMap<>();
            map.put("client_id", wuFangZhaiConfig.getClientId());
            map.put("client_secret", wuFangZhaiConfig.getClientSecret());
            map.put("grant_type", wuFangZhaiConfig.getGrantType());
            map.put("scope", wuFangZhaiConfig.getScope());
            map.put("username", username);
            map.put("password", password);
            LOGGER.info("五芳斋，请求token入参 param:{}", JSON.toJSONString(map));
            List<NameValuePair> params = new ArrayList<>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                NameValuePair nameValuePair = new BasicNameValuePair(entry.getKey(), entry.getValue());
                params.add(nameValuePair);
            }
            httpPost.setEntity(new UrlEncodedFormEntity(params, Charset.forName("utf-8")));
            String resp = null;
            HttpUtils.resetTimeOut(httpPost);
            try (CloseableHttpResponse response = httpClient.execute(httpPost)) {
                HttpEntity entity = response.getEntity();
                resp = EntityUtils.toString(entity, "UTF-8");
            } catch (IOException e) {
                LOGGER.warn("五芳斋，请求token，异常，请求参数params={}", JSON.toJSONString(map), e);
                throw new ThirdpatyException("五芳斋，请求token，异常");
            }
            if (StringUtils.isBlank(resp)) {
                throw new ThirdpatyException("五芳斋，请求token，失败");
            }
            WfzTokenBean wfzTokenBean = JSON.parseObject(resp, WfzTokenBean.class);
            LOGGER.info("五芳斋，请求token响应 response:{}", JSON.toJSONString(wfzTokenBean));
            //刷新缓存
            advancedCacheClient.set(cacheKey, JSON.toJSONString(wfzTokenBean), 1, TimeUnit.HOURS);
            return wfzTokenBean;
        } finally {
            lock.unlock();
        }

    }
}
