package cn.com.duiba.biz.credits;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.constant.YangShiPinConfig;
import cn.com.duiba.domain.SupplierRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * 央视频定制
 *
 * @author haojiahong
 * @date 2020-10-09
 */
@Service
public class YangShiPinApi {

    private static final Logger LOGGER = LoggerFactory.getLogger(YangShiPinApi.class);

    @Autowired
    private YangShiPinConfig yangShiPinConfig;

    public Boolean isYangShiPin(Long appId) {
        Set<Long> appIds = yangShiPinConfig.getAppIds();
        if (null == appIds) {
            return false;
        }
        return appIds.contains(appId);
    }


    /**
     * 加/减积分结果定制
     *
     * @param body
     * @return
     */
    public String parseCreditsResponse(String body) {
        Map<String, String> map = new HashMap<>();
        if (StringUtils.isBlank(body)) {
            map.put("status", "fail");
            map.put("errorMessage", "央视频新增/扣减积分接口返回为空");
            return JSON.toJSONString(map);
        }
        try {
            JSONObject jsonObject = JSON.parseObject(body);
            map.put("status", jsonObject.getJSONObject("data").getString("status"));
            map.put("errorMessage", jsonObject.getJSONObject("data").getString("errorMessage"));
            map.put("bizId", jsonObject.getJSONObject("data").getString("bizId"));
            map.put("credits", jsonObject.getJSONObject("data").getString("credits"));
        } catch (Exception e) {
            LOGGER.error("央视频，积分兑换，结果解析错误:{}", body, e);
            map.put("status", "fail");
            map.put("errorMessage", "积分兑换接口响应解析错误");
        }
        return JSON.toJSONString(map);

    }

    /**
     * 虚拟商品充值结果定制
     *
     * @param message
     * @param body
     * @return
     */
    public String getVirtualResponse(SupplierRequest message, String body) {
        Map<String, String> map = new HashMap<>();
        if (StringUtils.isBlank(body)) {
            throw new ThirdpatyException("央视频，充值商品定制，返回结果为空");
        }
        try {
            JSONObject jsonObject = JSON.parseObject(body);
            map.put("status", jsonObject.getJSONObject("data").getString("status"));
            map.put("credits", jsonObject.getJSONObject("data").getString("credits"));
            map.put("errorMessage", jsonObject.getJSONObject("data").getString("errorMessage"));
            map.put("supplierBizId", jsonObject.getJSONObject("data").getString("supplierBizId"));
        } catch (Exception e) {
            LOGGER.error("央视频，虚拟商品充值，结果解析错误:{}", body, e);
            map.put("status", "fail");
            map.put("errorMessage", "虚拟商品充值接口响应解析错误");
        }
        return JSON.toJSONString(map);
    }

    /**
     * 兑换结果通知返回响应定制
     *
     * @param body
     * @return
     */
    public String getResponseNotify(String body) {
        try {
            JSONObject jsonObject = JSON.parseObject(body);
            String status = jsonObject.getJSONObject("data").getString("status");
            if (StringUtils.equalsIgnoreCase(status, "ok")) {
                return "ok";
            }
        } catch (Exception e) {
            LOGGER.error("央视频，兑换结果通知，结果解析错误:{}", body, e);
        }
        return body;
    }
}
