package cn.com.duiba.biz.credits.nongzonghang;

import cn.com.duiba.constant.nongzonghang.NongZongHangConfig;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.domain.SupplierResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Set;

/**
 * 农总行定制
 * 农总行下，目前有对不同商品做不同的定制。此处通过appId判断进入农总行定制后，会有根据商品编码或者appItemId做特殊定制的处理
 *
 * @author haojiahong
 * @date 2020-07-29
 */
@Service
public class NongZongHangApi {

    @Autowired
    private NongZongHangConfig nongZongHangConfig;
    @Autowired
    private RuixinApi ruixinApi;
    @Autowired
    private FuLuApi fuLuApi;

    public Boolean isNongZongHang(Long appId) {
        Set<Long> appIds = nongZongHangConfig.getAppIds();
        if (CollectionUtils.isEmpty(appIds)) {
            return false;
        }
        return appIds.contains(appId);
    }

    public SupplierRequest getVirtualRequest(SupplierRequest request) {
        if (ruixinApi.isRuiXin4NongZongHang(request)) {
            return ruixinApi.getVirtualRequest(request);
        }
        return request;
    }

    public HttpRequestBase getVirtualRequestHttp(SupplierRequest message) {
        if (fuLuApi.isFuLu4NongZongHang(message)) {
            return fuLuApi.getVirtualRequest(message);
        }
        //默认返回
        return new HttpGet(message.getHttpUrl());
    }

    public String getVirtualResponse(SupplierRequest message, String body, String callbackTopic, String msgTag, String msgKey) {
        if (ruixinApi.isRuiXin4NongZongHang(message)) {
            return ruixinApi.getVirtualResponse(message, body);
        }
        if (fuLuApi.isFuLu4NongZongHang(message)) {
            return fuLuApi.getVirtualResponse(message, body, callbackTopic, msgTag, msgKey);
        }
        return body;
    }

    public boolean customFinallyBlock(SupplierRequest message, SupplierResponse response) {
        if (fuLuApi.isFuLu4NongZongHang(message)) {
            return fuLuApi.customFinallyBlock(response);
        }
        return true;
    }
}
