package cn.com.duiba.biz.credits.unionpay.impl;

import cn.com.duiba.biz.credits.unionpay.BaseUnionPayRequest;
import cn.com.duiba.constant.ZCUnionBankConstants;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.DES3Tool;
import cn.com.duiba.tool.UnionPayBankUtil;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.Set;

@Component
public class ZCUnionPayRequest extends BaseUnionPayRequest {
    @Autowired
    private ZCUnionBankConstants zcUnionBankConstants;

    @Override
    public Set<Long> getAppIdSet() {
        return zcUnionBankConstants.getAppIdSet();
    }

    @Override
    public HttpRequestBase getVirtualRequest(SupplierRequest request, String merchantCoding) {
        if (StringUtils.isBlank(merchantCoding) || !merchantCoding.startsWith(zcUnionBankConstants.getVirtualCreditsPre())) {
            return null;
        }
        // 获取url参数
        Map<String, String> authParamMap = getUrlParams(request);
        // 构造请求参数
        Map<String, String> requestParams = buildVirtualRequestParams(authParamMap, request.getParams(), Long.valueOf(request.getAppId()), merchantCoding.trim());
        LOGGER.info("银联虚拟商品直接抽奖请求参数:{}", JSON.toJSONString(requestParams));

        HttpPost post = new HttpPost(zcUnionBankConstants.getVirtualUrl());
        post.setEntity(new StringEntity(JSON.toJSONString(requestParams), ContentType.APPLICATION_JSON));
        return post;
    }

    /**
     * 构造虚拟商品请求参数
     */
    private Map<String, String> buildVirtualRequestParams(Map<String, String> authParamMap, Map<String,String> params, Long appId, String merchantCoding) {
        Map<String, String> requestParams = buildCommReq(authParamMap, params, appId);
        requestParams.put("activityNo", merchantCoding.replace(zcUnionBankConstants.getVirtualCreditsPre(), ""));
        requestParams.put("signature", UnionPayBankUtil.sign(requestParams, unionPayConstants.getPrivateKey()));
        if (StringUtils.isNotBlank(params.get("devAppId"))) {
            try {
                LOGGER.info("appId:{},devAppId:{},SymmetricKey:{}", appId, params.get("devAppId"), unionPayConstants.getSymmetricKey(params.get("devAppId")));
                //先签再加密
                requestParams.put("mobile", DES3Tool.getEncryptedValue(params.get("mobile"), unionPayConstants.getSymmetricKey(params.get("devAppId"))));
            } catch (Exception e) {
                LOGGER.warn("银联虚拟商品请求参数加密失败, SymmetricKey: =>{}, mobile:{}", unionPayConstants.getSymmetricKey(params.get("devAppId")), params.get("mobile"), e);
            }
        }
        return requestParams;
    }

    @Override
    public String getVirtualResponse(SupplierRequest request, String body, String merchantCoding) {
        return getBaseResponse(body, request, zcUnionBankConstants, merchantCoding);
    }
}