package cn.com.duiba.biz.phonebill.supplier;

import cn.com.duiba.domain.MessageUniqueCheckDO;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.domain.SupplierResponse;
import cn.com.duiba.mq.RocketMQMsgProducer;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.service.MessageService;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.tool.ParserUtil;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PUUPPhoneBillSupplier {

    private static Logger log = LoggerFactory.getLogger(PUUPPhoneBillSupplier.class);

    @Autowired
    private MessageService messageService;
    @Autowired
    private RocketMQMsgProducer rocketMQMsgProducer;
    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;

    /**
     * 提交到HTTP请求池
     * @param message
     * @param callbackTopic
     * @param msgTag
     * @param msgKey
     */
    public void asyncSubmit(final SupplierRequest message, final String callbackTopic, final String msgTag, final String msgKey) {

        if (!messageService.messageUniqueCheck(message.getSupplierOrderId(), MessageUniqueCheckDO.TYPE_PHONEBILL)) {
            return;
        }

        String bodyContent = message.getParams().get("entity");
        HttpPost post = AssembleTool.assembleRequest(message.getHttpUrl(), ParserUtil.parseAttr2KVMap(bodyContent));
        HttpRequestLog.logUrl("[action phonebill] [tag request] [bizId " + message.getOrderId() + "] [url " + message.getHttpUrl() + "]");
        httpAsyncClientPool.submit(message.getAppId(), post, new FutureCallback<HttpResponse>() {

            @Override
            public void completed(HttpResponse response) {
                SupplierResponse resp = new SupplierResponse();
                try {
                    buildSupplierResponse(resp, message);
                    resp.setCallbackType(SupplierResponse.CALLBACK_TYPE_COMPLETED);
                    String body = EntityUtils.toString(response.getEntity());
                    resp.setBody(body);
                } catch (Exception e) {
                    log.error("PUUPPhoneBillSupplier completed", e);
                } finally {
                    finallyBlock(message, resp, callbackTopic, msgTag, msgKey);
                }
            }

            @Override
            public void failed(Exception ex) {
                log.error("PUUPPhoneBillSupplier failed orderId:" + message.getOrderId(), ex);

                SupplierResponse resp = new SupplierResponse();
                try {
                    buildSupplierResponse(resp, message);
                    resp.setCallbackType(SupplierResponse.CALLBACK_TYPE_FAILED);
                    resp.setErrorMessage(ex.getClass().getName() + ":" + ex.getMessage());
                } catch (Exception e) {
                    log.error("PUUPPhoneBillSupplier completed", e);
                } finally {
                    finallyBlock(message, resp, callbackTopic, msgTag, msgKey);
                }
            }

            @Override
            public void cancelled() {
                SupplierResponse resp = new SupplierResponse();
                try {
                    buildSupplierResponse(resp, message);
                    resp.setCallbackType(SupplierResponse.CALLBACK_TYPE_CANCELLED);
                } catch (Exception e) {
                    log.error("PUUPPhoneBillSupplier cancelled", e);
                } finally {
                    finallyBlock(message, resp, callbackTopic, msgTag, msgKey);
                }
            }
        });
    }

    private void buildSupplierResponse(SupplierResponse resp, SupplierRequest message) {
        resp.setUrl(message.getHttpUrl());
        resp.setSupplierName(message.getSupplierName());
        resp.setSupplierOrderId(message.getSupplierOrderId());
        resp.setOrderId(message.getOrderId());
        resp.setAppId(message.getAppId());
        resp.setConsumerId(message.getConsumerId());
    }

    private void finallyBlock(SupplierRequest message, SupplierResponse response, String callbackTopic, String msgTag, String msgKey) {
        try {
            String body = JsonTool.objectToJson(response);
            HttpRequestLog.logUrl("[action phonebill] [tag response] [callback " + response.getCallbackType() + "] [bizId " + message.getOrderId() + "] [body " + response.getBody() + "]");
            if (callbackTopic.contains("MQ")) {
                rocketMQMsgProducer.sendMsg(callbackTopic, msgTag, msgKey, body,false,null);
            } else {
                messageService.sendMsg(callbackTopic,msgTag,msgKey,body);
            }
        } catch (Exception e) {
            log.error("PUUPPhoneBillSupplier callback:" + message.getOrderId(), e);
        }
    }

}
