package cn.com.duiba.constant;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.biz.credits.strategy.Impl.GeneraliChinaApiStrategy;
import com.google.common.collect.Sets;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;
//如意人寿
@Configuration
@ConfigurationProperties(prefix = "generalichina")
public class GeneraliChinaConfig implements InitializingBean {

    /**
     * 应用id集合
     */
    private Set<Long> appIdSet = Sets.newHashSet(81279L);

    private String accessID = "third_ym_test";

    private String accessKey = "12345678";


    @Autowired
    private GeneraliChinaApiStrategy generaliChinaApiStrategy;

    public Set<Long> getAppIdSet() {
        return appIdSet;
    }

    public void setAppIdSet(Set<Long> appIdSet) {
        this.appIdSet = appIdSet;
    }

    public String getAccessID() {
        return accessID;
    }

    public void setAccessID(String accessID) {
        this.accessID = accessID;
    }

    public String getAccessKey() {
        return accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        ApiStrategyRouter.register(appIdSet, generaliChinaApiStrategy);
    }
}
