package cn.com.duiba.constant;

import com.google.common.collect.Sets;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

@Configuration
@ConfigurationProperties(prefix = "guiyang.union.bank")
public class GuiYangUnionBankConstants {
    private Set<Long> appIdSet = Sets.newHashSet(80259L, 85460L);

    /**
     * 贵阳中信，单独申请了一个app，用手机号做uid免登
     */
    private Set<Long> mobileUidAppIdSet = Sets.newHashSet(85460L);

    /**
     * 机构账户代码，最大32位
     */
    private String insAcctId = "P210726170157808";


    /**
     * 积分id，最大64位
     */
    private String pointId = "4121070766189176";


    /**
     * 前缀
     */
    private String virtualCreditsPre = "point_";


    /**
     * 虚拟商品请求地址
     */
    private String virtualUrl = "https://open.95516.com/open/access/1.0/point.acquire";

    public Set<Long> getMobileUidAppIdSet() {
        return mobileUidAppIdSet;
    }

    public void setMobileUidAppIdSet(Set<Long> mobileUidAppIdSet) {
        this.mobileUidAppIdSet = mobileUidAppIdSet;
    }

    public Set<Long> getAppIdSet() {
        return appIdSet;
    }

    public void setAppIdSet(Set<Long> appIdSet) {
        this.appIdSet = appIdSet;
    }

    public String getVirtualCreditsPre() {
        return virtualCreditsPre;
    }

    public void setVirtualCreditsPre(String virtualCreditsPre) {
        this.virtualCreditsPre = virtualCreditsPre;
    }

    public String getVirtualUrl() {
        return virtualUrl;
    }

    public void setVirtualUrl(String virtualUrl) {
        this.virtualUrl = virtualUrl;
    }

    public String getInsAcctId() {
        return insAcctId;
    }

    public void setInsAcctId(String insAcctId) {
        this.insAcctId = insAcctId;
    }

    public String getPointId() {
        return pointId;
    }

    public void setPointId(String pointId) {
        this.pointId = pointId;
    }
}
