package cn.com.duiba.remoteimpl.ceb;

import cn.com.duiba.biz.credits.CebBankApi;
import cn.com.duiba.constant.CebBankConfig;
import cn.com.duiba.credits.sdk.AssembleTool;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.thirdparty.api.ceb.RemoteCebBankService;
import cn.com.duiba.thirdparty.dto.cebbank.CebBankObjectNotifyDto;
import com.alibaba.fastjson.JSON;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.concurrent.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * @author zhengjianhao
 * @date 2020/2/23
 * @description
 */
@RestController
public class RemoteCebBankServiceImpl implements RemoteCebBankService {

	private static final Logger LOGGER = LoggerFactory.getLogger(RemoteCebBankServiceImpl.class);

	@Autowired
	private CebBankConfig cebBankConfig;
	@Autowired
	private HttpAsyncClientPool httpAsyncClientPool;
	@Autowired
	private CebBankApi cebBankApi;

	@Override
	public void objectExchangeNotify(CebBankObjectNotifyDto cebBankObjectNotifyDto) {
		LOGGER.info("光大银行-实物发奖通知，cebBankObjectNotifyDto:{}", JSON.toJSON(cebBankObjectNotifyDto));
		if(!cebBankApi.isCebBank(cebBankObjectNotifyDto.getAppId())){
			return;
		}
		String httpUrl = null;
		try {
			String url = cebBankConfig.getObjectNotifyUrl();
			Map<String, String> requestParams = cebBankApi.buildRequestPrams(cebBankObjectNotifyDto);

			httpUrl = AssembleTool.assembleUrl(url, requestParams);
			LOGGER.info("光大银行-实物发奖通知, httpUrl:{}", httpUrl);

			HttpRequestBase http = new HttpGet(httpUrl);
			httpAsyncClientPool.submit(String.valueOf(cebBankObjectNotifyDto.getAppId()), http, new FutureCallback<HttpResponse>() {

				@Override
				public void completed(HttpResponse response) {
					LOGGER.info("光大银行-实物发奖通知-通知成功");
				}

				@Override
				public void failed(Exception ex) {
					LOGGER.info("光大银行-实物发奖通知-通知失败", ex);
				}

				@Override
				public void cancelled() {
					LOGGER.info("光大银行-实物发奖通知-通知取消");
				}
			}, null);
		}catch (Exception e){
			LOGGER.info("光大银行-实物发奖通知异常, httpUrl:{}, 入参CebBankObjectNotifyDto:{}", httpUrl, JSON.toJSON(cebBankObjectNotifyDto), e);
		}
	}
}
