package cn.com.duiba.service.impl;

import cn.com.duiba.dao.AppNewExtraDao;
import cn.com.duiba.service.AccessAcountService;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.concurrent.TimeUnit;

/**
 * Created by liukai on 2018/10/19
 */
@Service
public class AccessAcountServiceImpl implements AccessAcountService {


    private static final Logger log = LoggerFactory.getLogger(AccessAcountServiceImpl.class);

    private static Cache<Long, Boolean> accessAcountCache = CacheBuilder.newBuilder().maximumSize(1000)
            .expireAfterWrite(1, TimeUnit.MINUTES).build();

    @Autowired
    private AppNewExtraDao appNewExtraDao;

    @Override
    public Boolean canAccessAcount(Long appId) {
        Assert.notNull(appId, "appId不能为null");
        try {
            return accessAcountCache.get(appId,() -> isExistsInternal(appId));
        } catch (Exception e) {
            log.error("canAccessAcount Cache error appid={}",appId, e);
            return isExistsInternal(appId);
        }
    }

    private Boolean isExistsInternal(Long appId) {
        String statu = appNewExtraDao.findAccessAccountStatus(appId);
        return StringUtils.equals(statu,"on");
    }

}