package cn.com.duiba.tool;


import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;

/**
 * 用于修复http连接可能超时的问题
 * */
public class HttpUtils {

    /**
     * 设置每次请求的超时时间，默认5000,5000,10
     */
    public static void resetTimeOut(HttpRequestBase requestBase) {
        RequestConfig config;
        RequestConfig existConfig = requestBase.getConfig();
        if (existConfig == null) {
            // new出一个config来设置
            config = RequestConfig.custom()
                    .setConnectTimeout(5000)
                    .setSocketTimeout(5000)
                    .setConnectionRequestTimeout(10)
                    .build();
        } else {
            // 复制出一个config来设置
            RequestConfig.Builder builder = RequestConfig.copy(existConfig);
            if (existConfig.getConnectTimeout() == 0 || existConfig.getConnectTimeout() == -1) {
                builder.setConnectTimeout(5000);
            }
            if (existConfig.getSocketTimeout() == 0 || existConfig.getSocketTimeout() == -1) {
                builder.setSocketTimeout(5000);
            }
            if (existConfig.getConnectionRequestTimeout() == 0 || existConfig.getConnectionRequestTimeout() == -1) {
                builder.setConnectionRequestTimeout(10);
            }

            config = builder.build();
        }
        requestBase.setConfig(config);
    }

}
