package cn.com.duiba.tool.sn;

import org.springframework.util.Assert;

import java.security.PrivateKey;
import java.security.Signature;

public class SignatureSigner {

    /**
     * 使用提供的算法与私钥对交易数据签名
     *
     * @param plain 交易数据明文
     * @param algorithm 签名算法
     * @param privateKey java.security.PrivateKey 私钥
     * @return 签名
     */
    public String sign(String plain, String algorithm, PrivateKey privateKey){
        Assert.notNull(plain, "plain is null.");
        Assert.notNull(algorithm, "algorithm is null.");
        Assert.notNull(privateKey, "private key is null.");
        try {
            Signature sign = Signature.getInstance(algorithm);
            sign.initSign(privateKey);
            sign.update(plain.getBytes());
            return Hex.toHex(sign.sign());
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}
