package cn.com.duiba.tool.suning;

/*
 * Copyright (C), 2002-2013, 苏宁易购电子商务有限公司
 * FileName: RSAUtil.java
 * Author:   王子银
 * Date:     2013-9-30 下午02:25:56
 * Description: //模块目的、功能描述      
 * History: //修改记录
 * <author>      <time>      <version>    <desc>
 * 修改人姓名             修改时间            版本号                  描述
 */

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;

/**
 * RSA工具类<br>
 * 
 * @author 王子银 2013-9-30 下午02:25:56
 * @since 10.15
 */
public class RSAUtil {

    /**
     * RSA签名方式
     */
    private static final String RSA = "RSA";

    /**
     * RSA加密，长度支持512-2048
     */
    private static final int RSA_SIZE_2048 = 2048;

    /**
     * RSA加密，长度支持512-2048
     */
    private static final int RSA_SIZE_1024 = 1024;

    /**
     * Md5 RSA算法
     */
    @SuppressWarnings("unused")
    private static final String MD5_WITH_RSA = "MD5withRSA";

    /**
     * SHA1 RSA算法
     */
    private static final String SHA1_WITH_RSA = "SHA1WithRSA";

    /**
     * 公钥对象KEY
     */
    public static final String PUBLIC_KEY = "publicKey";

    /**
     * Base64编码后的公钥对象KEY
     */
    public static final String PUBLIC_KEY_B64 = "publicKeyBase64";

    /**
     * 私钥对象KEY
     */
    public static final String PRIVATE_KEY = "privateKey";

    /**
     * Base64编码后的私钥对象KEY
     */
    public static final String PRIVATE_KEY_B64 = "privateKeyBase64";

    /**
     * 
     * 验证签名 <br>
     * 
     * @param data c
     * @param sign 签名值
     * @param pubk 公钥
     * @return
     * @throws NoSuchAlgorithmException
     * @throws InvalidKeyException
     * @throws SignatureException
     * @since 10.15
     */
    public static boolean vertiy(byte[] data, byte[] sign, PublicKey pubk) throws NoSuchAlgorithmException,
            InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance(SHA1_WITH_RSA);
        signature.initVerify(pubk);
        signature.update(data);
        return signature.verify(sign);
    }

    /**
     * 
     * 验证签名 <br>
     * 
     * @param data 原文
     * @param sign Base64编码后的签名值
     * @param pubk 公钥
     * @return
     * @throws InvalidKeyException
     * @throws NoSuchAlgorithmException
     * @throws SignatureException
     * @since 10.15
     */
    public static boolean vertiy(String data, String sign, PublicKey pubk) throws InvalidKeyException,
            NoSuchAlgorithmException, SignatureException {
        return vertiy(data.getBytes(), Base64.decodeBase64(sign), pubk);
    }

    /**
     * 
     * RSA签名:
     * 
     * @param data 请求原文
     * @param prik 私钥
     * @return 签名值
     * @throws NoSuchAlgorithmException
     * @throws InvalidKeyException
     * @throws SignatureException
     * @since 10.15
     */
    public static byte[] sign(byte[] data, PrivateKey prik) throws NoSuchAlgorithmException, InvalidKeyException,
            SignatureException {
        Signature signature = Signature.getInstance(SHA1_WITH_RSA);
        signature.initSign(prik);
        signature.update(data);
        return signature.sign();
    }

    /**
     * 
     * RSA签名
     * 
     * @param data 请求原文
     * @param prik 私钥
     * @return
     * @throws InvalidKeyException
     * @throws NoSuchAlgorithmException
     * @throws SignatureException
     * @see [相关类/方法](可选)
     * @since [产品/模块版本](可选)
     */
    public static String sign(String data, PrivateKey prik) throws InvalidKeyException, NoSuchAlgorithmException,
            SignatureException {
        return Base64.encodeBase64String(sign(data.getBytes(), prik)).trim();
    }

    /**
     * 
     * 将通过Base64编码后的String类型的公钥字符串转换为PublicKey对象
     * 
     * @param strPubKey Base64编码后的String类型的公钥字符串
     * @return
     * @throws NoSuchAlgorithmException
     * @throws InvalidKeySpecException
     * @since 10.15
     */
    public static PublicKey getPublicKey(String strPubKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(Base64.decodeBase64(strPubKey));
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        PublicKey pubKey = keyFactory.generatePublic(pubKeySpec);
        return pubKey;
    }

    /**
     * 
     * 将通过Base64编码后的String类型的私钥字符串转换为PrivateKey对象
     * 
     * @param strPriKey Base64编码后的String类型的私钥字符串
     * @return
     * @throws NoSuchAlgorithmException
     * @throws InvalidKeySpecException
     * @since 10.15
     */
    public static PrivateKey getPrivateKey(String strPriKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PKCS8EncodedKeySpec priKeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64(strPriKey));
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        PrivateKey priKey = keyFactory.generatePrivate(priKeySpec);
        return priKey;
    }

    /**
     * 
     * RSA加密<br>
     * 注意：此方法支持公钥加密私钥解密或者私钥加密公钥解密
     * 
     * @param key 公钥或者私钥
     * @param message 准备加密的原文
     * @return 加密后的密文
     * @throws NoSuchAlgorithmException
     * @throws NoSuchPaddingException
     * @throws InvalidKeyException
     * @throws IllegalBlockSizeException
     * @throws BadPaddingException
     */
    public static String encrypt(Key key, String message) throws NoSuchAlgorithmException, NoSuchPaddingException,
            InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(Cipher.ENCRYPT_MODE, key);
        byte[] miwen = cipher.doFinal(message.getBytes());
        return String.valueOf(new BigInteger(miwen));
    }

    /**
     * 
     * RSA解密<br>
     * 注意：此方法支持公钥加密私钥解密或者私钥加密公钥解密
     * 
     * @param key 私钥或者公钥
     * @param message 已加密的密文
     * @return 解密后的原文
     * @throws NoSuchAlgorithmException
     * @throws NoSuchPaddingException
     * @throws InvalidKeyException
     * @throws IllegalBlockSizeException
     * @throws BadPaddingException
     */
    public static String decrypt(Key key, String message) throws NoSuchAlgorithmException, NoSuchPaddingException,
            InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        byte[] miwen = new BigInteger(message).toByteArray();
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(Cipher.DECRYPT_MODE, key);
        byte[] result = cipher.doFinal(miwen);
        return new String(result);
    }
}
