/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.api.bo.subcredits.SubCreditsResultMsgDto;
import cn.com.duiba.api.enums.HttpRequestResultType;
import cn.com.duiba.api.enums.RedisKeySpace;
import cn.com.duiba.api.tools.RandomCodeUtil;
import cn.com.duiba.api.tools.abc.SHAEncrypt4ABCUtils;
import cn.com.duiba.constant.AbchinaConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class AbchinaApi {
    private Logger logger = LoggerFactory.getLogger(AbchinaApi.class);
    public static final String APP_ID = "appid";
    public static final String FRIEND_SEQNO = "friend_seqno";
    public static final String SEQNO = "seqno";
    public static final String ID = "id";
    public static final String CHANNEL = "channel";
    public static final String APP_SECRET = "appsecret";
    public static final String SIGN = "sign";
    public static final String ACTNCOD = "actncod";
    public static final Long EXPIRE_TIME = 7L;
    public static final String UIDDECLIMIT_TYPE = "#NEED_AUTH_CHECK#";
    @Autowired
    private AbchinaConfig abchinaConfig;
    @Resource(name="stringRedisTemplate")
    private StringRedisTemplate redisTemplate;

    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        try {
            SubCreditsMsgDto subCreditsMsgDto = subCreditsMsgWrapper.getSubCreditsMsg();
            subCreditsMsgDto.setHttpType(2);
            String url = subCreditsMsgWrapper.getHttpUrl();
            String host = url.substring(0, url.indexOf(63));
            subCreditsMsgWrapper.setHttpUrl(host);
            Map originAuthParams = subCreditsMsgDto.getAuthParams();
            HashMap authParams = Maps.newHashMap();
            if (!subCreditsMsgDto.getParams().isEmpty()) {
                authParams.put(ACTNCOD, subCreditsMsgDto.getParams().get(ACTNCOD));
            }
            if (authParams.get(ACTNCOD) == null) {
                authParams.put(ACTNCOD, subCreditsMsgDto.getCreditConsumeParams().getDescription());
            }
            authParams.put(APP_ID, this.abchinaConfig.getDuibaAppId());
            authParams.put(FRIEND_SEQNO, originAuthParams.get("orderNum"));
            authParams.put(ID, originAuthParams.get("uid"));
            authParams.put(APP_SECRET, this.abchinaConfig.getDuibaAppSecret());
            String transfer = (String)originAuthParams.get("transfer");
            if (StringUtils.isNotBlank((String)transfer)) {
                String[] str = transfer.split("@");
                authParams.put(SEQNO, str[0]);
                authParams.put(CHANNEL, str[1]);
            }
            authParams.put(SIGN, SHAEncrypt4ABCUtils.encrypt((Map)authParams));
            authParams.remove(APP_SECRET);
            subCreditsMsgWrapper.getSubCreditsMsg().setAuthParams((Map)authParams);
            return subCreditsMsgWrapper;
        }
        catch (Exception e) {
            this.logger.info("AbchinaApi call getSubCreditsMessage error , subCreditsMsgWrapper = {}", (Object)JSONObject.toJSONString((Object)subCreditsMsgWrapper), (Object)e);
            return subCreditsMsgWrapper;
        }
    }

    public String parseCreditsRsp(String body) {
        JSONObject jsonBody;
        try {
            jsonBody = JSON.parseObject((String)body);
        }
        catch (Exception e) {
            this.logger.error("JSON.parseObject:", (Throwable)e);
            return body;
        }
        JSONObject json = JsonTool.getAllJson(jsonBody);
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        String status = json.getString("returncode");
        if ("000000".equals(status)) {
            duibaDoc.put("status", "ok");
            duibaDoc.put("bizId", this.getBizId());
        } else {
            duibaDoc.put("status", "fail");
            String msg2 = StringUtils.defaultIfBlank((String)json.getString("returnmsg"), (String)"");
            if ("UIDDECLIMITEXCEPTION".equals(status)) {
                msg2 = UIDDECLIMIT_TYPE + msg2;
            }
            duibaDoc.put("errorMessage", msg2);
            duibaDoc.put("returnCode", json.getString("returncode"));
        }
        duibaDoc.put("credits", json.getString("numBean"));
        return JsonTool.objectToJson(duibaDoc);
    }

    private String getBizId() {
        return String.valueOf(System.currentTimeMillis()) + "T" + RandomCodeUtil.getNumCode((int)4);
    }

    public boolean isAbchinaApp(Long appId) {
        return this.abchinaConfig.getAppIds().contains(appId);
    }

    public void addCreditsNum(SubCreditsMsgWrapper req, SubCreditsResultMsgDto resp) {
        if (req.getSubCreditsMsg().getAppId() == null) {
            return;
        }
        Long appId = req.getSubCreditsMsg().getAppId();
        if (!this.isAbchinaApp(appId)) {
            return;
        }
        if (!HttpRequestResultType.COMPLETED.equals((Object)resp.getResultType()) || 1 != resp.getCode()) {
            return;
        }
        String actncod = this.getActncod(req);
        if (StringUtils.isBlank((String)actncod)) {
            return;
        }
        Long credits = req.getSubCreditsMsg().getCreditConsumeParams().getCredits();
        if (null == credits) {
            credits = 0L;
        }
        this.redisTemplate.boundHashOps((Object)this.getBeanNumDateKey()).increment((Object)actncod, 1L);
        this.redisTemplate.boundHashOps((Object)this.getBeanNumDateKey()).expire(EXPIRE_TIME.longValue(), TimeUnit.DAYS);
        this.redisTemplate.boundHashOps((Object)this.getBeanCountDateKey()).increment((Object)actncod, credits.longValue());
        this.redisTemplate.boundHashOps((Object)this.getBeanCountDateKey()).expire(EXPIRE_TIME.longValue(), TimeUnit.DAYS);
    }

    private String getActncod(SubCreditsMsgWrapper req) {
        if (null == req || null == req.getSubCreditsMsg() || req.getSubCreditsMsg().getParams().isEmpty()) {
            return "";
        }
        return (String)req.getSubCreditsMsg().getParams().get(ACTNCOD);
    }

    private String getBeanNumDateKey() {
        return RedisKeySpace.K150.toString() + DateUtils.getDayNumber((Date)new Date()) + "_NUM";
    }

    private String getBeanCountDateKey() {
        return RedisKeySpace.K150.toString() + DateUtils.getDayNumber((Date)new Date()) + "_COUNT";
    }
}

