/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.constant.QiaQiaConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QiaQiaApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(QiaQiaApi.class);
    @Autowired
    private QiaQiaConfig qiaQiaConfig;
    @Resource(name="httpClient")
    private CloseableHttpClient httpClient;

    public Boolean isQiaQia(Long appId) {
        Set<Long> appIds = this.qiaQiaConfig.getAppIds();
        if (null == appIds) {
            return false;
        }
        return appIds.contains(appId);
    }

    public HttpRequestBase getAddCreditsMessage(CreditsMessageDto request) {
        String httpUrl = request.getHttpUrl();
        String paramStr = httpUrl.substring(httpUrl.indexOf(63) + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramStr);
        return this.getCreditsRequest(params, true);
    }

    private HttpPut getCreditsRequest(Map<String, String> params, boolean isAdd) {
        HttpPut put = new HttpPut(String.format(this.qiaQiaConfig.getUrl(), this.qiaQiaConfig.getPointContextPath(), this.qiaQiaConfig.getPointVersion(), this.qiaQiaConfig.getPointRestPath()));
        String time = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        this.addHeader((HttpRequestBase)put, this.qiaQiaConfig.getPointContextPath(), this.qiaQiaConfig.getSelectVersion(), this.qiaQiaConfig.getPointRestPath(), time);
        put.addHeader("X-Business-Token", params.get("orderNum") + "-" + time);
        put.setEntity((HttpEntity)new StringEntity(this.pointParams(isAdd, params.get("uid"), params.get("credits"), params.get("description"), params.get("orderNum")), "utf-8"));
        return put;
    }

    public HttpRequestBase getSubCreditsMessage(CreditsMessage message) {
        String url = message.getHttpUrl();
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        return this.getCreditsRequest(params, false);
    }

    public HttpRequestBase getSubCreditsMessage(SubCreditsMsgWrapper message) {
        String url = message.getHttpUrl();
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        return this.getCreditsRequest(params, false);
    }

    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        String goodsNum = params.get("params");
        request.setAuthParams(params);
        if (goodsNum.startsWith(this.qiaQiaConfig.getVirtualCreditsPre())) {
            params.put("credits", goodsNum.replace(this.qiaQiaConfig.getVirtualCreditsPre(), ""));
            return this.getCreditsRequest(params, true);
        }
        return AssembleTool.assembleRequest(request.getHttpUrl(), request.getAuthParams());
    }

    private String pointParams(boolean isAdd, String uid, String credits, String description, String orderNum) {
        JSONObject param = new JSONObject();
        if (isAdd) {
            param.put("changeType", (Object)"SEND");
            param.put("expiredTime", (Object)DateUtil.format((Date)DateUtil.offsetMonth((Date)new Date(), (int)12), (String)"yyyy-MM-dd HH:mm:ss"));
        } else {
            param.put("changeType", (Object)"DEDUCT");
        }
        param.put("channelType", (Object)this.qiaQiaConfig.getChannelType());
        param.put("description", (Object)(description + "-" + orderNum));
        param.put("memberId", (Object)uid);
        param.put("memberType", (Object)this.qiaQiaConfig.getMemberType());
        param.put("point", (Object)credits);
        return param.toJSONString();
    }

    private void addHeader(HttpRequestBase base, String contextPath, String version, String requestPath, String timestamp) {
        base.addHeader("X-Caller-Service", this.qiaQiaConfig.getServiceName());
        base.addHeader("X-Caller-Timestamp", timestamp);
        base.addHeader("X-Caller-Sign", QiaQiaApi.generateSign(this.qiaQiaConfig.getServiceName(), contextPath, version, timestamp, this.qiaQiaConfig.getServiceSecret(), requestPath));
        base.addHeader("Content-Type", "application/json; charset=utf-8");
    }

    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            if (StringUtils.isBlank((CharSequence)body)) {
                map.put("status", "ok");
                map.put("bizId", authParams.get("orderNum"));
            } else {
                JSONObject bodyJson = JSONObject.parseObject((String)body);
                map.put("status", "fail");
                String msg2 = bodyJson.getString("msg");
                if (StringUtils.isNotBlank((CharSequence)msg2)) {
                    map.put("errorMessage", bodyJson.getString("msg"));
                } else {
                    map.put("errorMessage", bodyJson.getString("message"));
                }
            }
            map.put("credits", this.getCredits(authParams.get("uid")));
            return JSONObject.toJSONString(map);
        }
        catch (Exception e) {
            LOGGER.error("\u6070\u6070\u65b0\u589e/\u6263\u51cf\u79ef\u5206\u63a5\u53e3\u89e3\u6790\u9519\u8bef:{}--\u662f\u5426\u65b0\u589e:{}", new Object[]{body, addCredits, e});
            map.put("status", "fail");
            map.put("errorMessage", "\u89e3\u6790\u79ef\u5206\u7ed3\u679c\u9519\u8bef");
            return JSONObject.toJSONString(map);
        }
    }

    public String getVirtualResponse(SupplierRequest request, String body) {
        Map<String, String> params = request.getAuthParams();
        String goodsNum = params.get("params");
        String uid = params.get("uid");
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        try {
            if (goodsNum.startsWith(this.qiaQiaConfig.getVirtualCreditsPre())) {
                if (StringUtils.isBlank((CharSequence)body)) {
                    duibaDoc.put("status", "ok");
                    duibaDoc.put("supplierBizId", params.get("orderNum"));
                    duibaDoc.put("credits", this.getCredits(uid));
                } else {
                    JSONObject bodyJson = JSONObject.parseObject((String)body);
                    duibaDoc.put("status", "fail");
                    String msg2 = bodyJson.getString("msg");
                    if (StringUtils.isNotBlank((CharSequence)msg2)) {
                        duibaDoc.put("errorMessage", bodyJson.getString("msg"));
                    } else {
                        duibaDoc.put("errorMessage", bodyJson.getString("message"));
                    }
                }
                return JSON.toJSONString(duibaDoc);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6070\u6070\u79ef\u5206\u5151\u6362\u63a5\u53e3\u89e3\u6790\u9519\u8bef:{}", (Object)body, (Object)e);
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", "\u79ef\u5206\u5151\u6362\u54cd\u5e94\u89e3\u6790\u9519\u8bef");
            return JSON.toJSONString(duibaDoc);
        }
        return body;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getCredits(String memberId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("channelType", this.qiaQiaConfig.getChannelType());
        map.put("memberId", memberId);
        map.put("memberType", this.qiaQiaConfig.getMemberType());
        HttpGet get = new HttpGet(AssembleTool.assembleUrl(String.format(this.qiaQiaConfig.getUrl(), this.qiaQiaConfig.getSelectContextPath(), this.qiaQiaConfig.getSelectVersion(), this.qiaQiaConfig.getSelectRestPath()), map));
        String time = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        this.addHeader((HttpRequestBase)get, this.qiaQiaConfig.getSelectContextPath(), this.qiaQiaConfig.getSelectVersion(), this.qiaQiaConfig.getSelectRestPath(), time);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);){
            if (response.getStatusLine().getStatusCode() != 200) return "0";
            JSONObject jsonObject = JSON.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity()));
            Double point = jsonObject.getJSONObject("pointInfo").getDouble("point");
            if (point == null) return "0";
            Long p = point.longValue();
            String string = p.toString();
            return string;
        }
        catch (Exception e) {
            LOGGER.error("\u6070\u6070\u79ef\u5206\u67e5\u8be2\u9519\u8bef memberid={}", (Object)memberId, (Object)e);
        }
        return "0";
    }

    public static String generateSign(String callerService, String contextPath, String version, String timestamp, String serviceSecret, String requestPath) {
        String sign = "";
        if (StringUtils.isBlank((CharSequence)callerService) || StringUtils.isBlank((CharSequence)contextPath) || StringUtils.isBlank((CharSequence)timestamp) || StringUtils.isBlank((CharSequence)serviceSecret)) {
            return sign;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("callerService", callerService);
        map.put("contextPath", contextPath);
        try {
            if (requestPath != null) {
                StringBuilder sb = new StringBuilder();
                for (String part : requestPath.split("/")) {
                    sb.append("/").append(URLEncoder.encode(part, "utf-8"));
                }
                map.put("requestPath", sb.toString().substring(1));
            }
            map.put("timestamp", timestamp);
            map.put("v", version);
            sign = QiaQiaApi.generateMD5Sign(serviceSecret, map);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            LOGGER.error("\u7b7e\u540d\u751f\u6210\u5931\u8d25", (Throwable)e);
            return "";
        }
        return sign;
    }

    private static String generateMD5Sign(String secret, Map<String, String> parameters) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        byte[] bytes = md5.digest(QiaQiaApi.generateConcatSign(secret, parameters).getBytes("utf-8"));
        return QiaQiaApi.byteToHex(bytes);
    }

    private static String generateConcatSign(String secret, Map<String, String> parameters) {
        StringBuilder sb = new StringBuilder().append(secret);
        Set<String> keys = parameters.keySet();
        for (String key : keys) {
            sb.append(key).append(parameters.get(key));
        }
        return sb.append(secret).toString();
    }

    private static String byteToHex(byte[] bytesIn) {
        StringBuilder sb = new StringBuilder();
        for (byte byteIn : bytesIn) {
            String bt = Integer.toHexString(byteIn & 0xFF);
            if (bt.length() == 1) {
                sb.append(0).append(bt);
                continue;
            }
            sb.append(bt);
        }
        return sb.toString().toUpperCase();
    }
}

