/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.constant.SiChuanLianTongConfig;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.AssembleTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SiChuanLianTongApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(SiChuanLianTongApi.class);
    private static final String CHARACTER_ENCODE = "UTF-8";
    private static final String SUCCESS_CODE = "0000";
    @Autowired
    private SiChuanLianTongConfig siChuanLianTongConfig;

    public Boolean isSiChuanLianTongApp(Long appId) {
        return this.siChuanLianTongConfig.isSiChuanLianTongApp(appId);
    }

    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf(63));
        String queryString = url.substring(newUrl.length() + 1);
        Map<String, String> params = AssembleTool.getUrlParams(queryString);
        String cusParams = null;
        try {
            cusParams = URLDecoder.decode(params.get("params"), "utf-8");
            LOGGER.info("10010 params:{}", (Object)cusParams);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String[] cusParamsArr = cusParams.split("\\|");
        boolean isPackage = cusParamsArr.length >= 5;
        String appId = this.siChuanLianTongConfig.getClientId();
        String appSecret = this.siChuanLianTongConfig.getClientSecret();
        Long timestamp = System.currentTimeMillis();
        String signUrl = isPackage ? this.siChuanLianTongConfig.getPackageSignUrl() : this.siChuanLianTongConfig.getSignUrl();
        String sign = DigestUtils.md5Hex((String)("appId=" + appId + ",timestamp=" + timestamp + "," + signUrl + "," + appSecret));
        JSONObject json = new JSONObject();
        json.put("appId", (Object)appId);
        json.put("timestamp", (Object)timestamp);
        json.put("sign", (Object)sign);
        String token = "";
        try {
            token = Hex.encodeHexString((byte[])JSON.toJSONString((Object)json).getBytes(CHARACTER_ENCODE));
        }
        catch (Exception e) {
            LOGGER.warn("\u56db\u5ddd\u8054\u901a \u865a\u62df\u5546\u54c1\u5b9a\u5236\uff0c\u751f\u6210token\u5f02\u5e38", (Throwable)e);
        }
        newUrl = newUrl + "?accessTokenKind=2&accessToken=" + token;
        if (isPackage) {
            String[] urlArr = newUrl.substring(0, newUrl.indexOf("?")).split("/");
            for (int i = 0; i < urlArr.length; ++i) {
                if (!StringUtils.equals((String)urlArr[i], (String)"ability")) continue;
                newUrl = StringUtils.replace((String)newUrl, (String)urlArr[i + 1], (String)cusParamsArr[0]);
                url = StringUtils.replace((String)url, (String)urlArr[i + 1], (String)cusParamsArr[0]);
            }
            LOGGER.info("10010 url:{}", (Object)newUrl);
            HashMap<String, msg> requestParams = new HashMap<String, msg>();
            PackageElement packageElement = new PackageElement();
            packageElement.setElementId(cusParamsArr[1]);
            packageElement.setElementType(cusParamsArr[2]);
            packageElement.setPackageId(cusParamsArr[3]);
            productInfo product = new productInfo();
            product.setProductId(cusParamsArr[4]);
            product.setPackageElement(Arrays.asList(packageElement));
            msg msg2 = new msg();
            msg2.setOrdersId(request.getOrderId());
            msg2.setSerialNumber(params.get("uid"));
            msg2.setProductInfo(Arrays.asList(product));
            requestParams.put("msg", msg2);
            String requestJson = JSON.toJSONString(requestParams);
            HttpPost httpPost = new HttpPost(newUrl);
            httpPost.setEntity((HttpEntity)new StringEntity(requestJson, ContentType.APPLICATION_JSON));
            LOGGER.info("10010 body:{}", (Object)requestJson);
            request.setHttpUrl(url);
            HashMap<String, String> authParams = new HashMap<String, String>();
            authParams.put("msg", JSON.toJSONString((Object)msg2));
            request.setAuthParams(authParams);
            return httpPost;
        }
        LOGGER.info("10010 url:{}", (Object)newUrl);
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("acceptWay", this.siChuanLianTongConfig.getAcceptWay());
        requestParams.put("phoneNumber", params.get("uid"));
        requestParams.put("rightsId", params.get("params"));
        String requestJson = JSON.toJSONString(requestParams);
        HttpPost httpPost = new HttpPost(newUrl);
        httpPost.setEntity((HttpEntity)new StringEntity(requestJson, ContentType.APPLICATION_JSON));
        LOGGER.info("10010 body:{}", (Object)requestJson);
        request.setHttpUrl(url);
        request.setAuthParams(requestParams);
        return httpPost;
    }

    public String getVirtualResponse(String body) {
        LOGGER.info("\u56db\u5ddd\u8054\u901a,\u865a\u62df\u5546\u54c1\u5b9a\u5236 \u8fd4\u56de\u7ed3\u679c:{}", (Object)body);
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((String)body)) {
            throw new ThirdpatyException("\u56db\u5ddd\u8054\u901a,\u865a\u62df\u5546\u54c1\u5b9a\u5236\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        try {
            SiChuanLianTongResponse data = (SiChuanLianTongResponse)JSON.parseObject((String)body, SiChuanLianTongResponse.class);
            Boolean isOk = SUCCESS_CODE.equals(data.getBusiCode()) && SUCCESS_CODE.equals(data.getCode());
            map.put("status", isOk != false ? "success" : "fail");
            if (!isOk.booleanValue()) {
                LOGGER.info("\u56db\u5ddd\u8054\u901a,\u865a\u62df\u5546\u54c1\u5b9a\u5236 \u9519\u8bef\u8fd4\u56de:{}", (Object)body);
                map.put("errorMessage", data.getBusiDetail());
                map.put("code", data.getBusiCode());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u56db\u5ddd\u8054\u901a,\u865a\u62df\u5546\u54c1\u5b9a\u5236\uff0c\u7ed3\u679c\u89e3\u6790\u9519\u8bef:{}", (Object)body, (Object)e);
            map.put("status", "fail");
            map.put("errorMessage", "\u865a\u62df\u5546\u54c1\u5145\u503c\u63a5\u53e3\u54cd\u5e94\u89e3\u6790\u9519\u8bef");
        }
        return JSON.toJSONString(map);
    }

    static class msg {
        private String ordersId;
        private String serialNumber;
        private String changeType = "1";
        private String deductionTag = "1";
        private List<productInfo> productInfo;

        msg() {
        }

        public String getOrdersId() {
            return this.ordersId;
        }

        public void setOrdersId(String ordersId) {
            this.ordersId = ordersId;
        }

        public String getSerialNumber() {
            return this.serialNumber;
        }

        public void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public String getChangeType() {
            return this.changeType;
        }

        public void setChangeType(String changeType) {
            this.changeType = changeType;
        }

        public String getDeductionTag() {
            return this.deductionTag;
        }

        public void setDeductionTag(String deductionTag) {
            this.deductionTag = deductionTag;
        }

        public List<productInfo> getProductInfo() {
            return this.productInfo;
        }

        public void setProductInfo(List<productInfo> productInfo2) {
            this.productInfo = productInfo2;
        }
    }

    static class PackageElement {
        private String elementId;
        private String modType = "0";
        private String packageId;
        private String elementType;

        PackageElement() {
        }

        public String getElementId() {
            return this.elementId;
        }

        public void setElementId(String elementId) {
            this.elementId = elementId;
        }

        public String getModType() {
            return this.modType;
        }

        public void setModType(String modType) {
            this.modType = modType;
        }

        public String getPackageId() {
            return this.packageId;
        }

        public void setPackageId(String packageId) {
            this.packageId = packageId;
        }

        public String getElementType() {
            return this.elementType;
        }

        public void setElementType(String elementType) {
            this.elementType = elementType;
        }
    }

    static class productInfo {
        private String productId;
        private String productMode = "0";
        private String optType = "00";
        private List<PackageElement> packageElement;

        productInfo() {
        }

        public String getOptType() {
            return this.optType;
        }

        public void setOptType(String optType) {
            this.optType = optType;
        }

        public List<PackageElement> getPackageElement() {
            return this.packageElement;
        }

        public void setPackageElement(List<PackageElement> packageElement) {
            this.packageElement = packageElement;
        }

        public String getProductId() {
            return this.productId;
        }

        public void setProductId(String productId) {
            this.productId = productId;
        }

        public String getProductMode() {
            return this.productMode;
        }

        public void setProductMode(String productMode) {
            this.productMode = productMode;
        }
    }

    static class SiChuanLianTongResponse {
        private String code;
        private String detail;
        private String busiCode;
        private String busiDetail;

        SiChuanLianTongResponse() {
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getDetail() {
            return this.detail;
        }

        public void setDetail(String detail) {
            this.detail = detail;
        }

        public String getBusiCode() {
            return this.busiCode;
        }

        public void setBusiCode(String busiCode) {
            this.busiCode = busiCode;
        }

        public String getBusiDetail() {
            return this.busiDetail;
        }

        public void setBusiDetail(String busiDetail) {
            this.busiDetail = busiDetail;
        }
    }
}

