/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.constant.WuFangZhaiConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.dto.wufangzhai.WfzBaseResp;
import cn.com.duiba.dto.wufangzhai.WfzReq;
import cn.com.duiba.dto.wufangzhai.WfzTokenBean;
import cn.com.duiba.dto.wufangzhai.req.AwardIntegralReq;
import cn.com.duiba.dto.wufangzhai.req.CardQueryInfoReq;
import cn.com.duiba.dto.wufangzhai.req.ReduceIntegralReq;
import cn.com.duiba.dto.wufangzhai.req.SendCouponReq;
import cn.com.duiba.dto.wufangzhai.resp.AwardIntegralResp;
import cn.com.duiba.dto.wufangzhai.resp.CardQueryInfoResp;
import cn.com.duiba.dto.wufangzhai.resp.ReduceIntegralResp;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpUtils;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.redis.RedisAtomicClient;
import cn.com.duiba.wolf.redis.RedisLock;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WuFangZhaiApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(WuFangZhaiApi.class);
    private static final String VIRTUAL_CREDITS_PRE = "JF-";
    private static final String VIRTUAL_RECHARGE_PRE = "ZQ-";
    private static final String HTTP_HEADER_CONTENT_TYPE = "Content-Type";
    private static final String FORM_TYPE = "application/x-www-form-urlencoded";
    private static final String CACHE_TOKEN_KEY_FORMAT = "wuFangZhaiToken_%s_%s";
    private static final String LOCK_TOKEN_KEY_FORMAT = "wuFangZhaiLock_%s_%s";
    @Autowired
    private WuFangZhaiConfig wuFangZhaiConfig;
    @Resource(name="httpClient")
    private CloseableHttpClient httpClient;
    @Resource(name="redisTemplate")
    private RedisAtomicClient redisAtomicClient;
    @Resource(name="redisTemplate")
    private AdvancedCacheClient advancedCacheClient;

    public Boolean isWuFangZhai(Long appId) {
        Set<Long> appIds = this.wuFangZhaiConfig.getAppIds();
        if (null == appIds) {
            return false;
        }
        return appIds.contains(appId);
    }

    public HttpRequestBase getSubCreditsMessage(CreditsMessage message) {
        String url = message.getHttpUrl();
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        return this.getSubCreditsRequest(params, message.getAppId());
    }

    public HttpRequestBase getSubCreditsMessage(SubCreditsMsgWrapper message) {
        String url = message.getHttpUrl();
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        return this.getSubCreditsRequest(params, message.getSubCreditsMsg().getAppId().toString());
    }

    public HttpRequestBase getAddCreditsMessage(CreditsMessageDto message) {
        String httpUrl = message.getHttpUrl();
        String paramStr = httpUrl.substring(httpUrl.indexOf(63) + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramStr);
        return this.getAddCreditsRequest(params, message.getAppId());
    }

    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        params.put("consumerId", request.getConsumerId());
        String goodsNum = params.get("params");
        request.setAuthParams(params);
        if (goodsNum.startsWith(VIRTUAL_CREDITS_PRE)) {
            params.put("credits", goodsNum.replace(VIRTUAL_CREDITS_PRE, ""));
            return this.getAddCreditsRequest(params, request.getAppId());
        }
        if (goodsNum.startsWith(VIRTUAL_RECHARGE_PRE)) {
            params.put("batchNo", goodsNum.replace(VIRTUAL_RECHARGE_PRE, ""));
            return this.getRechargeRequest(params, request.getAppId());
        }
        return AssembleTool.assembleRequest(request.getHttpUrl(), request.getAuthParams());
    }

    private HttpRequestBase getRechargeRequest(Map<String, String> params, String appId) {
        WfzTokenBean wfzTokenBean = this.getToken(appId);
        String mobile = this.getMobile(params.get("uid"), appId);
        String openId = params.get("transfer");
        HttpPost httpPost = new HttpPost(WuFangZhaiConfig.Api.COUPON_SEND_COUPON.getApiAbsolutePath(this.wuFangZhaiConfig));
        SendCouponReq sendCouponReq = new SendCouponReq();
        sendCouponReq.setBrandId(wfzTokenBean.getBrandId());
        sendCouponReq.setMobile(mobile);
        sendCouponReq.setBatchNo(Integer.valueOf(params.get("batchNo")));
        sendCouponReq.setOpenId(openId);
        WfzReq req = new WfzReq();
        req.setAccessToken(wfzTokenBean.getAccessToken());
        req.setCiphertext(JSON.toJSONString((Object)sendCouponReq));
        StringEntity stringEntity = new StringEntity(JSON.toJSONString((Object)req), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)stringEntity);
        return httpPost;
    }

    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams, Long appId) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)body)) {
            map.put("status", "fail");
            map.put("errorMessage", "\u4e94\u82b3\u658b\u65b0\u589e/\u6263\u51cf\u79ef\u5206\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            return JSON.toJSONString(map);
        }
        try {
            if (addCredits.booleanValue()) {
                this.parseAwardIntegralResp(body, map);
            } else {
                this.parseReduceIntegralResp(body, map);
            }
            map.put("credits", this.getCredits(authParams.get("uid"), appId.toString()));
        }
        catch (Exception e) {
            LOGGER.error("\u4e94\u82b3\u658b\u65b0\u589e/\u6263\u51cf\u79ef\u5206\u63a5\u53e3\u89e3\u6790\u9519\u8bef:{}--\u662f\u5426\u65b0\u589e:{}", new Object[]{body, addCredits, e});
            map.put("status", "fail");
            map.put("errorMessage", "\u4e94\u82b3\u658b\u65b0\u589e/\u6263\u51cf\u79ef\u5206\u89e3\u6790\u7ed3\u679c\u9519\u8bef");
        }
        return JSONObject.toJSONString(map);
    }

    public void parseAwardIntegralResp(String body, Map<String, String> map) {
        WfzBaseResp wfzResp = (WfzBaseResp)JSON.parseObject((String)body, (TypeReference)new TypeReference<WfzBaseResp<AwardIntegralResp>>(new Type[]{AwardIntegralResp.class}){}, (Feature[])new Feature[0]);
        if (Objects.equals(wfzResp.getCode(), 0)) {
            map.put("status", "ok");
            map.put("bizId", ((AwardIntegralResp)wfzResp.getData()).getVoucher().toString());
        } else {
            map.put("status", "fail");
            String errorMsg = wfzResp.getMessage();
            if (StringUtils.length((CharSequence)errorMsg) > 255) {
                errorMsg = errorMsg.substring(0, 255);
            }
            map.put("errorMessage", errorMsg);
        }
    }

    public void parseReduceIntegralResp(String body, Map<String, String> map) {
        WfzBaseResp wfzResp = (WfzBaseResp)JSON.parseObject((String)body, (TypeReference)new TypeReference<WfzBaseResp<ReduceIntegralResp>>(new Type[]{ReduceIntegralResp.class}){}, (Feature[])new Feature[0]);
        if (Objects.equals(wfzResp.getCode(), 0)) {
            map.put("status", "ok");
            map.put("bizId", ((ReduceIntegralResp)wfzResp.getData()).getVoucher().toString());
        } else {
            map.put("status", "fail");
            String errorMsg = wfzResp.getMessage();
            if (StringUtils.length((CharSequence)errorMsg) > 255) {
                errorMsg = errorMsg.substring(0, 255);
            }
            map.put("errorMessage", errorMsg);
        }
    }

    public String getVirtualResponse(SupplierRequest request, String body) {
        Map<String, String> params = request.getAuthParams();
        String goodsNum = params.get("params");
        String uid = params.get("uid");
        if (goodsNum.startsWith(VIRTUAL_CREDITS_PRE)) {
            return this.getVirtualCreditsResponse(body, uid, request.getAppId());
        }
        if (goodsNum.startsWith(VIRTUAL_RECHARGE_PRE)) {
            return this.getVirtualRechargeResponse(body, uid, request.getAppId());
        }
        return body;
    }

    private String getVirtualRechargeResponse(String body, String uid, String appId) {
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)body)) {
            throw new ThirdpatyException("\u4e94\u82b3\u658b\uff0c\u5145\u503c\u5546\u54c1\u5b9a\u5236\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        try {
            WfzBaseResp wfzResp = (WfzBaseResp)JSON.parseObject((String)body, WfzBaseResp.class);
            if (Objects.equals(wfzResp.getCode(), 0)) {
                duibaDoc.put("status", "success");
                duibaDoc.put("supplierBizId", "");
            } else {
                duibaDoc.put("status", "fail");
                String errorMsg = wfzResp.getMessage();
                if (StringUtils.length((CharSequence)errorMsg) > 255) {
                    errorMsg = errorMsg.substring(0, 255);
                }
                duibaDoc.put("errorMessage", errorMsg);
            }
            duibaDoc.put("credits", this.getCredits(uid, appId));
        }
        catch (Exception e) {
            LOGGER.error("\u4e94\u82b3\u658b\uff0c\u5145\u503c\u5546\u54c1\u5b9a\u5236\uff0c\u7ed3\u679c\u89e3\u6790\u9519\u8bef:{}", (Object)body, (Object)e);
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", "\u6ce8\u5238\u63a5\u53e3\u54cd\u5e94\u89e3\u6790\u9519\u8bef");
        }
        return JSON.toJSONString(duibaDoc);
    }

    private String getVirtualCreditsResponse(String body, String uid, String appId) {
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)body)) {
            throw new ThirdpatyException("\u4e94\u82b3\u658b\uff0c\u5145\u503c\u5546\u54c1\u5b9a\u5236\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        try {
            WfzBaseResp wfzResp = (WfzBaseResp)JSON.parseObject((String)body, (TypeReference)new TypeReference<WfzBaseResp<AwardIntegralResp>>(new Type[]{AwardIntegralResp.class}){}, (Feature[])new Feature[0]);
            if (Objects.equals(wfzResp.getCode(), 0)) {
                duibaDoc.put("status", "success");
                duibaDoc.put("supplierBizId", ((AwardIntegralResp)wfzResp.getData()).getVoucher().toString());
            } else {
                duibaDoc.put("status", "fail");
                String errorMsg = wfzResp.getMessage();
                if (StringUtils.length((CharSequence)errorMsg) > 255) {
                    errorMsg = errorMsg.substring(0, 255);
                }
                duibaDoc.put("errorMessage", errorMsg);
            }
            duibaDoc.put("credits", this.getCredits(uid, appId));
        }
        catch (Exception e) {
            LOGGER.error("\u4e94\u82b3\u658b\uff0c\u5145\u503c\u5546\u54c1\u5b9a\u5236\uff0c\u7ed3\u679c\u89e3\u6790\u9519\u8bef:{}", (Object)body, (Object)e);
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", "\u79ef\u5206\u5151\u6362\u54cd\u5e94\u89e3\u6790\u9519\u8bef");
        }
        return JSON.toJSONString(duibaDoc);
    }

    private HttpPost getSubCreditsRequest(Map<String, String> params, String appId) {
        WfzTokenBean wfzTokenBean = this.getToken(appId);
        HttpPost httpPost = new HttpPost(WuFangZhaiConfig.Api.TRADE_REDUCE_INTEGRAL.getApiAbsolutePath(this.wuFangZhaiConfig));
        ReduceIntegralReq reduceIntegralReq = new ReduceIntegralReq();
        reduceIntegralReq.setBrandId(wfzTokenBean.getBrandId().longValue());
        reduceIntegralReq.setCardNo(params.get("uid"));
        reduceIntegralReq.setMerchantNo(wfzTokenBean.getMerchantNo());
        reduceIntegralReq.setIntegralValue(new BigDecimal(params.get("credits")));
        reduceIntegralReq.setCashierSerial(params.get("orderNum"));
        reduceIntegralReq.setRemark(params.get("description"));
        reduceIntegralReq.setMobile("");
        WfzReq req = new WfzReq();
        req.setAccessToken(wfzTokenBean.getAccessToken());
        req.setCiphertext(JSON.toJSONString((Object)reduceIntegralReq));
        StringEntity stringEntity = new StringEntity(JSON.toJSONString((Object)req), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)stringEntity);
        return httpPost;
    }

    private HttpPost getAddCreditsRequest(Map<String, String> params, String appId) {
        WfzTokenBean wfzTokenBean = this.getToken(appId);
        HttpPost httpPost = new HttpPost(WuFangZhaiConfig.Api.TRADE_AWARD_INTEGRAL.getApiAbsolutePath(this.wuFangZhaiConfig));
        AwardIntegralReq awardIntegralReq = new AwardIntegralReq();
        awardIntegralReq.setBrandId(wfzTokenBean.getBrandId().longValue());
        awardIntegralReq.setCardNo(params.get("uid"));
        awardIntegralReq.setMerchantNo(wfzTokenBean.getMerchantNo());
        awardIntegralReq.setIntegralValue(new BigDecimal(params.get("credits")));
        awardIntegralReq.setCashierSerial(params.get("orderNum"));
        awardIntegralReq.setRemark(params.get("description"));
        WfzReq req = new WfzReq();
        req.setAccessToken(wfzTokenBean.getAccessToken());
        req.setCiphertext(JSON.toJSONString((Object)awardIntegralReq));
        StringEntity stringEntity = new StringEntity(JSON.toJSONString((Object)req), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)stringEntity);
        return httpPost;
    }

    private String getCredits(String uid, String appId) {
        WfzTokenBean wfzTokenBean = this.getToken(appId);
        CardQueryInfoReq req = new CardQueryInfoReq();
        req.setBrandId(wfzTokenBean.getBrandId());
        req.setMerchantNo(wfzTokenBean.getMerchantNo());
        req.setQueryStr(uid);
        WfzReq wfzReq = new WfzReq();
        wfzReq.setAccessToken(wfzTokenBean.getAccessToken());
        wfzReq.setCiphertext(JSON.toJSONString((Object)req));
        String url = WuFangZhaiConfig.Api.CARD_QUERY_INFO.getApiAbsolutePath(this.wuFangZhaiConfig);
        HttpPost httpPost = new HttpPost(url);
        StringEntity stringEntity = new StringEntity(JSON.toJSONString((Object)wfzReq), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)stringEntity);
        String resp = "";
        HttpUtils.resetTimeOut((HttpRequestBase)httpPost);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            HttpEntity entity = response.getEntity();
            resp = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            LOGGER.warn("\u4e94\u82b3\u658b\uff0c\u67e5\u8be2\u79ef\u5206\uff0c\u53d1\u9001post\u8bf7\u6c42\u5f02\u5e38\uff0cuid={}\uff0curl={},req={}", new Object[]{uid, url, JSON.toJSONString((Object)wfzReq), e});
            return null;
        }
        WfzBaseResp result = (WfzBaseResp)JSON.parseObject((String)resp, (TypeReference)new TypeReference<WfzBaseResp<CardQueryInfoResp>>(new Type[]{CardQueryInfoResp.class}){}, (Feature[])new Feature[0]);
        if (Objects.equals(result.getCode(), 0)) {
            long credits = ((CardQueryInfoResp)result.getData()).getCard().getIntegralAvailable().longValue();
            return String.valueOf(credits);
        }
        LOGGER.warn("\u4e94\u82b3\u658b\uff0c\u67e5\u8be2\u79ef\u5206\uff0c\u53d1\u9001post\u8bf7\u6c42\u5931\u8d25\uff0cuid={}\uff0cresp={}", (Object)uid, (Object)resp);
        return null;
    }

    private String getMobile(String uid, String appId) {
        WfzTokenBean wfzTokenBean = this.getToken(appId);
        CardQueryInfoReq req = new CardQueryInfoReq();
        req.setBrandId(wfzTokenBean.getBrandId());
        req.setMerchantNo(wfzTokenBean.getMerchantNo());
        req.setQueryStr(uid);
        WfzReq wfzReq = new WfzReq();
        wfzReq.setAccessToken(wfzTokenBean.getAccessToken());
        wfzReq.setCiphertext(JSON.toJSONString((Object)req));
        String url = WuFangZhaiConfig.Api.CARD_QUERY_INFO.getApiAbsolutePath(this.wuFangZhaiConfig);
        HttpPost httpPost = new HttpPost(url);
        StringEntity stringEntity = new StringEntity(JSON.toJSONString((Object)wfzReq), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)stringEntity);
        String resp = "";
        HttpUtils.resetTimeOut((HttpRequestBase)httpPost);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            HttpEntity entity = response.getEntity();
            resp = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            LOGGER.warn("\u4e94\u82b3\u658b\uff0c\u67e5\u8be2\u624b\u673a\u53f7\uff0c\u53d1\u9001post\u8bf7\u6c42\u5f02\u5e38\uff0cuid={}\uff0curl={},req={}", new Object[]{uid, url, JSON.toJSONString((Object)wfzReq), e});
            return null;
        }
        WfzBaseResp result = (WfzBaseResp)JSON.parseObject((String)resp, (TypeReference)new TypeReference<WfzBaseResp<CardQueryInfoResp>>(new Type[]{CardQueryInfoResp.class}){}, (Feature[])new Feature[0]);
        if (Objects.equals(result.getCode(), 0)) {
            return ((CardQueryInfoResp)result.getData()).getMembership().getMobile();
        }
        LOGGER.warn("\u4e94\u82b3\u658b\uff0c\u67e5\u8be2\u624b\u673a\u53f7\uff0c\u53d1\u9001post\u8bf7\u6c42\u5931\u8d25\uff0cuid={}\uff0cresp={}", (Object)uid, (Object)resp);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WfzTokenBean getToken(String appId) {
        String password;
        String username;
        if (StringUtils.isBlank((CharSequence)appId)) {
            username = this.wuFangZhaiConfig.getUsername();
            password = this.wuFangZhaiConfig.getPassword();
        } else {
            username = this.wuFangZhaiConfig.getConfigByAppIdIfNullThrowEx(appId).getUsername();
            password = this.wuFangZhaiConfig.getConfigByAppIdIfNullThrowEx(appId).getPassword();
        }
        String cacheKey = String.format(CACHE_TOKEN_KEY_FORMAT, this.wuFangZhaiConfig.getClientId(), username);
        String cacheToken = (String)this.advancedCacheClient.get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)cacheToken)) {
            WfzTokenBean wfzTokenBean = (WfzTokenBean)JSON.parseObject((String)cacheToken, WfzTokenBean.class);
            return wfzTokenBean;
        }
        String lockKey = String.format(LOCK_TOKEN_KEY_FORMAT, this.wuFangZhaiConfig.getClientId(), username);
        RedisLock lock = this.redisAtomicClient.getLock(lockKey, 2L);
        if (lock == null) {
            throw new ThirdpatyException("\u4e94\u82b3\u658b\uff0c\u8bf7\u6c42token\uff0c\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25");
        }
        try {
            Serializable serializable;
            String url = WuFangZhaiConfig.Api.GET_TOKEN.getApiAbsolutePath(this.wuFangZhaiConfig);
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader(HTTP_HEADER_CONTENT_TYPE, FORM_TYPE);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("client_id", this.wuFangZhaiConfig.getClientId());
            map.put("client_secret", this.wuFangZhaiConfig.getClientSecret());
            map.put("grant_type", this.wuFangZhaiConfig.getGrantType());
            map.put("scope", this.wuFangZhaiConfig.getScope());
            map.put("username", username);
            map.put("password", password);
            LOGGER.info("\u4e94\u82b3\u658b\uff0c\u8bf7\u6c42token\u5165\u53c2 param:{}", (Object)JSON.toJSONString(map));
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            for (Map.Entry entry : map.entrySet()) {
                BasicNameValuePair nameValuePair = new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue());
                params.add(nameValuePair);
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, Charset.forName("utf-8")));
            String resp = null;
            HttpUtils.resetTimeOut((HttpRequestBase)httpPost);
            try {
                serializable = null;
                try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
                    HttpEntity entity = response.getEntity();
                    resp = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                }
                catch (Throwable throwable) {
                    serializable = throwable;
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.warn("\u4e94\u82b3\u658b\uff0c\u8bf7\u6c42token\uff0c\u5f02\u5e38\uff0c\u8bf7\u6c42\u53c2\u6570params={}", (Object)JSON.toJSONString(map), (Object)e);
                throw new ThirdpatyException("\u4e94\u82b3\u658b\uff0c\u8bf7\u6c42token\uff0c\u5f02\u5e38");
            }
            if (StringUtils.isBlank((CharSequence)resp)) {
                throw new ThirdpatyException("\u4e94\u82b3\u658b\uff0c\u8bf7\u6c42token\uff0c\u5931\u8d25");
            }
            WfzTokenBean wfzTokenBean = (WfzTokenBean)JSON.parseObject((String)resp, WfzTokenBean.class);
            LOGGER.info("\u4e94\u82b3\u658b\uff0c\u8bf7\u6c42token\u54cd\u5e94 response:{}", (Object)JSON.toJSONString((Object)wfzTokenBean));
            this.advancedCacheClient.set(cacheKey, (Object)JSON.toJSONString((Object)wfzTokenBean), 1, TimeUnit.HOURS);
            serializable = wfzTokenBean;
            return serializable;
        }
        finally {
            lock.unlock();
        }
    }
}

