/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.nongzonghang;

import cn.com.duiba.biz.credits.nongzonghang.FuLuApi;
import cn.com.duiba.biz.credits.nongzonghang.RuixinApi;
import cn.com.duiba.constant.nongzonghang.NongZongHangConfig;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.domain.SupplierResponse;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NongZongHangApi {
    @Autowired
    private NongZongHangConfig nongZongHangConfig;
    @Autowired
    private RuixinApi ruixinApi;
    @Autowired
    private FuLuApi fuLuApi;

    public Boolean isNongZongHang(Long appId) {
        Set<Long> appIds = this.nongZongHangConfig.getAppIds();
        if (CollectionUtils.isEmpty(appIds)) {
            return false;
        }
        return appIds.contains(appId);
    }

    public SupplierRequest getVirtualRequest(SupplierRequest request) {
        if (this.ruixinApi.isRuiXin4NongZongHang(request).booleanValue()) {
            return this.ruixinApi.getVirtualRequest(request);
        }
        return request;
    }

    public HttpRequestBase getVirtualRequestHttp(SupplierRequest message) {
        if (this.fuLuApi.isFuLu4NongZongHang(message).booleanValue()) {
            return this.fuLuApi.getVirtualRequest(message);
        }
        return new HttpGet(message.getHttpUrl());
    }

    public String getVirtualResponse(SupplierRequest message, String body, String callbackTopic, String msgTag, String msgKey) {
        if (this.ruixinApi.isRuiXin4NongZongHang(message).booleanValue()) {
            return this.ruixinApi.getVirtualResponse(message, body);
        }
        if (this.fuLuApi.isFuLu4NongZongHang(message).booleanValue()) {
            return this.fuLuApi.getVirtualResponse(message, body, callbackTopic, msgTag, msgKey);
        }
        return body;
    }

    public boolean customFinallyBlock(SupplierRequest message, SupplierResponse response) {
        if (this.fuLuApi.isFuLu4NongZongHang(message).booleanValue()) {
            return this.fuLuApi.customFinallyBlock(response);
        }
        return true;
    }
}

