/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.nongzonghang;

import cn.com.duiba.constant.nongzonghang.RuixinConfig;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.AssembleTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.Charset;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RuixinApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuixinApi.class);
    @Autowired
    private RuixinConfig ruixinConfig;
    private static final int KEY_BIT_SIZE = 128;
    private static final int BIT_SIZE = 8;
    private static final Charset CHAR_SET = Charset.forName("utf-8");
    private static final String ALGORITHM = "AES/ECB/PKCS7Padding";
    public static final String API_KEY = "aid";
    public static final String SIGN_KEY = "sign";
    private static final int BLOCK_LEN = 4;
    private static final int OX_FF = 255;
    private static final int BIT = 8;

    public Boolean isRuiXin4NongZongHang(SupplierRequest request) {
        String url = request.getHttpUrl();
        String params = url.substring(url.indexOf(63) + 1, url.length());
        Map<String, String> creditMap = AssembleTool.getUrlParams(params);
        String goodsNum = creditMap.get("params");
        Set<String> goodsNos = this.ruixinConfig.getGoodsNos();
        if (StringUtils.isNotBlank((CharSequence)goodsNum) && CollectionUtils.isNotEmpty(goodsNos) && goodsNos.contains(goodsNum)) {
            return true;
        }
        if (request.getHttpUrl().startsWith(this.ruixinConfig.getAppUrl())) {
            return true;
        }
        return false;
    }

    public SupplierRequest getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String params = url.substring(url.indexOf(63) + 1, url.length());
        Map<String, String> crediMap = AssembleTool.getUrlParams(params);
        String goodsNum = crediMap.get("params");
        TreeMap<String, String> map = this.buildParams(crediMap, goodsNum);
        String requestUrl = AssembleTool.assembleUrl(this.ruixinConfig.getAppUrl(), map);
        request.setHttpUrl(requestUrl);
        return request;
    }

    private TreeMap<String, String> buildParams(Map<String, String> crediMap, String goodsNum) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("cid", this.ruixinConfig.getCid());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("accountCode", this.ruixinConfig.getAccountCode());
        param.put("accountSecretkey", this.ruixinConfig.getAccountSecretkey());
        param.put("couponBatchNo", goodsNum);
        param.put("ticketNums", 1);
        param.put("mobile", crediMap.get("account"));
        param.put("serialNumber", crediMap.get("orderNum"));
        String q = JSON.toJSONString(param);
        q = RuixinApi.encrypt(q, this.ruixinConfig.getAppKey());
        params.put("q", q);
        String sign = RuixinApi.doMD5Sign(RuixinApi.getSignStr(params) + this.ruixinConfig.getAppKey());
        params.put(SIGN_KEY, sign);
        return params;
    }

    public String getVirtualResponse(SupplierRequest request, String body) {
        String url = request.getHttpUrl();
        if (!url.startsWith(this.ruixinConfig.getAppUrl())) {
            return body;
        }
        String json = RuixinApi.decrypt(body, this.ruixinConfig.getAppKey());
        JSONObject jsonObject = null;
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        try {
            jsonObject = JSON.parseObject((String)json);
        }
        catch (Exception e) {
            LOGGER.error("\u745e\u8f9b\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\u5f02\u5e38:", (Throwable)e);
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", "\u51fa\u4e86\u70b9\u5c0f\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u5904\u7406");
            return JSON.toJSONString(duibaDoc);
        }
        Integer code = jsonObject.getInteger("code");
        if (code == 1) {
            duibaDoc.put("status", "success");
        } else {
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", "\u51fa\u4e86\u70b9\u5c0f\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u5904\u7406");
            LOGGER.info("\u745e\u8f9b\u63a5\u53e3\u8fd4\u56dejson:{}", (Object)json);
        }
        return JSON.toJSONString(duibaDoc);
    }

    public static String encrypt(String target, String key) {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, RuixinApi.initKey(key));
            byte[] encryptResult = cipher.doFinal(target.getBytes(CHAR_SET));
            String unsafeStr = new String(Base64.encodeBase64((byte[])encryptResult, (boolean)false), CHAR_SET);
            return unsafeStr.replace('+', '-').replace('/', '_');
        }
        catch (Exception e) {
            throw new RuntimeException("\u654f\u611f\u6570\u636e\u52a0\u5bc6\u9519\u8bef", e);
        }
    }

    public static String decrypt(String target, String key) {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, RuixinApi.initKey(key));
            String unsafeStr = target.replace('-', '+').replace('_', '/');
            byte[] decryptResult = cipher.doFinal(Base64.decodeBase64((byte[])unsafeStr.getBytes(CHAR_SET)));
            return new String(decryptResult, CHAR_SET);
        }
        catch (Exception e) {
            throw new RuntimeException("\u654f\u611f\u6570\u636e\u89e3\u5bc6\u9519\u8bef", e);
        }
    }

    private static SecretKeySpec initKey(String originalKey) {
        byte[] keys = originalKey.getBytes(CHAR_SET);
        byte[] bytes = new byte[16];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = keys.length > i ? keys[i] : (byte)0;
        }
        return new SecretKeySpec(bytes, "AES");
    }

    public static String getSignStr(SortedMap<String, String> signMap) {
        StringBuilder sb = new StringBuilder();
        for (String key : signMap.keySet()) {
            if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)signMap.get(key))) || key.equals(SIGN_KEY) || key.equals(API_KEY)) continue;
            String value = (String)signMap.get(key);
            sb.append(key).append("=").append(value).append(";");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static String doMD5Sign(String targetStr) {
        byte[] md5Result = DigestUtils.md5((byte[])targetStr.getBytes(Charsets.UTF_8));
        if (md5Result.length != 16) {
            throw new IllegalArgumentException("MD5\u52a0\u5bc6\u7ed3\u679c\u5b57\u8282\u6570\u7ec4\u9519\u8bef");
        }
        Integer first = Math.abs(RuixinApi.bytesToInt(md5Result, 0));
        Integer second = Math.abs(RuixinApi.bytesToInt(md5Result, 4));
        Integer third = Math.abs(RuixinApi.bytesToInt(md5Result, 8));
        Integer fourth = Math.abs(RuixinApi.bytesToInt(md5Result, 12));
        return first.toString() + second.toString() + third.toString() + fourth.toString();
    }

    private static int bytesToInt(byte[] src, int offset) {
        int value = (src[offset] & 0xFF) << 24 | (src[offset + 1] & 0xFF) << 16 | (src[offset + 2] & 0xFF) << 8 | src[offset + 3] & 0xFF;
        return value;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

