/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.constant.CgwsConfig;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import cn.com.duiba.tool.AssembleTool;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CgwsApiStrategy
implements ApiStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(CgwsApiStrategy.class);
    @Autowired
    private CgwsConfig cgwsConfig;

    @Override
    public boolean isCustomCrecord(HttpRequestMessageDto dto) {
        String orderNum = (String)dto.getHttpParams().get("orderNum");
        boolean result = StringUtils.isNotBlank((CharSequence)orderNum);
        return result;
    }

    @Override
    public HttpRequestBase getCrecordNotify(HttpRequestMessageDto msg2, AppDO app) {
        LOGGER.info("\u957f\u57ce\u8bc1\u5238\u83b7\u53d6\u5151\u6362\u8bb0\u5f55\u540c\u6b65http\u5305\u88c5\u7c7b :{}", (Object)JSON.toJSONString((Object)msg2));
        HashMap json = Maps.newHashMap();
        json.put("orderNum", msg2.getHttpParams().get("orderNum"));
        json.put("title", msg2.getHttpParams().get("title"));
        json.put("startDay", msg2.getHttpParams().get("startDay"));
        json.put("endDay", msg2.getHttpParams().get("endDay"));
        json.put("uid", msg2.getHttpParams().get("uid"));
        json.put("recordId", msg2.getHttpParams().get("recordId"));
        json.put("recordDetailUrl", msg2.getHttpParams().get("recordDetailUrl"));
        json.put("orderType", msg2.getHttpParams().get("orderType"));
        json.put("itemType", msg2.getHttpParams().get("itemType"));
        json.put("cardNum", msg2.getHttpParams().get("cardNum"));
        json.put("cardPwd", msg2.getHttpParams().get("cardPwd"));
        json.put("credits", msg2.getHttpParams().get("credits"));
        json.put("logoUrl", msg2.getHttpParams().get("logoUrl"));
        json.put("timestamp", msg2.getHttpParams().get("timestamp"));
        json.put("appKey", msg2.getHttpParams().get("appKey"));
        json.put("appSecret", msg2.getHttpParams().get("appSecret"));
        String sign = SignTool.sign((Map)json);
        json.put("sign", sign);
        json.remove("appSecret");
        String url = AssembleTool.assembleUrl(this.cgwsConfig.getUrl(), json);
        HttpGet httpGet = new HttpGet(url);
        LOGGER.info("\u957f\u57ce\u8bc1\u5238\u5151\u6362\u8bb0\u5f55\u540c\u6b65url:{}", (Object)url);
        return httpGet;
    }

    @Override
    public String getCrecordResponse(String body) {
        LOGGER.info("\u957f\u57ce\u8bc1\u5238\u5b9a\u5236\u540c\u6b65\u5151\u6362\u8bb0\u5f55\u54cd\u5e94, resp={}", (Object)body);
        return this.getResponseNotify(body);
    }

    @Override
    public String getResponseNotify(String body) {
        return body;
    }
}

