/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.constant.JingDongConfig;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JingDongApiStrategy
implements ApiStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(JingDongApiStrategy.class);
    @Autowired
    private JingDongConfig jingDongConfig;
    @Resource(name="httpClient")
    @CanAccessInsideNetwork
    private CloseableHttpClient httpClient;

    public Boolean isJingDong(Long appId) {
        Set<Long> appIds = this.jingDongConfig.getConfigMap().keySet();
        if (CollectionUtils.isEmpty(appIds)) {
            return false;
        }
        return appIds.contains(appId);
    }

    @Override
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        String url = message.getHttpUrl();
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        Long appId = message.getSubCreditsMsg().getAppId();
        JingDongConfig.JingDongConfigBean jingDongConfigBean = this.jingDongConfig.getConfigMap().get(appId);
        Map authParams = message.getSubCreditsMsg().getAuthParams();
        if (MapUtils.isEmpty((Map)authParams)) {
            authParams = Maps.newHashMap();
        }
        authParams.put("uid", params.get("uid"));
        authParams.put("appId", appId + "");
        authParams.put("orderNum", params.get("orderNum"));
        authParams.put("appKey", params.get("appKey"));
        authParams.put("appSecret", message.getSubCreditsMsg().getAppSecret());
        authParams.put("shopId", jingDongConfigBean.getShopId() + "");
        authParams.put("venderId", jingDongConfigBean.getVenderId() + "");
        message.getSubCreditsMsg().setAuthParams(authParams);
        HttpPost httpPost = new HttpPost(JingDongConfig.Api.CONSUMER_POINTS.getApiAbsolutePath(this.jingDongConfig));
        HashMap map = Maps.newHashMap();
        map.put("businessId", params.get("orderNum"));
        Integer credits = Integer.valueOf(params.get("credits"));
        map.put("points", -credits.intValue() + "");
        map.put("desc", params.get("description"));
        map.put("uid", params.get("uid"));
        map.put("shopId", jingDongConfigBean.getShopId() + "");
        map.put("venderId", jingDongConfigBean.getVenderId() + "");
        this.addSign(params.get("appKey"), message.getSubCreditsMsg().getAppSecret(), map);
        StringEntity stringEntity = new StringEntity(JSON.toJSONString((Object)map), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)stringEntity);
        LOGGER.info("\u4eac\u4e1c\u51cf\u79ef\u5206\uff0creq={}", (Object)JSON.toJSONString((Object)map));
        return httpPost;
    }

    private void addSign(String appKey, String appSecret, Map<String, String> paramMap) {
        paramMap.put("appKey", appKey);
        paramMap.put("appSecret", appSecret);
        if (paramMap.get("timestamp") == null) {
            paramMap.put("timestamp", String.valueOf(System.currentTimeMillis()));
        }
        String sign = SignTool.sign(paramMap);
        paramMap.put("sign", sign);
        paramMap.remove("appSecret");
    }

    @Override
    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {
        if (addCredits.booleanValue()) {
            LOGGER.info("\u4eac\u4e1c\u52a0\u79ef\u5206\uff0cresp={}", (Object)body);
        } else {
            LOGGER.info("\u4eac\u4e1c\u51cf\u79ef\u5206\uff0cresp={}", (Object)body);
        }
        HashMap map = Maps.newHashMap();
        if (StringUtils.isBlank((CharSequence)body)) {
            map.put("status", "fail");
            map.put("errorMessage", "\u4eac\u4e1c\u65b0\u589e/\u6263\u51cf\u79ef\u5206\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            return JSON.toJSONString((Object)map);
        }
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)body);
            Boolean success = jsonObject.getBoolean("data");
            String desc = jsonObject.getString("desc");
            if (success.booleanValue()) {
                map.put("status", "ok");
                map.put("bizId", authParams.get("orderNum"));
                map.put("credits", String.valueOf(this.getCredits(authParams.get("uid"), authParams.get("venderId"), authParams.get("shopId"), authParams.get("appKey"), authParams.get("appSecret"))));
            } else {
                map.put("status", "fail");
                String errorMsg = desc;
                if (StringUtils.isBlank((CharSequence)errorMsg)) {
                    errorMsg = "\u79ef\u5206\u4e0d\u8db3";
                }
                if (StringUtils.length((CharSequence)errorMsg) > 255) {
                    errorMsg = errorMsg.substring(0, 255);
                }
                map.put("errorMessage", errorMsg);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4eac\u4e1c\u65b0\u589e/\u6263\u51cf\u79ef\u5206\u63a5\u53e3\u89e3\u6790\u9519\u8bef:{}--\u662f\u5426\u65b0\u589e:{}", new Object[]{body, addCredits, e});
            map.put("status", "fail");
            map.put("errorMessage", "\u4eac\u4e1c\u65b0\u589e/\u6263\u51cf\u79ef\u5206\u89e3\u6790\u7ed3\u679c\u9519\u8bef");
        }
        LOGGER.info("\u4eac\u4e1c\u52a0\u51cf\u79ef\u5206\u5b9a\u5236\u8fd4\u56de\uff0cmap={}", (Object)JSON.toJSONString((Object)map));
        return JSONObject.toJSONString((Object)map);
    }

    @Override
    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        return null;
    }

    @Override
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record) {
        return null;
    }

    public Long getCredits(String uid, String venderId, String shopId, String appkey, String appSecret) {
        String resp;
        String url = JingDongConfig.Api.GET_CUSTOMER_POINTS.getApiAbsolutePath(this.jingDongConfig);
        HashMap params = Maps.newHashMap();
        params.put("uid", uid);
        params.put("venderId", venderId);
        params.put("shopId", shopId);
        this.addSign(appkey, appSecret, params);
        LOGGER.info("\u4eac\u4e1c\u67e5\u8be2\u79ef\u5206\uff0creq={}", (Object)JSON.toJSONString((Object)params));
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)params), ContentType.APPLICATION_JSON));
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            HttpEntity entity = response.getEntity();
            resp = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            LOGGER.warn("\u4eac\u4e1c\uff0c\u67e5\u8be2\u79ef\u5206\uff0c\u5f02\u5e38\uff0curl={}", (Object)url, (Object)e);
            throw new ThirdpatyException("\u4eac\u4e1c\uff0c\u67e5\u8be2\u79ef\u5206\uff0c\u5f02\u5e38");
        }
        LOGGER.info("\u4eac\u4e1c\u67e5\u8be2\u79ef\u5206\uff0cresp={}", (Object)resp);
        if (StringUtils.isBlank((CharSequence)resp)) {
            throw new ThirdpatyException("\u4eac\u4e1c\u67e5\u8be2\u79ef\u5206\u5931\u8d25");
        }
        Boolean flag = JSON.parseObject((String)resp).getBoolean("success");
        if (!BooleanUtils.isTrue((Boolean)flag)) {
            throw new ThirdpatyException("\u4eac\u4e1c\u67e5\u8be2\u79ef\u5206\u5931\u8d25");
        }
        Long credits = JSON.parseObject((String)resp).getLong("data");
        if (credits == null) {
            throw new ThirdpatyException("\u4eac\u4e1c\u67e5\u8be2\u79ef\u5206\u5931\u8d25");
        }
        return credits;
    }
}

