/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.api.enums.phapp.PhAppSerialNoEnum;
import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.constant.PuhuiConfig;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.puhui.AESEncodeUtil;
import cn.com.duiba.tool.puhui.PuhuiUtils;
import cn.com.duiba.wolf.redis.RedisAtomicClient;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.duiba.wolf.utils.UrlUtils2;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PuhuiApiStrategy
implements ApiStrategy {
    private static final long SUCCESS_CODE = 20000L;
    private static final long TEN_MILLION = 10000000L;
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final String DEFAULT_CHARSET = "UTF-8";
    @Resource
    private PuhuiConfig puhuiConfig;
    @Resource(name="redisTemplate")
    private RedisAtomicClient redisAtomicClient;
    private final RequestConfig config = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(5000).setConnectionRequestTimeout(1000).build();

    @Override
    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        try {
            String url = UrlUtils2.extractUrl((String)request.getHttpUrl());
            Map originData = UrlUtils2.extractUrlParamsFromUrl((String)request.getHttpUrl());
            this.LOGGER.info("[\u6d66\u60e0\u5230\u5bb6]\u865a\u62df\u5546\u54c1\u5151\u6362originData = [{}]", (Object)JSON.toJSONString((Object)originData));
            HttpPost httpPost = new HttpPost(url);
            JSONObject params = new JSONObject();
            Header[] headers = this.createHeaders(PhAppSerialNoEnum.VIRTUAL);
            httpPost.setHeaders(headers);
            params.put("couponId", originData.get("params"));
            params.put("phone", originData.get("uid"));
            Map<String, String> extraMap = request.getParams();
            this.LOGGER.info("[\u6d66\u60e0\u5230\u5bb6]\u865a\u62df\u5546\u54c1\u5151\u6362extraMap = [{}]", (Object)JSON.toJSONString(extraMap));
            if (Objects.nonNull(extraMap)) {
                params.put("ip", (Object)extraMap.get("ip"));
                String extraInfo = extraMap.get("extraInfo");
                if (StringUtils.isNotBlank((String)extraInfo)) {
                    String dvToken;
                    String eveSid;
                    String eveToken;
                    JSONObject extJson = JSON.parseObject((String)extraInfo);
                    String eveSource = extJson.getString("eveSource");
                    if (StringUtils.isNotBlank((String)eveSource)) {
                        params.put("eveSource", (Object)eveSource);
                    }
                    if (StringUtils.isNotBlank((String)(eveToken = extJson.getString("eveToken")))) {
                        params.put("eveToken", (Object)eveToken);
                    }
                    if (StringUtils.isNotBlank((String)(eveSid = extJson.getString("eveSid")))) {
                        params.put("eveSid", (Object)eveSid);
                    }
                    if (StringUtils.isNotBlank((String)(dvToken = extJson.getString("dvToken")))) {
                        params.put("dvToken", (Object)dvToken);
                    }
                }
            }
            this.LOGGER.info("[\u6d66\u60e0\u5230\u5bb6]\u865a\u62df\u5546\u54c1headers={}, \u5151\u6362\u53c2\u6570 = [{}]", (Object)JSON.toJSONString((Object)headers), (Object)JSON.toJSONString((Object)params));
            String paramStr = this.transferRequestParam(params);
            StringEntity stringEntity = new StringEntity(paramStr, "UTF-8");
            stringEntity.setContentEncoding("UTF-8");
            stringEntity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)stringEntity);
            httpPost.setConfig(this.config);
            Map authParams = (Map)JSON.parseObject((String)paramStr, Map.class);
            request.setAuthParams(authParams);
            request.setHttpUrl(url);
            return httpPost;
        }
        catch (Exception e) {
            this.LOGGER.error("[\u6d66\u60e0\u5230\u5bb6]\u865a\u62df\u5546\u54c1\u5151\u6362\u8bf7\u6c42\u751f\u6210\u5931\u8d25 orderId=" + request.getOrderId(), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getVirtualResponse(SupplierRequest request, String body) {
        JSONObject result = new JSONObject();
        try {
            JSONObject responseJson = JSON.parseObject((String)body);
            String value = responseJson.getString("value");
            if (StringUtils.isBlank((String)value)) {
                throw new IllegalStateException("\u5f00\u53d1\u8005\u8fd4\u56devalue\u5c5e\u6027\u4e3a\u7a7a\uff1a" + body);
            }
            String afterDecrypt = AESEncodeUtil.aesDecrypt(value, this.puhuiConfig.getAesSecret());
            if (Objects.equals(afterDecrypt, "404")) {
                throw new IllegalStateException("\u5f00\u53d1\u8005\u63a5\u53e3404");
            }
            String decoded = URLDecoder.decode(afterDecrypt, "UTF-8");
            this.LOGGER.info("[\u6d66\u60e0\u5230\u5bb6]\u89e3\u5bc6\u540eresponseBody=[{}]", (Object)decoded);
            JSONObject jsonObject = JSON.parseObject((String)decoded);
            Long responseCode = Optional.ofNullable(jsonObject.getLong("code")).orElse(-1L);
            if (responseCode != 20000L) {
                throw new IllegalStateException(jsonObject.getString("message"));
            }
            result.put("status", (Object)"success");
        }
        catch (Exception e) {
            result.put("status", (Object)"fail");
            result.put("errorMessage", (Object)e.getMessage());
            this.LOGGER.error("[\u6d66\u60e0\u5230\u5bb6]\u89e3\u6790\u865a\u62df\u5546\u54c1\u5151\u6362\u8bf7\u6c42\u7ed3\u679c\u5f02\u5e38 orderId=" + request.getOrderId(), (Throwable)e);
        }
        return result.toJSONString();
    }

    public Header[] createHeaders(PhAppSerialNoEnum serialNoEnum) {
        HashMap strMap = Maps.newHashMap();
        strMap.put("channelId", this.puhuiConfig.getChannelId());
        strMap.put("timestamp", DateUtils.getSecondStr((Date)new Date()));
        strMap.put("serialNo", this.createSerialNo(serialNoEnum));
        String sign = PuhuiUtils.signToRequest(strMap, this.puhuiConfig.getMd5Secret());
        strMap.put("sign", sign);
        return PuhuiUtils.getHeaders(strMap);
    }

    public String createSerialNo(PhAppSerialNoEnum serialNoEnum) {
        String newKey = serialNoEnum.getKey() + DateUtils.getDayStr((Date)new Date());
        Long startSerialNo = ((PhAppSerialNoEnum)PhAppSerialNoEnum.SERIAL_NO__MAP.get((Object)serialNoEnum.getKey())).getStartSerialNo();
        long value = startSerialNo - this.redisAtomicClient.incrBy(newKey, 1L, (long)DateUtils.getToTomorrowSeconds(), TimeUnit.SECONDS);
        if (value + 10000000L < startSerialNo || SpringEnvironmentUtils.isDevEnv() || SpringEnvironmentUtils.isTestEnv() || SpringEnvironmentUtils.isPreEnv()) {
            startSerialNo = PhAppSerialNoEnum.BACKUPS.getStartSerialNo();
            newKey = PhAppSerialNoEnum.BACKUPS.getKey() + DateUtils.getDayStr((Date)new Date());
            value = startSerialNo - this.redisAtomicClient.incrBy(newKey, 1L, (long)DateUtils.getToTomorrowSeconds(), TimeUnit.SECONDS);
        }
        return this.puhuiConfig.getChannelId() + value;
    }

    public String transferRequestParam(JSONObject params) {
        String requestJsonStr = JSON.toJSONString((Object)params);
        this.LOGGER.info("[\u6d66\u60e0\u5230\u5bb6]\u8bf7\u6c42\u5165\u53c2\u52a0\u5bc6\u524d:{}", (Object)requestJsonStr);
        String decode = "";
        try {
            decode = URLEncoder.encode(requestJsonStr, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.LOGGER.error("[\u6d66\u60e0\u5230\u5bb6]\u53c2\u6570\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
            return decode;
        }
        String value = AESEncodeUtil.aesEncrypt(decode, this.puhuiConfig.getAesSecret());
        String resp = JSONObject.toJSONString((Object)new JSONObject().fluentPut("value", (Object)value));
        this.LOGGER.info("[\u6d66\u60e0\u5230\u5bb6]\u8bf7\u6c42\u5165\u53c2\u52a0\u5bc6\u540e:{}", (Object)resp);
        return resp;
    }
}

