/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.zhiji.ZhiJiConfig;
import cn.com.duiba.consumer.center.api.dto.ConsumerExtraDto;
import cn.com.duiba.consumer.center.api.remoteservice.RemoteConsumerExtraService;
import cn.com.duiba.credits.sdk.AddCreditsParams;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.ZhijiAddCreditsDataReq;
import cn.com.duiba.domain.ZhijiAddCreditsReqBody;
import cn.com.duiba.domain.ZhijiAddCreditsReqData;
import cn.com.duiba.domain.ZhijiAddCreditsReqPointList;
import cn.com.duiba.domain.ZhijiAddCreditsRequest;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteConsumerOrderSimpleService;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.zhiji.ZhiJiParamTool;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ZhiJiApiStrategy
implements ApiStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZhiJiApiStrategy.class);
    private final RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(10000).setConnectionRequestTimeout(500).build();
    private static final int FIVE_SECONDS = 5000;
    private static final int TEN_SECONDS = 10000;
    private static final String ROLLBACK = "rollback-";
    @Autowired
    private ZhiJiConfig zhiJiConfig;
    @Autowired
    private ZhiJiParamTool zhiJiParamTool;
    @Autowired
    private RemoteConsumerExtraService remoteConsumerExtraService;
    @Autowired
    private RemoteConsumerOrderSimpleService remoteConsumerOrderSimpleService;

    @Override
    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        try {
            HttpPost httpPost = new HttpPost(this.zhiJiConfig.getDomainName() + this.zhiJiConfig.getAddCreditsUrl());
            AddCreditsParams addCreditsParams = message.getAddCreditsParams();
            ZhijiAddCreditsReqPointList pointList = new ZhijiAddCreditsReqPointList();
            pointList.setAccrualPoints(addCreditsParams.getCredits().intValue());
            ZhijiAddCreditsDataReq dataReq = new ZhijiAddCreditsDataReq();
            dataReq.setPointList(pointList);
            ZhijiAddCreditsReqData reqData = new ZhijiAddCreditsReqData();
            reqData.setListOfIMAccruePointsInput(dataReq);
            ZhijiAddCreditsReqBody body = new ZhijiAddCreditsReqBody();
            ConsumerExtraDto result = (ConsumerExtraDto)this.remoteConsumerExtraService.findByConsumerId(Long.valueOf(message.getConsumerId())).getResult();
            if (Objects.isNull(result) || StringUtils.isBlank((CharSequence)result.getJson())) {
                LOGGER.info("\u3010\u667a\u51e0\u6c7d\u8f66\u3011\u83b7\u53d6\u7528\u6237\u6269\u5c55\u5b57\u6bb5 \u51fa\u9519");
                throw new BizException("\u83b7\u53d6\u7528\u6237\u6269\u5c55\u5b57\u6bb5 \u51fa\u9519");
            }
            body.setSuperId(JSON.parseObject((String)result.getJson()).getString("sid"));
            body.setData(reqData);
            String orderNum = addCreditsParams.getOrderNum();
            if (Objects.equals(addCreditsParams.getType(), "postsale")) {
                orderNum = StringUtils.isBlank((CharSequence)addCreditsParams.getSubOrderNum()) ? addCreditsParams.getOrderNum() : addCreditsParams.getSubOrderNum();
            }
            body.setTraceId(orderNum);
            body.setTransactionNumber(orderNum);
            String transactionType = StringUtils.isBlank((CharSequence)addCreditsParams.getDescription()) ? "\u5151\u6362\u5546\u54c1" : addCreditsParams.getDescription();
            body.setTransactionType(transactionType.length() > 30 ? transactionType.substring(0, 30) : transactionType);
            String transfer = message.getAddCreditsParams().getTransfer();
            body.setTransactionTime(transfer);
            ZhijiAddCreditsRequest request = new ZhijiAddCreditsRequest();
            request.setBody(body);
            Map map = BeanUtils.transBeanToMap((Object)request);
            LOGGER.info("\u3010\u667a\u51e0\u6c7d\u8f66\u3011\u52a0\u79ef\u5206\u8bf7\u6c42\uff0curl:{},params:{}", (Object)this.zhiJiConfig.getAddCreditsUrl(), (Object)JSON.toJSONString((Object)map));
            httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)request), "UTF-8"));
            String signature = this.zhiJiParamTool.buildHttpHeader(body, this.zhiJiConfig.getAddCreditsUrl(), (HttpRequestBase)httpPost);
            if (signature == null) {
                LOGGER.warn("\u667a\u5df1-\u6263\u79ef\u5206\u53c2\u6570\u52a0\u5bc6\u5f02\u5e38\uff0cbody:{},message:{}", (Object)body, (Object)JSON.toJSONString((Object)message));
                return null;
            }
            httpPost.setConfig(this.requestConfig);
            return httpPost;
        }
        catch (Exception e) {
            LOGGER.warn("\u3010\u667a\u51e0\u6c7d\u8f66\u3011\u7ec4\u88c5\u52a0\u79ef\u5206\u63a5\u53e3\u53c2\u6570\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    @Override
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record) {
        try {
            LOGGER.info("\u667a\u5df1 getRequestNotify = {}", (Object)JSON.toJSONString((Object)record));
            HttpPost httpPost = new HttpPost(this.zhiJiConfig.getDomainName() + this.zhiJiConfig.getAddCreditsUrl());
            String duibaOrderNum = record.getDuibaOrderNum();
            OrdersDto ordersDto = (OrdersDto)this.remoteConsumerOrderSimpleService.findByOrderNum(duibaOrderNum).getResult();
            ZhijiAddCreditsReqPointList pointList = new ZhijiAddCreditsReqPointList();
            pointList.setAccrualPoints(ordersDto.getCredits().intValue());
            pointList.setPointSubType("Adjust");
            ZhijiAddCreditsDataReq dataReq = new ZhijiAddCreditsDataReq();
            dataReq.setPointList(pointList);
            ZhijiAddCreditsReqData reqData = new ZhijiAddCreditsReqData();
            reqData.setListOfIMAccruePointsInput(dataReq);
            ZhijiAddCreditsReqBody body = new ZhijiAddCreditsReqBody();
            ConsumerExtraDto result = (ConsumerExtraDto)this.remoteConsumerExtraService.findByConsumerId(record.getConsumerId()).getResult();
            if (Objects.isNull(result) || StringUtils.isBlank((CharSequence)result.getJson())) {
                throw new BizException("\u901a\u77e5\u56de\u6eda \u83b7\u53d6\u7528\u6237\u6269\u5c55\u5b57\u6bb5 \u51fa\u9519");
            }
            body.setSuperId(JSON.parseObject((String)result.getJson()).getString("sid"));
            body.setData(reqData);
            body.setTraceId(ROLLBACK + duibaOrderNum);
            body.setTransactionNumber(ROLLBACK + duibaOrderNum);
            body.setTransactionType(ordersDto.getBrief() + "\u53d6\u6d88\u8fd4\u8fd8");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            body.setTransactionTime(simpleDateFormat.format(new Date()));
            ZhijiAddCreditsRequest request = new ZhijiAddCreditsRequest();
            request.setBody(body);
            Map map = BeanUtils.transBeanToMap((Object)request);
            LOGGER.info("\u3010\u667a\u51e0\u6c7d\u8f66\u3011\u901a\u77e5\u56de\u6eda \u52a0\u79ef\u5206\u8bf7\u6c42\uff0curl:{},params:{}", (Object)this.zhiJiConfig.getAddCreditsUrl(), (Object)JSON.toJSONString((Object)map));
            httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)request), "UTF-8"));
            String signature = this.zhiJiParamTool.buildHttpHeader(body, this.zhiJiConfig.getAddCreditsUrl(), (HttpRequestBase)httpPost);
            if (signature == null) {
                LOGGER.warn("\u667a\u5df1-\u901a\u77e5\u56de\u6eda\u53c2\u6570\u52a0\u5bc6\u5f02\u5e38\uff0cbody:{},message:{}", (Object)body, (Object)JSON.toJSONString((Object)record));
                return null;
            }
            httpPost.setConfig(this.requestConfig);
            return httpPost;
        }
        catch (Exception e) {
            LOGGER.warn("\u3010\u667a\u51e0\u6c7d\u8f66\u3011\u901a\u77e5\u56de\u6eda \u7ec4\u88c5\u52a0\u79ef\u5206\u63a5\u53e3\u53c2\u6570\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    @Override
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        try {
            HttpPost httpPost = new HttpPost(this.zhiJiConfig.getDomainName() + this.zhiJiConfig.getSubCreditsUrl());
            Map<String, String> originData = AssembleTool.getUrlParams(ZhiJiApiStrategy.getParamUrl(message.getHttpUrl()));
            LOGGER.info("\u667a\u5df1-\u6263\u79ef\u5206\u53c2\u6570\uff0cparams\uff1a{}", (Object)JSON.toJSONString(originData));
            HashMap requestParams = Maps.newHashMap();
            String transactionType = StringUtils.isBlank((CharSequence)originData.get("description")) ? "\u5151\u6362\u5546\u54c1" : originData.get("description");
            requestParams.put("TransactionType", transactionType.length() > 30 ? transactionType.substring(0, 30) : transactionType);
            requestParams.put("RedeemNumber", originData.get("orderNum"));
            requestParams.put("TraceId", originData.get("orderNum") + this.zhiJiParamTool.generateRandom());
            Map customParams = message.getSubCreditsMsg().getParams();
            requestParams.put("superId", customParams.get("superId"));
            requestParams.put("RedeemTime", customParams.get("TransactionTime"));
            requestParams.put("SourceCode", "DUIBA");
            HashMap data = new HashMap(1);
            HashMap lostOfPointList = new HashMap(1);
            HashMap<String, String> pointList = new HashMap<String, String>(2);
            pointList.put("Type", "Point");
            pointList.put("RedeemPoints", originData.get("credits"));
            lostOfPointList.put("PointList", pointList);
            data.put("ListOfPointList", lostOfPointList);
            requestParams.put("Data", data);
            HashMap<String, HashMap> body = new HashMap<String, HashMap>(1);
            body.put("body", requestParams);
            LOGGER.info("\u667a\u5df1-\u6263\u79ef\u5206\u53c2\u6570\uff0curl\uff1a{}\uff0cbody\uff1a{}\uff0cmessage\uff1a{}", new Object[]{this.zhiJiConfig.getSubCreditsUrl(), body, JSON.toJSONString((Object)message)});
            httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString(body), "UTF-8"));
            String signature = this.zhiJiParamTool.buildHttpHeader(body, this.zhiJiConfig.getSubCreditsUrl(), (HttpRequestBase)httpPost);
            if (signature == null) {
                LOGGER.warn("\u667a\u5df1-\u6263\u79ef\u5206\u53c2\u6570\u52a0\u5bc6\u5f02\u5e38\uff0cbody:{},message:{}", body, (Object)JSON.toJSONString((Object)message));
                return null;
            }
            httpPost.setConfig(this.requestConfig);
            return httpPost;
        }
        catch (Exception e) {
            LOGGER.warn("\u667a\u5df1-\u6263\u79ef\u5206\u53c2\u6570\u52a0\u5bc6\u5f02\u5e38\uff0cmessage:{}", (Object)JSON.toJSONString((Object)message), (Object)e);
            return null;
        }
    }

    @Override
    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {
        LOGGER.info("\u667a\u5df1-\u79ef\u5206\u8fd4\u56de\u53c2\u6570\uff0cparams\uff1a{}", (Object)body);
        JSONObject response = JSON.parseObject((String)body);
        JSONObject result = new JSONObject();
        result.put("bizId", response.get((Object)"TxnId"));
        if (Objects.equals("0", response.get((Object)"ErrorCode"))) {
            result.put("status", (Object)"ok");
        } else {
            result.put("status", (Object)"fail");
        }
        result.put("errorMessage", response.get((Object)"ErrorMessage"));
        return result.toJSONString();
    }

    public static String getParamUrl(String url) {
        return url.substring(url.indexOf(63) + 1);
    }

    public static void main(String[] args) {
        Date now = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        System.out.printf(simpleDateFormat.format(now), new Object[0]);
    }

    @Override
    public Boolean appIdCheck(Long appId) {
        return this.zhiJiConfig.getAppIds().contains(appId);
    }
}

